/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.common.ExternalProgramExecuter;
import jp.advancesoft.chase.common.InputPanel;
import jp.advancesoft.chase.common.MyMessageBox;
import jp.advancesoft.chase.mainpanel.Chase;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.phase.FileNamesData;
import jp.advancesoft.chase.settings.PropertiesManager;

public class FileNamesFrame
extends InternalFrameChase {
    private Container cont;
    private Chase parent;
    private MyMessageBox mbox;
    private InputPanel f_dynm;
    private InputPanel f_enf;
    private InputPanel f_chr;
    private InputPanel f_dos;
    private InputPanel f_energ;
    private InputPanel f_zaj;
    private InputPanel f_chgt;
    private InputPanel f_cntn;
    private InputPanel f_cntn_bin;
    private InputPanel f_output;
    private InputPanel f_kpoint;
    private JPanel pcfnf;
    private JButton btnsave;
    private JButton btnclose;
    private JButton btnsaveclose;
    private JButton btndefault;
    private JButton btnedit;
    private String projdir = new String();
    private String fname_org;
    private String fname = this.fname_org = "file_names.data";
    private FileNamesData fndata;
    public static final String FN_DATA = "file_names.data";

    public FileNamesFrame(Chase frame) {
        super("other files", true, true, true, true);
        this.setDefaultCloseOperation(1);
        this.parent = frame;
        this.cont = this.getContentPane();
        this.mbox = new MyMessageBox();
        this.pcfnf = this.createFileNamesFrame();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        this.cont.add(this.pcfnf);
        JPanel pfile = new JPanel();
        pfile.setLayout(new BoxLayout(pfile, 1));
        this.f_output = new InputPanel("", 0, 10);
        this.f_dynm = new InputPanel("F_DYNM", 0, 10);
        this.f_enf = new InputPanel("F_ENF", 0, 10);
        this.f_chr = new InputPanel("F_CHR", 0, 10);
        this.f_dos = new InputPanel("F_DOS", 0, 10);
        this.f_energ = new InputPanel("F_ENERG", 0, 10);
        this.f_zaj = new InputPanel("F_ZAJ", 0, 10);
        this.f_chgt = new InputPanel("F_CHGT", 0, 10);
        this.f_cntn = new InputPanel("F_CNTN", 0, 10);
        this.f_cntn_bin = new InputPanel("F_CNTN_BIN", 0, 10);
        pfile.add(this.f_dynm);
        pfile.add(this.f_enf);
        pfile.add(this.f_chr);
        pfile.add(this.f_dos);
        pfile.add(this.f_energ);
        pfile.add(this.f_zaj);
        pfile.add(this.f_chgt);
        pfile.add(this.f_cntn);
        pfile.add(this.f_cntn_bin);
        pfile.setBorder(new TitledBorder("files"));
        this.cont.add(pfile);
        this.cont.add(Box.createVerticalStrut(30));
        JPanel pclose = new JPanel();
        pclose.setLayout(new BoxLayout(pclose, 0));
        this.btnedit = new JButton("edit");
        pclose.add(this.btnedit);
        this.btndefault = new JButton("set default file names");
        pclose.add(this.btndefault);
        this.btnsave = new JButton("save");
        pclose.add(this.btnsave);
        this.btnsaveclose = new JButton("save and close");
        pclose.add(this.btnsaveclose);
        this.btnclose = new JButton("close");
        pclose.add(this.btnclose);
        this.cont.add(pclose);
        this.setBackground(Color.gray.brighter());
        this.setResizable(true);
        this.setSize(500, 600);
        this.setVisible(false);
        this.btnedit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ExternalProgramExecuter.execute(PropertiesManager.getGlobalProperties(0).getProperty("editor") + " " + FileNamesFrame.this.projdir + FileNamesFrame.FN_DATA);
                }
                catch (Exception exception) {
                    FileNamesFrame.this.mbox.setText("failed to run editor");
                }
            }
        });
        this.btndefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileNamesFrame.this.setDefaultFileNames();
            }
        });
        this.btnsave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileNamesFrame.this.save_input();
            }
        });
        this.btnsaveclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileNamesFrame.this.save_input();
                FileNamesFrame.this.dispose();
            }
        });
        this.btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileNamesFrame.this.clear_inp();
                FileNamesFrame.this.dispose();
            }
        });
    }

    public int display() {
        this.setVisible(true);
        return 0;
    }

    public void setFNData(FileNamesData fndata) {
        this.fndata = fndata;
    }

    public void setFileNames() {
        String file_namesData = this.projdir + FN_DATA;
        Vector vector = new Vector();
        String[] fileNames = this.fndata.getFileNames();
        String[] identifiers = this.fndata.getIdentifiers();
        for (int i = 0; i < fileNames.length; ++i) {
            if (identifiers[i].equalsIgnoreCase("F_DYNM")) {
                this.f_dynm.setValue(fileNames[i]);
            }
            if (identifiers[i].equalsIgnoreCase("F_ENF")) {
                this.f_enf.setValue(fileNames[i]);
            }
            if (identifiers[i].equalsIgnoreCase("F_CHR")) {
                this.f_chr.setValue(fileNames[i]);
            }
            if (identifiers[i].equalsIgnoreCase("F_DOS")) {
                this.f_dos.setValue(fileNames[i]);
            }
            if (identifiers[i].equalsIgnoreCase("F_ENERG")) {
                this.f_energ.setValue(fileNames[i]);
            }
            if (identifiers[i].equalsIgnoreCase("F_ZAJ")) {
                this.f_zaj.setValue(fileNames[i]);
            }
            if (identifiers[i].equalsIgnoreCase("F_CHGT")) {
                this.f_chgt.setValue(fileNames[i]);
            }
            if (identifiers[i].equalsIgnoreCase("F_CNTN")) {
                this.f_cntn.setValue(fileNames[i]);
            }
            if (!identifiers[i].equalsIgnoreCase("F_CNTN_BIN")) continue;
            this.f_cntn_bin.setValue(fileNames[i]);
        }
    }

    private JPanel createFileNamesFrame() {
        JPanel p = new JPanel();
        p.setBackground(Color.gray.brighter());
        p.setLayout(new BoxLayout(p, 1));
        p.setSize(300, 600);
        return p;
    }

    public String getFname() {
        return this.fname;
    }

    public void save_input() {
        this.fndata.setFileName("F_KPOINT", "kpoint.data");
        this.fndata.setFileName("F_DYNM", this.f_dynm.getValue());
        this.fndata.setFileName("F_ENF", this.f_enf.getValue());
        this.fndata.setFileName("F_CHR", this.f_chr.getValue());
        this.fndata.setFileName("F_DOS", this.f_dos.getValue());
        this.fndata.setFileName("F_ENERG", this.f_energ.getValue());
        this.fndata.setFileName("F_ZAJ", this.f_zaj.getValue());
        this.fndata.setFileName("F_CHGT", this.f_chgt.getValue());
        this.fndata.setFileName("F_CNTN", this.f_cntn.getValue());
        this.fndata.setFileName("F_CNTN_BIN", this.f_cntn_bin.getValue());
        this.fndata.writeTo(this.projdir + FN_DATA);
    }

    public int setProjDir(String inpdir) {
        this.projdir = inpdir;
        this.fndata.read();
        this.setFileNames();
        return 0;
    }

    public String getProjDir() {
        return this.projdir;
    }

    private int clear_inp() {
        return 0;
    }

    private int setDefaultFileNames() {
        this.f_dynm.setValue("nfdynm.data");
        this.f_enf.setValue("nfene.data");
        this.f_chr.setValue("nfchr.cube");
        this.f_dos.setValue("dos.data");
        this.f_energ.setValue("nfenergy.data");
        this.f_zaj.setValue("nfzaj.data");
        this.f_chgt.setValue("nfchgt.data");
        this.f_cntn.setValue("continue.data");
        this.f_cntn_bin.setValue("continue_bin.data");
        return 0;
    }
}

