/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.graph;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import jp.advancesoft.chase.common.Drawable;
import jp.advancesoft.chase.common.PDFExporter;
import jp.advancesoft.chase.common.SVGExporter;
import jp.advancesoft.chase.graph.PlotShapesAndLines;
import jp.advancesoft.chase.graph.PropertyEditor;
import jp.advancesoft.chase.graph.chart.ChartCreator;
import jp.advancesoft.chase.graph.dataset.PlotProperties;
import jp.advancesoft.chase.graph.plotattributes.PlotAttributesEditor;
import jp.advancesoft.chase.mainpanel.Desktop;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import org.apache.log4j.Logger;
import org.freehep.util.export.ExportDialog;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYImageAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class GraphPanel
extends InternalFrameChase
implements Drawable {
    private Logger logger = Logger.getLogger(GraphPanel.class.getName());
    private JFreeChart chart;
    private int type = 0;
    private JDesktopPane desktop = Desktop.getDesktop();
    private String deftiltle = "graph panel";
    private String title = null;
    private String xlabel = "x";
    private String ylabel = "y";
    private String plottitle = null;
    private String ticunitsx = "1";
    private String ticunitsy = "1";
    private String xaxismax = "10";
    private String yaxismax = "10";
    private String xaxismin = "-10";
    private String yaxismin = "-10";
    private String ticunits = "";
    private String[][] data;
    private String[] legendtext;
    private String legendanchor;
    private boolean blegend = false;
    private boolean bantialias = false;
    private boolean bgridx = false;
    private boolean bgridy = false;
    private boolean blogx = false;
    private boolean blogy = false;
    private Color plotcolor = Color.WHITE;
    private Color chartcolor = Color.WHITE;
    private int ticmodex = 0;
    private int ticmodey = 0;
    private int xaxisrangemode = 0;
    private int yaxisrangemode = 0;
    private int NumSeries = 0;
    private int[] plottype;
    private boolean[] bplotdefault;
    private int[] linetype;
    private int[] shapetype;
    private float[] linewidth;
    private double[] shapesize;
    private float linewidth_wk;
    private double shapesize_wk;
    private Color[] seriescolor;
    private double defaultshapesize = 6.0;
    private float defaultlinewidth = 1.0f;
    private Font titlefont = new Font("Helvetica", 1, 12);
    private Font legendfont = new Font("Helvetica", 0, 10);
    private Font xaxisfont = new Font("Helvetica", 0, 10);
    private Font yaxisfont = new Font("Helvetica", 0, 10);
    private Font xaxisticfont = new Font("Helvetica", 0, 10);
    private Font yaxisticfont = new Font("Helvetica", 0, 10);
    private Font textanfont = new Font("Helvetica", 0, 12);
    private String textantext = new String();
    private double textanposx = 0.0;
    private double textanposy = 0.0;
    private int textanmode = 0;
    private double textanrotation = 0.0;
    private boolean bpointerAnnotation = false;
    private double pointerAnnotationX = 0.0;
    private double pointerAnnotationY = 0.0;
    private double pointerAnnotationRot = 0.0;
    private double pointerAnnotationBase = 35.0;
    private String pointerAnnotationLabel = "";
    private Font pointerAnnotationFont = new Font("Helvetica", 0, 10);
    private double pointerAnnotationOffset = 0.0;
    private String imageFileName;
    private double imageScale = 1.0;
    private double imagePosX = 0.0;
    private double imagePosY = 0.0;
    private ChartPanel chartPanel;
    private XYSeriesCollection dataset = new XYSeriesCollection();
    private XYSeriesCollection dataset2 = new XYSeriesCollection();
    private DefaultPieDataset datasetpie = new DefaultPieDataset();
    private Container cont;
    private Vector propVector = new Vector();
    private String projdir = new String();
    private ChartCreator chartCreator;
    private PlotProperties plotProperties;
    private PlotAttributesEditor paeditor;

    public GraphPanel(String title, String[][] data) {
        super(title, true, true, true, true, new Dimension(512, 512));
        this.title = title;
        this.data = data;
        this.createXYSeriesCollection(true);
        this.addDestroyer();
    }

    public GraphPanel(String title) {
        super(title, true, true, true, true, new Dimension(512, 512));
        this.title = title;
        this.addDestroyer();
    }

    public GraphPanel(String title, PlotProperties properties) {
        super(title, true, true, true, true, new Dimension(512, 512));
        this.plotProperties = properties;
        this.chartCreator = new ChartCreator();
        this.chart = this.chartCreator.getChart(properties);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        this.chartPanel = new ChartPanel(this.chart, true, true, true, true, true);
        this.chartPanel.setPreferredSize(this.getSize());
        container.add(this.chartPanel);
        container.add(this.createButtonPanel());
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public PlotProperties getPlotProperties() {
        return this.plotProperties;
    }

    public String toString() {
        return "title: " + this.title;
    }

    private void addDestroyer() {
        this.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameClosed(InternalFrameEvent ec) {
            }

            public void internalFrameActivated(InternalFrameEvent ea) {
            }

            public void internalFrameClosing(InternalFrameEvent eclosing) {
                GraphPanel.this.destroy();
            }

            public void internalFrameDeactivated(InternalFrameEvent edea) {
            }

            public void internalFrameDeiconified(InternalFrameEvent edei) {
            }

            public void internalFrameIconified(InternalFrameEvent ei) {
            }

            public void internalFrameOpened(InternalFrameEvent eo) {
            }
        });
    }

    private void destroy() {
        for (int i = 0; i < this.propVector.size(); ++i) {
            PropertyEditor pe = (PropertyEditor)this.propVector.get(i);
            if (pe == null) continue;
            pe.dispose();
        }
        this.dispose();
    }

    public void createGraphPanel() {
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        this.cont.add(this.createGraph());
        this.updateChart();
        this.chartPanel.setChart(this.chart);
        this.cont.add(this.createButtonPanel());
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setXlabel(String xlabel) {
        this.xlabel = xlabel;
    }

    public String getXlabel() {
        return this.xlabel;
    }

    public void setXAxisFont(Font xaxisfont) {
        this.xaxisfont = xaxisfont;
    }

    public void setYAxisFont(Font yaxisfont) {
        this.yaxisfont = yaxisfont;
    }

    public void setYlabel(String ylabel) {
        this.ylabel = ylabel;
    }

    public String getYlabel() {
        return this.ylabel;
    }

    public void setPlotTitle(String plottitle) {
        this.plottitle = plottitle;
    }

    public String getPlotTitle() {
        return this.plottitle;
    }

    public void setPlotTitleFont(Font titlefont) {
        this.titlefont = titlefont;
    }

    public void setData(String[][] data) {
        this.data = data;
        if (this.type == 0) {
            this.createXYSeriesCollection(true);
        } else if (this.type == 1) {
            this.createPieData();
        }
    }

    public String[][] getData() {
        return this.data;
    }

    public void setDrawLegendOrNot(boolean blegend) {
        this.blegend = blegend;
    }

    public boolean getDrawLegendOrNot() {
        return this.blegend;
    }

    public void setLegendText(String[] legendtext) {
        this.legendtext = legendtext;
    }

    public String[] getLegendText() {
        return this.legendtext;
    }

    public void setLegendFont(Font legendfont) {
        this.legendfont = legendfont;
    }

    public Font getLegendFont() {
        return this.legendfont;
    }

    public void setLegendAnchor(String legendanchor) {
        this.legendanchor = legendanchor;
    }

    public void setAntiAlias(boolean bantialias) {
        this.bantialias = bantialias;
    }

    public boolean getAntiAlias() {
        return this.bantialias;
    }

    public void setTicModeXAxis(int ticmodex) {
        this.ticmodex = ticmodex;
    }

    public void setTicModeYAxis(int ticmodey) {
        this.ticmodey = ticmodey;
    }

    public void setTicUnitsXAxis(String ticunitsx) {
        this.ticunitsx = ticunitsx;
    }

    public void setTicUnitsYAxis(String ticunitsy) {
        this.ticunitsy = ticunitsy;
    }

    public void setTicFontXAxis(Font xaxisticfont) {
        this.xaxisticfont = xaxisticfont;
    }

    public void setTicFontYAxis(Font yaxisticfont) {
        this.yaxisticfont = yaxisticfont;
    }

    public void setXAxisRangeMode(int xaxisrangemode) {
        this.xaxisrangemode = xaxisrangemode;
    }

    public void setYAxisRangeMode(int yaxisrangemode) {
        this.yaxisrangemode = yaxisrangemode;
    }

    public void setXAxisMax(String xaxismax) {
        this.xaxismax = xaxismax;
    }

    public void setXAxisMin(String xaxismin) {
        this.xaxismin = xaxismin;
    }

    public void setYAxisMax(String yaxismax) {
        this.yaxismax = yaxismax;
    }

    public void setYAxisMin(String yaxismin) {
        this.yaxismin = yaxismin;
    }

    public void setDrawGridX(boolean bgridx) {
        this.bgridx = bgridx;
    }

    public void setDrawGridY(boolean bgridy) {
        this.bgridy = bgridy;
    }

    public void setLogX(boolean blogx) {
        this.blogx = blogx;
    }

    public void setLogY(boolean blogy) {
        this.blogy = blogy;
    }

    public void setPlotColor(Color plotcolor) {
        this.plotcolor = plotcolor;
    }

    public Color getPlotColor() {
        return this.plotcolor;
    }

    public void setChartColor(Color chartcolor) {
        this.chartcolor = chartcolor;
    }

    public Color getChartColor() {
        return this.chartcolor;
    }

    public void setPlotDefault(boolean[] bplotdefault) {
        this.bplotdefault = bplotdefault;
    }

    public boolean[] getPlotDefault() {
        return this.bplotdefault;
    }

    public void setNumSeries(int NumSeries) {
        this.NumSeries = NumSeries;
    }

    public int getNumSeries() {
        return this.NumSeries;
    }

    public void setPlotType(int[] plottype) {
        this.plottype = plottype;
    }

    public int[] getPlotType() {
        return this.plottype;
    }

    public void setLineType(int[] linetype) {
        this.linetype = linetype;
    }

    public int[] getLineType() {
        return this.linetype;
    }

    public void setShapeType(int[] shapetype) {
        this.shapetype = shapetype;
    }

    public int[] getShapeType() {
        return this.shapetype;
    }

    public void setLineWidth(float[] linewidth) {
        this.linewidth = linewidth;
    }

    public float[] getLineWidth() {
        return this.linewidth;
    }

    public void setShapeSize(double[] shapesize) {
        this.shapesize = shapesize;
    }

    public double[] getShapeSize() {
        return this.shapesize;
    }

    public void setSeriesColor(Color[] seriescolor) {
        this.seriescolor = seriescolor;
    }

    public Color[] getSeriesColor() {
        return this.seriescolor;
    }

    public void setTextAnnotationFont(Font textanfont) {
        this.textanfont = textanfont;
    }

    public Font getTextAnnotationFont() {
        return this.textanfont;
    }

    public void setTextAnnotationText(String textantext) {
        this.textantext = textantext;
    }

    public String getTextAnnotationText() {
        return this.textantext;
    }

    public void setTextAnnotationPosX(double textanposx) {
        this.textanposx = textanposx;
    }

    public double getTextAnnotationPosX() {
        return this.textanposx;
    }

    public void setTextAnnotationPosY(double textanposy) {
        this.textanposy = textanposy;
    }

    public double getTextAnnotationPosY() {
        return this.textanposy;
    }

    public void setTextAnnotationRotAngle(double textanrotation) {
        this.textanrotation = textanrotation;
    }

    public double getTextAnnotationRotAngle() {
        return this.textanrotation;
    }

    public void setTextAnnotationMode(int textanmode) {
        this.textanmode = textanmode;
    }

    public int getTextAnnotationMode() {
        return this.textanmode;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setImageScale(double imageScale) {
        this.imageScale = imageScale;
    }

    public double getImageScale() {
        return this.imageScale;
    }

    public void setImagePosX(double imagePosX) {
        this.imagePosX = imagePosX;
    }

    public double getImagePosX() {
        return this.imagePosX;
    }

    public void setImagePosY(double imagePosY) {
        this.imagePosY = imagePosY;
    }

    public double getImagePosY() {
        return this.imagePosY;
    }

    public void setPointerAnnotation(boolean bpointerAnnotation) {
        this.bpointerAnnotation = bpointerAnnotation;
    }

    public boolean getPointerAnnotation() {
        return this.bpointerAnnotation;
    }

    public void setPointerAnnotationX(double pointerAnnotationX) {
        this.pointerAnnotationX = pointerAnnotationX;
    }

    public double getPointerAnnotationX() {
        return this.pointerAnnotationX;
    }

    public void setPointerAnnotationY(double pointerAnnotationY) {
        this.pointerAnnotationY = pointerAnnotationY;
    }

    public double getPointerAnnotationY() {
        return this.pointerAnnotationY;
    }

    public void setPointerAnnotationRot(double pointerAnnotationRot) {
        this.pointerAnnotationRot = pointerAnnotationRot;
    }

    public double getPointerAnnotationRot() {
        return this.pointerAnnotationRot;
    }

    public void setPointerAnnotationBase(double pointerAnnotationBase) {
        this.pointerAnnotationBase = pointerAnnotationBase;
    }

    public double getPointerAnnotationBase() {
        return this.pointerAnnotationBase;
    }

    public void setPointerAnnotationLabel(String pointerAnnotationLabel) {
        this.pointerAnnotationLabel = pointerAnnotationLabel;
    }

    public String getPointerAnnotationLabel() {
        this.pointerAnnotationLabel = this.pointerAnnotationLabel;
        return this.pointerAnnotationLabel;
    }

    public void setPointerAnnotationFont(Font pointerAnnotationFont) {
        this.pointerAnnotationFont = pointerAnnotationFont;
    }

    public Font getPointerAnnotationFont() {
        return this.pointerAnnotationFont;
    }

    public void setPointerAnnotationOffset(double pointerAnnotationOffset) {
        this.pointerAnnotationOffset = pointerAnnotationOffset;
    }

    public double getPointerAnnotationOffset() {
        return this.pointerAnnotationOffset;
    }

    public void display() {
        this.setVisible(true);
    }

    public void updateChartPanel() {
        this.updateChart();
    }

    private void createXYSeriesCollection(boolean cleardataset) {
        double ydata;
        double xdata;
        XYSeries s1;
        int i;
        if (cleardataset) {
            this.dataset.removeAllSeries();
            this.NumSeries = 0;
        }
        String strdatax = new String();
        String strdatay = new String();
        try {
            for (i = 1; i < this.legendtext.length; ++i) {
                s1 = new XYSeries((Comparable)((Object)this.legendtext[i]), true, true);
                for (int j = 0; j < this.data[i].length; ++j) {
                    strdatax = this.data[0][j].trim();
                    strdatax = strdatax.replace('D', 'E');
                    strdatax = strdatax.replace('d', 'E');
                    strdatay = this.data[i][j].trim();
                    strdatay = strdatay.replace('D', 'E');
                    if ((strdatay = strdatay.replace('d', 'E')).length() == 0) {
                        s1.add(Double.parseDouble(this.data[0][j]), (Number)null);
                        continue;
                    }
                    xdata = this.blogx ? Math.abs(Double.parseDouble(strdatax)) : Double.parseDouble(strdatax);
                    ydata = this.blogy ? Math.abs(Double.parseDouble(strdatay)) : Double.parseDouble(strdatay);
                    s1.add(xdata, ydata);
                }
                this.dataset.addSeries(s1);
            }
        }
        catch (Exception e) {
            System.out.println("no legend-text specified");
            for (int i2 = 1; i2 < this.data.length; ++i2) {
                s1 = new XYSeries((Comparable)((Object)new String("y" + Integer.toString(i2))), true, true);
                for (int j = 0; j < this.data[i2].length; ++j) {
                    strdatax = this.data[0][j].trim();
                    strdatax = strdatax.replace('D', 'E');
                    strdatax = strdatax.replace('d', 'E');
                    strdatay = this.data[i2][j].trim();
                    strdatay = strdatay.replace('D', 'E');
                    if ((strdatay = strdatay.replace('d', 'E')).length() == 0) {
                        s1.add(Double.parseDouble(this.data[0][j]), (Number)null);
                        continue;
                    }
                    xdata = this.blogx ? Math.abs(Double.parseDouble(strdatax)) : Double.parseDouble(strdatax);
                    ydata = this.blogy ? Math.abs(Double.parseDouble(strdatay)) : Double.parseDouble(strdatay);
                    s1.add(xdata, ydata);
                }
                this.dataset.addSeries(s1);
            }
        }
        this.NumSeries = this.dataset.getSeriesCount();
        this.bplotdefault = new boolean[this.NumSeries];
        this.plottype = new int[this.NumSeries];
        this.linewidth = new float[this.NumSeries];
        this.shapesize = new double[this.NumSeries];
        this.linetype = new int[this.NumSeries];
        this.shapetype = new int[this.NumSeries];
        this.seriescolor = new Color[this.NumSeries];
        for (i = 0; i < this.NumSeries; ++i) {
            this.bplotdefault[i] = true;
            this.plottype[i] = 0;
            this.linewidth[i] = this.defaultlinewidth;
            this.shapesize[i] = this.defaultshapesize;
            this.linetype[i] = 0;
            this.shapetype[i] = 0;
        }
    }

    private void createPieData() {
        int i;
        this.NumSeries = 2;
        for (i = 0; i < this.data[0].length; ++i) {
            this.datasetpie.setValue((Comparable)((Object)this.data[0][i]), Double.parseDouble(this.data[1][i]));
        }
        this.bplotdefault = new boolean[this.NumSeries];
        this.plottype = new int[this.NumSeries];
        this.linewidth = new float[this.NumSeries];
        this.shapesize = new double[this.NumSeries];
        this.linetype = new int[this.NumSeries];
        this.shapetype = new int[this.NumSeries];
        this.seriescolor = new Color[this.NumSeries];
        for (i = 0; i < this.NumSeries; ++i) {
            this.bplotdefault[i] = true;
            this.plottype[i] = 0;
            this.linewidth[i] = this.defaultlinewidth;
            this.shapesize[i] = this.defaultshapesize;
            this.linetype[i] = 0;
            this.shapetype[i] = 0;
        }
    }

    private ChartPanel createGraph() {
        this.chartPanel = new ChartPanel(this.createInitialChart(), false, false, true, true, true);
        this.chartPanel.setPreferredSize(this.getSize());
        return this.chartPanel;
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton btnupdate = new JButton("update");
        JButton btnproperty = new JButton("property");
        JButton btnexport = new JButton("export");
        JButton btnclose = new JButton("close");
        p.add(btnupdate);
        p.add(btnproperty);
        p.add(btnexport);
        p.add(btnclose);
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.chart = null;
                GraphPanel.this.chartPanel = null;
                GraphPanel.this.destroy();
            }
        });
        btnexport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.export();
            }
        });
        btnupdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.updateChart();
            }
        });
        btnproperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphPanel.this.bootPropertyEditor();
            }
        });
        return p;
    }

    private void bootPropertyEditor() {
        this.paeditor = new PlotAttributesEditor(this);
    }

    public PlotAttributesEditor getEditor() {
        return this.paeditor;
    }

    public void setProjDir(String projdir) {
        this.projdir = projdir;
    }

    private void export() {
        String inidir = new String();
        ExportDialog exportD = new ExportDialog();
        Properties prop = new Properties();
        prop.setProperty("org.freehep.util.export.ExportDialog.SaveAsFile", this.projdir + File.separator + this.title);
        exportD.setUserProperties(prop);
        exportD.showExportDialog(this, "export view as ...", this.chartPanel, this.title);
        try {
            File file = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "foo.pdf");
            PDFExporter.g2DtoPDF(this, file, this.chartPanel.getWidth(), this.chartPanel.getHeight());
            File svg = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "foo.svg");
            SVGExporter.g2DtoSVG(this, svg, this.chartPanel.getWidth(), this.chartPanel.getHeight());
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private JFreeChart createInitialChart() {
        if (this.type == 0) {
            this.chart = ChartFactory.createXYLineChart((String)this.plottitle, (String)this.xlabel, (String)this.ylabel, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        } else if (this.type == 1) {
            this.chart = ChartFactory.createPieChart((String)this.plottitle, (PieDataset)this.datasetpie, (boolean)true, (boolean)true, (boolean)false);
        }
        return this.chart;
    }

    private void updateChart() {
        Plot plot;
        this.chart.setAntiAlias(this.bantialias);
        this.chart.setBackgroundPaint(this.chartcolor);
        this.chart.setTitle(this.plottitle);
        if (this.plottitle != null) {
            TextTitle tt = this.chart.getTitle();
            tt.setFont(this.titlefont);
        }
        if (this.type == 0) {
            NumberAxis rangeAxis;
            NumberAxis domainAxis;
            plot = this.chart.getXYPlot();
            XYSeriesCollection collection = (XYSeriesCollection)plot.getDataset();
            try {
                for (int i = 1; i < this.legendtext.length; ++i) {
                    XYSeries xys = collection.getSeries(i - 1);
                }
            }
            catch (Exception e) {
                System.out.println("failed to set legend text");
            }
            if (!this.blogx) {
                domainAxis = new NumberAxis("x");
            } else {
                domainAxis = new LogarithmicAxis("x");
                this.createXYSeriesCollection(true);
            }
            if (!this.blogy) {
                rangeAxis = new NumberAxis("y");
            } else {
                rangeAxis = new LogarithmicAxis("y");
                this.createXYSeriesCollection(true);
            }
            domainAxis.setLabel(this.xlabel);
            domainAxis.setLabelFont(this.xaxisfont);
            rangeAxis.setLabel(this.ylabel);
            rangeAxis.setLabelFont(this.yaxisfont);
            if (this.ticmodey == 1) {
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            } else if (this.ticmodey == 2) {
                try {
                    rangeAxis.setTickUnit(new NumberTickUnit(Double.parseDouble(this.ticunitsy)));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.ticmodex == 1) {
                domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            } else if (this.ticmodex == 2) {
                try {
                    domainAxis.setTickUnit(new NumberTickUnit(Double.parseDouble(this.ticunitsx)));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            domainAxis.setTickLabelFont(this.xaxisticfont);
            rangeAxis.setTickLabelFont(this.yaxisticfont);
            domainAxis.setAutoRangeIncludesZero(false);
            rangeAxis.setAutoRangeIncludesZero(false);
            if (this.xaxisrangemode == 0) {
                domainAxis.setAutoRange(true);
            } else if (this.xaxisrangemode == 1) {
                try {
                    domainAxis.setLowerBound(Double.parseDouble(this.xaxismin));
                    domainAxis.setUpperBound(Double.parseDouble(this.xaxismax));
                }
                catch (Exception e) {
                    domainAxis.setAutoRange(true);
                    System.out.println("not a valid x range" + e);
                }
            }
            if (this.yaxisrangemode == 0) {
                rangeAxis.setAutoRange(true);
            } else if (this.yaxisrangemode == 1) {
                try {
                    rangeAxis.setLowerBound(Double.parseDouble(this.yaxismin));
                    rangeAxis.setUpperBound(Double.parseDouble(this.yaxismax));
                }
                catch (Exception e) {
                    rangeAxis.setAutoRange(true);
                    System.out.println("not a valid y range" + e);
                }
            }
            ((XYPlot)plot).setDomainGridlinesVisible(!this.bgridx);
            ((XYPlot)plot).setRangeGridlinesVisible(!this.bgridy);
            try {
                ((XYPlot)plot).setDomainAxis(domainAxis);
                ((XYPlot)plot).setRangeAxis(rangeAxis);
            }
            catch (Exception e) {
                System.out.println("failed to set axis to plot; may have tried to set non-positive values to a logarithmic axis.");
            }
            plot.setBackgroundPaint(this.plotcolor);
            XYTextAnnotation textAnnotation = new XYTextAnnotation(this.textantext, this.textanposx, this.textanposy);
            textAnnotation.setFont(this.textanfont);
            textAnnotation.setRotationAngle(Math.PI * this.textanrotation / 180.0);
            if (this.textanmode == 0) {
                ((XYPlot)plot).clearAnnotations();
            }
            if (this.textanmode != 2) {
                ((XYPlot)plot).addAnnotation(textAnnotation);
            }
            if (this.imageFileName != null) {
                File f = new File(this.imageFileName);
                int image_width = (int)((double)this.getSize().width * this.imageScale);
                try {
                    BufferedImage image = ImageIO.read(f);
                    XYImageAnnotation imageAnnotation = new XYImageAnnotation(this.imagePosX, this.imagePosY, image.getScaledInstance(image_width, -100, 4));
                    ((XYPlot)plot).addAnnotation(imageAnnotation);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.out.println("failed to put image annotation");
                }
            }
            if (this.bpointerAnnotation) {
                XYPointerAnnotation pointerAnnotation = new XYPointerAnnotation(this.pointerAnnotationLabel, this.pointerAnnotationX, this.pointerAnnotationY, Math.PI * this.pointerAnnotationRot / 180.0);
                pointerAnnotation.setBaseRadius(this.pointerAnnotationBase);
                pointerAnnotation.setLabelOffset(this.pointerAnnotationOffset);
                pointerAnnotation.setFont(this.pointerAnnotationFont);
                ((XYPlot)plot).addAnnotation(pointerAnnotation);
            }
            XYItemRenderer renderer = plot.getRenderer();
            renderer.setToolTipGenerator(new StandardXYToolTipGenerator());
            PlotShapesAndLines psal = new PlotShapesAndLines();
            for (int i = 0; i < this.NumSeries; ++i) {
                double shapesize_wk;
                float linewidth_wk;
                if (!this.bplotdefault[i]) {
                    if (this.plottype[i] == 0) {
                        linewidth_wk = this.linewidth[i];
                        shapesize_wk = 0.0;
                    } else if (this.plottype[i] == 1) {
                        linewidth_wk = 0.0f;
                        shapesize_wk = this.shapesize[i];
                    } else {
                        linewidth_wk = this.linewidth[i];
                        shapesize_wk = this.shapesize[i];
                    }
                    renderer.setSeriesPaint(i, this.seriescolor[i]);
                    renderer.setSeriesStroke(i, psal.getLine(this.linetype[i], linewidth_wk));
                    renderer.setSeriesShape(i, psal.getShape(this.shapetype[i], shapesize_wk));
                } else {
                    linewidth_wk = this.defaultlinewidth;
                    shapesize_wk = 0.0;
                    renderer.setSeriesStroke(i, psal.getLine(0, linewidth_wk));
                    renderer.setSeriesShape(i, psal.getShape(0, shapesize_wk));
                }
                this.seriescolor[i] = (Color)renderer.getSeriesPaint(i);
            }
            plot.setRenderer(renderer);
        } else if (this.type == 1) {
            plot = (PiePlot)this.chart.getPlot();
            plot.setBackgroundPaint(this.plotcolor);
            DefaultPieDataset datasetpie_wk = new DefaultPieDataset();
            for (int i = 0; i < this.data[0].length; ++i) {
                datasetpie_wk.setValue((Comparable)((Object)this.legendtext[i]), Double.parseDouble(this.data[1][i]));
            }
            plot.setDataset(datasetpie_wk);
        }
    }

    public void draw(Graphics2D g2d, Rectangle2D rec) {
        this.chart.draw(g2d, rec);
    }
}

