/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.DefaultKeyedValues2D;
import org.jfree.data.DomainInfo;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.Range;
import org.jfree.data.TableXYDataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;

public class TimeTableXYDataset
extends AbstractSeriesDataset
implements IntervalXYDataset,
DomainInfo,
TableXYDataset {
    private DefaultKeyedValues2D values = new DefaultKeyedValues2D(true);
    private boolean domainIsPointsInTime;
    private Calendar workingCalendar;
    private TimePeriodAnchor xPosition;

    public TimeTableXYDataset() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public TimeTableXYDataset(TimeZone zone) {
        this(zone, Locale.getDefault());
    }

    public TimeTableXYDataset(TimeZone zone, Locale locale) {
        this.workingCalendar = Calendar.getInstance(zone, locale);
        this.xPosition = TimePeriodAnchor.START;
    }

    public void add(RegularTimePeriod period, double y, String seriesName) {
        this.add(period, new Double(y), seriesName, true);
    }

    public void add(RegularTimePeriod period, Number y, String seriesName, boolean notify) {
        this.values.addValue(y, period, (Comparable)((Object)seriesName));
        if (notify) {
            this.fireDatasetChanged();
        }
    }

    public void remove(RegularTimePeriod period, String seriesName) {
        this.remove(period, seriesName, true);
    }

    public void remove(RegularTimePeriod period, String seriesName, boolean notify) {
        this.values.removeValue(period, (Comparable)((Object)seriesName));
        if (notify) {
            this.fireDatasetChanged();
        }
    }

    public int getItemCount() {
        return this.values.getRowCount();
    }

    public int getItemCount(int series) {
        return this.getItemCount();
    }

    public int getSeriesCount() {
        return this.values.getColumnCount();
    }

    public String getSeriesName(int series) {
        return this.values.getColumnKey(series).toString();
    }

    public Number getXValue(int series, int item) {
        RegularTimePeriod period = (RegularTimePeriod)this.values.getRowKey(item);
        return new Long(this.getX(period));
    }

    public Number getStartXValue(int series, int item) {
        RegularTimePeriod period = (RegularTimePeriod)this.values.getRowKey(item);
        return new Long(period.getFirstMillisecond(this.workingCalendar));
    }

    public Number getEndXValue(int series, int item) {
        RegularTimePeriod period = (RegularTimePeriod)this.values.getRowKey(item);
        return new Long(period.getLastMillisecond(this.workingCalendar));
    }

    public Number getYValue(int series, int item) {
        return this.values.getValue(item, series);
    }

    public Number getStartYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public Number getEndYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    private long getX(RegularTimePeriod period) {
        long result = 0L;
        if (this.xPosition == TimePeriodAnchor.START) {
            result = period.getFirstMillisecond(this.workingCalendar);
        } else if (this.xPosition == TimePeriodAnchor.MIDDLE) {
            result = period.getMiddleMillisecond(this.workingCalendar);
        } else if (this.xPosition == TimePeriodAnchor.END) {
            result = period.getLastMillisecond(this.workingCalendar);
        }
        return result;
    }

    public Number getMinimumDomainValue() {
        return new Double(this.getDomainRange().getLowerBound());
    }

    public Number getMaximumDomainValue() {
        return new Double(this.getDomainRange().getUpperBound());
    }

    public Range getDomainRange() {
        List keys = this.values.getRowKeys();
        if (keys.isEmpty()) {
            return null;
        }
        RegularTimePeriod first = (RegularTimePeriod)keys.get(0);
        RegularTimePeriod last = (RegularTimePeriod)keys.get(keys.size() - 1);
        if (this.domainIsPointsInTime) {
            return new Range(this.getX(first), this.getX(last));
        }
        return new Range(first.getFirstMillisecond(this.workingCalendar), last.getLastMillisecond(this.workingCalendar));
    }

    public boolean getDomainIsPointsInTime() {
        return this.domainIsPointsInTime;
    }

    public void setDomainIsPointsInTime(boolean flag) {
        this.domainIsPointsInTime = flag;
    }
}

