/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;

public class ChartEntity {
    private Shape area;
    private String toolTipText;
    private String urlText;

    public ChartEntity(Shape area) {
        this(area, null);
    }

    public ChartEntity(Shape area, String toolTipText) {
        this(area, toolTipText, null);
    }

    public ChartEntity(Shape area, String toolTipText, String urlText) {
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.area = area;
        this.toolTipText = toolTipText;
        this.urlText = urlText;
    }

    public Shape getArea() {
        return this.area;
    }

    public void setArea(Shape area) {
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.area = area;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getShapeType() {
        if (this.area instanceof Rectangle2D) {
            return "RECT";
        }
        return "POLY";
    }

    public String getShapeCoords() {
        if (this.area instanceof Rectangle2D) {
            return this.getRectCoords((Rectangle2D)this.area);
        }
        return this.getPolyCoords(this.area);
    }

    private String getRectCoords(Rectangle2D rectangle) {
        int x1 = (int)rectangle.getX();
        int y1 = (int)rectangle.getY();
        int x2 = x1 + (int)rectangle.getWidth();
        int y2 = y1 + (int)rectangle.getHeight();
        if (x2 == x1) {
            ++x2;
        }
        if (y2 == y1) {
            ++y2;
        }
        return x1 + "," + y1 + "," + x2 + "," + y2;
    }

    private String getPolyCoords(Shape shape) {
        String result = "";
        boolean first = true;
        float[] coords = new float[6];
        PathIterator pi = shape.getPathIterator(null, 1.0);
        while (!pi.isDone()) {
            pi.currentSegment(coords);
            if (first) {
                first = false;
                result = result + (int)coords[0] + "," + (int)coords[1];
            } else {
                result = result + "," + (int)coords[0] + "," + (int)coords[1];
            }
            pi.next();
        }
        return result;
    }

    public String getImageMapAreaTag(ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator urlTagFragmentGenerator) {
        boolean hasToolTip;
        boolean hasURL;
        StringBuffer tag = new StringBuffer();
        boolean bl = this.urlText == null ? false : (hasURL = !this.urlText.equals(""));
        boolean bl2 = this.toolTipText == null ? false : (hasToolTip = !this.toolTipText.equals(""));
        if (hasURL || hasToolTip) {
            tag.append("<AREA SHAPE=\"" + this.getShapeType() + "\"" + " COORDS=\"" + this.getShapeCoords() + "\"");
            if (hasToolTip) {
                tag.append(toolTipTagFragmentGenerator.generateToolTipFragment(this.toolTipText));
            }
            if (hasURL) {
                tag.append(urlTagFragmentGenerator.generateURLFragment(this.urlText));
            }
            tag.append(">");
        }
        return tag.toString();
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String text) {
        this.urlText = text;
    }
}

