/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import org.cybergarage.x3d.field.SFMatrix;
import org.cybergarage.x3d.field.SFVec2f;
import org.cybergarage.x3d.node.Bounded2DObject;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.util.BoundingBox2D;

public abstract class Bounded2DNode
extends Node
implements Bounded2DObject {
    private static final String bboxCenterFieldName = "bboxCenter";
    private static final String bboxSizeFieldName = "bboxSize";
    private SFVec2f bboxCenterField = new SFVec2f(0.0f, 0.0f);
    private SFVec2f bboxSizeField;

    public Bounded2DNode() {
        this.bboxCenterField.setName(bboxCenterFieldName);
        this.addField(this.bboxCenterField);
        this.bboxSizeField = new SFVec2f(-1.0f, -1.0f);
        this.bboxSizeField.setName(bboxSizeFieldName);
        this.addField(this.bboxSizeField);
    }

    public SFVec2f getBoundingBoxSizeField() {
        if (!this.isInstanceNode()) {
            return this.bboxSizeField;
        }
        return (SFVec2f)this.getField(bboxSizeFieldName);
    }

    public void setBoundingBoxSize(float[] value) {
        this.getBoundingBoxSizeField().setValue(value);
    }

    public void setBoundingBoxSize(float x, float y) {
        this.getBoundingBoxSizeField().setValue(x, y);
    }

    public void setBoundingBoxSize(String value) {
        this.getBoundingBoxSizeField().setValue(value);
    }

    public void getBoundingBoxSize(float[] value) {
        this.getBoundingBoxSizeField().getValue(value);
    }

    public float[] getBoundingBoxSize() {
        float[] size = new float[2];
        this.getBoundingBoxSize(size);
        return size;
    }

    public SFVec2f getBoundingBoxCenterField() {
        if (!this.isInstanceNode()) {
            return this.bboxCenterField;
        }
        return (SFVec2f)this.getField(bboxCenterFieldName);
    }

    public void setBoundingBoxCenter(float[] value) {
        this.getBoundingBoxCenterField().setValue(value);
    }

    public void setBoundingBoxCenter(float x, float y) {
        this.getBoundingBoxCenterField().setValue(x, y);
    }

    public void setBoundingBoxCenter(String value) {
        this.getBoundingBoxCenterField().setValue(value);
    }

    public void getBoundingBoxCenter(float[] value) {
        this.getBoundingBoxCenterField().getValue(value);
    }

    public float[] getBoundingBoxCenter() {
        float[] center = new float[2];
        this.getBoundingBoxCenter(center);
        return center;
    }

    public static final void updateBoundingBox(Node node, BoundingBox2D bbox) {
        if (node instanceof Bounded2DNode) {
            Bounded2DNode b2dNode = (Bounded2DNode)node;
            b2dNode.updateBoundingBox();
            float[] bboxCenter = new float[2];
            float[] bboxSize = new float[2];
            float[] point = new float[2];
            b2dNode.getBoundingBoxCenter(bboxCenter);
            b2dNode.getBoundingBoxSize(bboxSize);
            if (bboxSize[0] >= 0.0f && bboxSize[1] >= 0.0f) {
                SFMatrix mx = b2dNode.getTransformMatrix();
                for (int n = 0; n < 4; ++n) {
                    point[0] = n < 4 ? bboxCenter[0] - bboxSize[0] : bboxCenter[0] + bboxSize[0];
                    point[1] = n % 2 != 0 ? bboxCenter[1] - bboxSize[1] : bboxCenter[1] + bboxSize[1];
                    mx.multi(point);
                    bbox.addPoint(point);
                }
            }
        }
        for (Node cnode = node.getChildNodes(); cnode != null; cnode = cnode.next()) {
            Bounded2DNode.updateBoundingBox(cnode, bbox);
        }
    }

    public void updateBoundingBox() {
        BoundingBox2D bbox = new BoundingBox2D();
        for (Node node = this.getChildNodes(); node != null; node = node.next()) {
            Bounded2DNode.updateBoundingBox(node, bbox);
        }
        this.setBoundingBoxCenter(bbox.getCenter());
        this.setBoundingBoxSize(bbox.getSize());
    }
}

