/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.field.SFRotation;
import org.cybergarage.x3d.field.SFVec3f;

public class SFMatrix
extends Field {
    private double[][] mValue = new double[4][4];

    public SFMatrix() {
        this.init();
    }

    public SFMatrix(float[][] value) {
        this.setValue(value);
    }

    public SFMatrix(double[][] value) {
        this.setValue(value);
    }

    public SFMatrix(SFMatrix value) {
        this.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(Object object) {
        double[][] dArray = this.mValue;
        synchronized (this.mValue) {
            this.mValue = (double[][])object;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        double[][] dArray = this.mValue;
        synchronized (this.mValue) {
            double[][] object = this.mValue;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(double[][] value) {
        double[][] dArray = this.mValue;
        synchronized (this.mValue) {
            for (int i = 0; i < 4; ++i) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    this.mValue[i][j2] = value[i][j2];
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(float[][] value) {
        double[][] dArray = this.mValue;
        synchronized (this.mValue) {
            for (int i = 0; i < 4; ++i) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    this.mValue[i][j2] = value[i][j2];
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setValue(SFMatrix matrix) {
        double[][] value = new double[4][4];
        matrix.getValue(value);
        this.setValue(value);
    }

    public void setValue(String string) {
    }

    public void setValue(Field field) {
        this.setValue((SFMatrix)field);
    }

    public void setValueAsScaling(float[] value) {
        this.init();
        this.setValueAsScaling(value[0], value[1], value[2]);
    }

    public void setValueAsScaling(double[] value) {
        this.init();
        this.setValueAsScaling(value[0], value[1], value[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAsScaling(double x, double y, double z) {
        this.init();
        double[][] dArray = this.mValue;
        synchronized (this.mValue) {
            this.mValue[0][0] = x;
            this.mValue[1][1] = y;
            this.mValue[2][2] = z;
            // ** MonitorExit[var7_4] (shouldn't be in output)
            return;
        }
    }

    public void setValueAsTranslation(SFVec3f vector) {
        this.setValueAsTranslation(vector.getX(), vector.getY(), vector.getZ());
    }

    public void setValueAsTranslation(double[] value) {
        this.setValueAsTranslation(value[0], value[1], value[2]);
    }

    public void setValueAsTranslation(float[] value) {
        this.setValueAsTranslation(value[0], value[1], value[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAsTranslation(double x, double y, double z) {
        this.init();
        double[][] dArray = this.mValue;
        synchronized (this.mValue) {
            this.mValue[3][0] = x;
            this.mValue[3][1] = y;
            this.mValue[3][2] = z;
            // ** MonitorExit[var7_4] (shouldn't be in output)
            return;
        }
    }

    public void setValueAsRotation(SFRotation rotation) {
        this.setValueAsRotation(rotation.getX(), rotation.getY(), rotation.getZ(), rotation.getAngle());
    }

    public void setValueAsRotation(float[] value) {
        this.setValueAsRotation(value[0], value[1], value[2], value[3]);
    }

    public void setValueAsRotation(double[] value) {
        this.setValueAsRotation(value[0], value[1], value[2], value[3]);
    }

    public void setValueAsRotation(double x, double y, double z, double rot) {
        SFRotation rotation = new SFRotation(x, y, z, rot);
        SFMatrix matrix = new SFMatrix();
        rotation.getSFMatrix(matrix);
        double[][] value = new double[4][4];
        matrix.getValue(value);
        this.setValue(value);
    }

    public double[][] getValue() {
        double[][] value = new double[4][4];
        this.getValue(value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValue(double[][] value) {
        double[][] dArray = this.mValue;
        synchronized (this.mValue) {
            for (int i = 0; i < 4; ++i) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    value[i][j2] = this.mValue[i][j2];
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValue(float[][] value) {
        double[][] dArray = this.mValue;
        synchronized (this.mValue) {
            for (int i = 0; i < 4; ++i) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    value[i][j2] = (float)this.mValue[i][j2];
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int getValueCount() {
        return 16;
    }

    public double[] getValueOnlyTranslation() {
        double[] value = new double[3];
        this.getValueOnlyTranslation(value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValueOnlyTranslation(float[] value) {
        double[][] dArray = this.mValue;
        synchronized (this.mValue) {
            value[0] = (float)this.mValue[3][0];
            value[1] = (float)this.mValue[3][1];
            value[2] = (float)this.mValue[3][2];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValueOnlyTranslation(double[] value) {
        double[][] dArray = this.mValue;
        synchronized (this.mValue) {
            value[0] = this.mValue[3][0];
            value[1] = this.mValue[3][1];
            value[2] = this.mValue[3][2];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void add(SFMatrix matrix) {
        double[][] ma1 = new double[4][4];
        double[][] ma2 = new double[4][4];
        double[][] maOut = new double[4][4];
        this.getValue(ma1);
        matrix.getValue(ma2);
        for (int i = 0; i < 4; ++i) {
            for (int j2 = 0; j2 < 4; ++j2) {
                maOut[j2][i] = 0.0;
                for (int k = 0; k < 4; ++k) {
                    double[] dArray = maOut[j2];
                    int n = i;
                    dArray[n] = dArray[n] + ma1[k][i] * ma2[j2][k];
                }
            }
        }
        this.setValue(maOut);
    }

    public void multi(double[] vector) {
        double[] vectorIn = new double[]{vector[0], vector[1], vector[2], 1.0};
        double[] vectorOut = new double[4];
        double[][] ma = this.getValue();
        for (int n = 0; n < 4; ++n) {
            vectorOut[n] = ma[0][n] * vectorIn[0] + ma[1][n] * vectorIn[1] + ma[2][n] * vectorIn[2] + ma[3][n] * vectorIn[3];
        }
        vector[0] = vectorOut[0];
        vector[1] = vectorOut[1];
        vector[2] = vectorOut[2];
    }

    public void multi(float[] vector) {
        double[] dvector = new double[]{vector[0], vector[1], vector[2]};
        this.multi(dvector);
        vector[0] = (float)dvector[0];
        vector[1] = (float)dvector[1];
        vector[2] = (float)dvector[2];
    }

    public void multi(SFVec3f vector) {
        float[] value = new float[3];
        vector.getValue(value);
        this.multi(value);
        vector.setValue(value);
    }

    public void getSFRotation(SFRotation rotation) {
        double z;
        double y;
        double x;
        double w;
        double[][] m = new double[4][4];
        this.getValue(m);
        double w2 = 0.25 * (1.0 + m[0][0] + m[1][1] + m[2][2]);
        if (0.0 < w2) {
            w = Math.sqrt(w2);
            x = (m[1][2] - m[2][1]) / (4.0 * w);
            y = (m[2][0] - m[0][2]) / (4.0 * w);
            z = (m[0][1] - m[1][0]) / (4.0 * w);
        } else {
            w = 0.0;
            double x2 = 0.0;
            double m1122 = m[1][1] + m[2][2];
            if (m1122 != 0.0) {
                x2 = -1.0 / (2.0 * m1122);
            }
            if (0.0 < x2) {
                x = Math.sqrt(x2);
                y = m[0][1] / (2.0 * x);
                z = m[0][2] / (2.0 * x);
            } else {
                x = 0.0;
                double y2 = 0.0;
                double m22 = 1.0 - m[2][2];
                if (m22 != 0.0) {
                    y2 = 1.0 / (2.0 * m22);
                }
                if (0.0 < y2) {
                    y = Math.sqrt(y2);
                    z = m[1][2] / (2.0 * y);
                } else {
                    y = 0.0;
                    z = 1.0;
                }
            }
        }
        double angle = Math.acos(2.0 * w * w - 1.0);
        double[] value = new double[4];
        if (angle != 0.0) {
            value[0] = x / Math.sin(angle);
            value[1] = y / Math.sin(angle);
            value[2] = z / Math.sin(angle);
            value[3] = angle;
        } else {
            value[0] = 0.0;
            value[1] = 0.0;
            value[2] = 1.0;
            value[3] = 0.0;
        }
        rotation.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        double[][] dArray = this.mValue;
        synchronized (this.mValue) {
            String string = this.mValue[0][0] + " " + this.mValue[0][1] + " " + this.mValue[0][2] + " " + this.mValue[0][3] + "\n" + this.mValue[1][0] + " " + this.mValue[1][1] + " " + this.mValue[1][2] + " " + this.mValue[1][3] + "\n" + this.mValue[2][0] + " " + this.mValue[2][1] + " " + this.mValue[2][2] + " " + this.mValue[2][3] + "\n" + this.mValue[3][0] + " " + this.mValue[3][1] + " " + this.mValue[3][2] + " " + this.mValue[3][3];
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        double[][] dArray = this.mValue;
        synchronized (this.mValue) {
            for (int i = 0; i < 4; ++i) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    this.mValue[i][j2] = 0.0;
                }
            }
            for (int n = 0; n < 4; ++n) {
                this.mValue[n][n] = 1.0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

