/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Emulator;
import com.jcraft.jcterm.EmulatorVT100;
import com.jcraft.jcterm.Sftp;
import com.jcraft.jcterm.Splash;
import com.jcraft.jcterm.Term;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Properties;

public class JCTermJ2MECDC
extends Panel
implements KeyListener,
ActionListener,
Runnable,
Term {
    static String COPYRIGHT = "JCTerm 0.0.8\nCopyright (C) 2002-2005 ymnk<ymnk@jcraft.com>, JCraft,Inc.\nOfficial Homepage: http://www.jcraft.com/jcterm/\nThis software is licensed under GNU LGPL.\nThis software is using JSch(http://www.jcraft.com/jsch/) and\nBouncyCastle Crypto API(http://www.bouncycastle.org/).";
    private static int windowWidth = 640;
    private static int windowHeight = 480;
    private static int titleHeight = 13;
    private static int taskbarHeight = 19;
    private static int margin = 2;
    private static final int SHELL = 0;
    private static final int SFTP = 1;
    private static final int EXEC = 2;
    private int mode = 0;
    private OutputStream out;
    private InputStream in;
    private Image img;
    private Image background;
    private Graphics cursor_graphics;
    private Graphics graphics;
    private Color bground = Color.black;
    private Color fground = Color.white;
    private Component term_area = null;
    private Font font;
    private int term_width = 80;
    private int term_height = 24;
    private int x = 0;
    private int y = 0;
    private int descent = 0;
    private int char_width;
    private int char_height;
    private String xhost = "127.0.0.1";
    private int xport = 0;
    private boolean xforwarding = false;
    private String user = System.getProperty("user.name");
    private String host = "127.0.0.1";
    private int port = 22;
    private String command = "";
    private String proxy_http_host = null;
    private int proxy_http_port = 0;
    private String proxy_socks5_host = null;
    private int proxy_socks5_port = 0;
    private Session session = null;
    private Proxy proxy = null;
    private boolean antialiasing = true;
    private int line_space = 0;
    private int compression = 0;
    private Splash splash = null;
    private Thread thread = null;
    MyUserInfo ui = null;
    JSch jsch = null;
    private Emulator emulator = null;
    byte[] obuffer = new byte[3];
    Dialog dialog = null;
    TextField textf = null;
    Button ok = null;
    Label label = null;

    public JCTermJ2MECDC() {
        this.enableEvents(8L);
    }

    void initGraphics() {
        this.font = new Font("monospaced", 0, 16);
        this.graphics = this.getGraphics();
        this.graphics.setFont(this.font);
        FontMetrics fo = this.graphics.getFontMetrics(this.font);
        this.descent = fo.getDescent();
        this.char_width = fo.charWidth('@');
        this.char_height = fo.getHeight() + this.line_space * 2;
        this.background = this.createImage(this.char_width, this.char_height);
        Graphics foog = this.background.getGraphics();
        foog.setColor(this.bground);
        foog.fillRect(0, 0, this.char_width, this.char_height);
        foog.dispose();
        this.img = this.createImage(this.getTermWidth(), this.getTermHeight());
        this.graphics = this.img.getGraphics();
        this.graphics.setFont(this.font);
        if (this.splash != null) {
            this.splash.draw(this.img, this.getTermWidth(), this.getTermHeight());
        } else {
            this.clear();
        }
        this.cursor_graphics = this.img.getGraphics();
        this.cursor_graphics.setColor(this.fground);
        this.cursor_graphics.setXORMode(this.bground);
        this.term_area = this;
        JCTermJ2MECDC panel = this;
        panel.setSize(this.getTermWidth(), this.getTermHeight());
    }

    public void setFrame(Component term_area) {
        this.term_area = term_area;
    }

    public void kick() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block23: {
            if (this.jsch == null) {
                this.jsch = new JSch();
                String home2 = System.getProperty("user.home") + File.separator;
                home2 = home2 + ".ssh" + File.separator;
                try {
                    this.jsch.setKnownHosts(home2 + "known_hosts");
                    File file = new File(home2, "id_dsa");
                    if (file.exists()) {
                        this.jsch.addIdentity(file.getPath());
                    }
                    if ((file = new File(home2, "id_rsa")).exists()) {
                        this.jsch.addIdentity(file.getPath());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.thread != null) {
                StringBuffer sb;
                byte[] buf;
                InputStream in;
                Channel channel;
                block24: {
                    try {
                        try {
                            this.session = this.jsch.getSession(this.user, this.host, this.port);
                            this.session.setProxy(this.proxy);
                            this.ui = new MyUserInfo();
                            this.session.setUserInfo(this.ui);
                            Properties config = new Properties();
                            if (this.compression == 0) {
                                config.put("compression.s2c", "none");
                                config.put("compression.c2s", "none");
                            } else {
                                config.put("compression.s2c", "zlib,none");
                                config.put("compression.c2s", "zlib,none");
                            }
                            this.session.setConfig(config);
                            this.session.connect();
                        }
                        catch (Exception e) {
                            break block23;
                        }
                        channel = null;
                        if (this.mode == 0) {
                            channel = this.session.openChannel("shell");
                            if (this.xforwarding) {
                                this.session.setX11Host(this.xhost);
                                this.session.setX11Port(this.xport + 6000);
                                channel.setXForwarding(true);
                            }
                            this.out = channel.getOutputStream();
                            this.in = channel.getInputStream();
                            channel.connect();
                        } else if (this.mode == 1) {
                            this.out = new PipedOutputStream();
                            this.in = new PipedInputStream();
                            channel = this.session.openChannel("sftp");
                            channel.connect();
                            new Sftp((ChannelSftp)channel, new PipedInputStream((PipedOutputStream)this.out), new PipedOutputStream((PipedInputStream)this.in)).kick();
                        } else if (this.mode == 2) {
                            channel = this.session.openChannel("exec");
                            ((ChannelExec)channel).setCommand(this.command);
                            in = channel.getInputStream();
                            OutputStream out = channel.getOutputStream();
                            channel.connect();
                            buf = new byte[1024];
                            sb = new StringBuffer();
                            break block24;
                        }
                        this.requestFocus();
                        this.emulator = new EmulatorVT100(this, this.in);
                        this.emulator.reset();
                        this.emulator.start();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    break block23;
                }
                while (true) {
                    int i;
                    if ((i = in.read(buf, 0, buf.length)) <= 0) {
                        channel.disconnect();
                        MessageDialog msg = new MessageDialog(this.command, sb.toString());
                        break;
                    }
                    sb.append(new String(buf, 0, i));
                }
            }
        }
        this.thread = null;
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
        if (this.splash != null) {
            this.splash.draw(this.img, this.getTermWidth(), this.getTermHeight());
        } else {
            this.clear();
        }
        this.redraw(0, 0, this.getTermWidth(), this.getTermHeight());
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, this.term_area);
        }
    }

    public void processKeyEvent(KeyEvent e) {
        int id = e.getID();
        if (id == 401) {
            this.keyPressed(e);
        } else if (id != 402 && id == 400) {
            this.keyTyped(e);
        }
        e.consume();
    }

    public void keyPressed(KeyEvent e) {
        int keycode = e.getKeyCode();
        byte[] code = null;
        switch (keycode) {
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                return;
            }
            case 10: {
                code = this.emulator.getCodeENTER();
                break;
            }
            case 38: {
                code = this.emulator.getCodeUP();
                break;
            }
            case 40: {
                code = this.emulator.getCodeDOWN();
                break;
            }
            case 39: {
                code = this.emulator.getCodeRIGHT();
                break;
            }
            case 37: {
                code = this.emulator.getCodeLEFT();
                break;
            }
            case 112: {
                code = this.emulator.getCodeF1();
                break;
            }
            case 113: {
                code = this.emulator.getCodeF2();
                break;
            }
            case 114: {
                code = this.emulator.getCodeF3();
                break;
            }
            case 115: {
                code = this.emulator.getCodeF4();
                break;
            }
            case 116: {
                code = this.emulator.getCodeF5();
                break;
            }
            case 117: {
                code = this.emulator.getCodeF6();
                break;
            }
            case 118: {
                code = this.emulator.getCodeF7();
                break;
            }
            case 119: {
                code = this.emulator.getCodeF8();
                break;
            }
            case 120: {
                code = this.emulator.getCodeF9();
                break;
            }
            case 121: {
                code = this.emulator.getCodeF10();
            }
        }
        if (code != null) {
            try {
                this.out.write(code, 0, code.length);
                this.out.flush();
            }
            catch (Exception ee) {
                // empty catch block
            }
            return;
        }
        int keychar = e.getKeyChar();
        int mod = e.getModifiers();
        if ((mod & 2) != 0 && 97 <= keychar && keychar <= 122) {
            keychar = (char)(keychar - 97 + 1);
        }
        if (keycode == 106) {
            keychar = 42;
        }
        if ((keychar & 0xFF00) == 0) {
            this.obuffer[0] = (byte)keychar;
            try {
                this.out.write(this.obuffer, 0, 1);
                this.out.flush();
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
    }

    public void keyTyped(KeyEvent e) {
        char keychar = e.getKeyChar();
        if ((keychar & 0xFF00) != 0) {
            char[] foo = new char[]{keychar};
            try {
                byte[] goo = new String(foo).getBytes("EUC-JP");
                this.out.write(goo, 0, goo.length);
                this.out.flush();
            }
            catch (Exception eee) {
                // empty catch block
            }
        }
    }

    public int getTermWidth() {
        return this.char_width * this.term_width;
    }

    public int getTermHeight() {
        return this.char_height * this.term_height;
    }

    public int getCharWidth() {
        return this.char_width;
    }

    public int getCharHeight() {
        return this.char_height;
    }

    public int getColumnCount() {
        return this.term_width;
    }

    public int getRowCount() {
        return this.term_height;
    }

    public void clear() {
        this.graphics.setColor(this.bground);
        this.graphics.fillRect(0, 0, this.char_width * this.term_width, this.char_height * this.term_height);
        this.graphics.setColor(this.fground);
        this.getGraphics().drawImage(this.img, 0, 0, this.term_area);
    }

    public void setCursor(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void draw_cursor() {
        this.cursor_graphics.fillRect(this.x, this.y - this.char_height, this.char_width, this.char_height);
        Graphics g = this.getGraphics();
        g.setClip(this.x, this.y - this.char_height, this.char_width, this.char_height);
        g.drawImage(this.img, 0, 0, this.term_area);
    }

    public void redraw(int x, int y, int width, int height) {
        Graphics g = this.getGraphics();
        g.setClip(x, y, width, height);
        g.drawImage(this.img, 0, 0, this.term_area);
    }

    public void clear_area(int x1, int y1, int x2, int y2) {
        this.graphics.setColor(this.bground);
        this.graphics.fillRect(x1, y1, x2 - x1, y2 - y1);
        this.graphics.setColor(this.fground);
    }

    public void scroll_area(int x, int y, int w, int h, int dx, int dy) {
        this.getGraphics().copyArea(x, y, w, h, dx, dy);
        this.graphics.copyArea(x, y, w, h, dx, dy);
    }

    public void drawBytes(byte[] buf, int s, int len, int x, int y) {
        byte[] foo;
        if (s > 0) {
            foo = new byte[len];
            System.arraycopy(buf, s, foo, 0, len);
            s = 0;
            buf = foo;
        }
        if (len != buf.length) {
            foo = new byte[len];
            System.arraycopy(buf, 0, foo, 0, len);
            buf = foo;
        }
        this.graphics.setColor(this.bground);
        this.clear_area(x, y, x + len * this.char_width, y + this.char_height);
        this.graphics.setColor(this.fground);
        this.graphics.drawBytes(buf, s, len, x, y - (this.descent + this.line_space));
    }

    public void drawString(String str, int x, int y) {
        this.graphics.drawString(str, x, y - (this.descent + this.line_space));
    }

    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void keyReleased(KeyEvent event) {
    }

    public void setProxyHttp(String host, int port) {
        this.proxy_http_host = host;
        this.proxy_http_port = port;
        this.proxy = this.proxy_http_host != null && this.proxy_http_port != 0 ? new ProxyHTTP(this.proxy_http_host, this.proxy_http_port) : null;
    }

    public String getProxyHttpHost() {
        return this.proxy_http_host;
    }

    public int getProxyHttpPort() {
        return this.proxy_http_port;
    }

    public void setProxySOCKS5(String host, int port) {
        this.proxy_socks5_host = host;
        this.proxy_socks5_port = port;
        this.proxy = this.proxy_socks5_host != null && this.proxy_socks5_port != 0 ? new ProxySOCKS5(this.proxy_socks5_host, this.proxy_socks5_port) : null;
    }

    public String getProxySOCKS5Host() {
        return this.proxy_socks5_host;
    }

    public int getProxySOCKS5Port() {
        return this.proxy_socks5_port;
    }

    public void setSplash(Splash foo) {
        this.splash = foo;
    }

    public void setXHost(String xhost) {
        this.xhost = xhost;
    }

    public void setXPort(int xport) {
        this.xport = xport;
    }

    public void setXForwarding(boolean foo) {
        this.xforwarding = foo;
    }

    public void setLineSpace(int foo) {
        this.line_space = foo;
    }

    public void setAntiAliasing(boolean foo) {
    }

    public void setCompression(int compression) {
        if (compression < 0 || 9 < compression) {
            return;
        }
        this.compression = compression;
    }

    public int getCompression() {
        return this.compression;
    }

    public void setUserHost(String userhost) {
        try {
            String _user = userhost.substring(0, userhost.indexOf(64));
            String _host = userhost.substring(userhost.indexOf(64) + 1);
            this.user = _user;
            this.host = _host;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openSession() {
        this.kick();
    }

    public void setPortForwardingL(int port1, String host, int port2) {
        try {
            this.session.setPortForwardingL(port1, host, port2);
        }
        catch (JSchException e) {
            // empty catch block
        }
    }

    public void setPortForwardingR(int port1, String host, int port2) {
        try {
            this.session.setPortForwardingR(port1, host, port2);
        }
        catch (JSchException e) {
            // empty catch block
        }
    }

    private Dialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new Dialog(new Frame(), "", true);
            this.ok = new Button("OK");
            Button cancel = new Button("CANCEL");
            this.textf = new TextField(20);
            this.dialog.setLayout(new FlowLayout());
            this.dialog.setLocation(100, 50);
            this.ok.addActionListener(this);
            cancel.addActionListener(this);
            this.dialog.add(this.textf);
            this.dialog.add(this.ok);
            this.dialog.add(cancel);
            this.dialog.pack();
        }
        this.textf.setEchoChar('\u0000');
        return this.dialog;
    }

    public void actionPerformed(ActionEvent e) {
        block53: {
            String action = e.getActionCommand();
            if (action.equals("Open SHELL Session...") || action.equals("Open SFTP Session...") || action.equals("Open EXEC Session...")) {
                if (this.thread == null) {
                    if (action.equals("Open SHELL Session...")) {
                        this.mode = 0;
                    } else if (action.equals("Open SFTP Session...")) {
                        this.mode = 1;
                    } else if (action.equals("Open EXEC Session...")) {
                        this.mode = 2;
                    }
                    while (true) {
                        InputDialog dialog = new InputDialog("Enter username@hostname", "", false);
                        if (this.mode == 2) {
                            InputDialog _dialog = new InputDialog("Enter command", this.command, false);
                            this.command = _dialog.getText();
                        }
                        try {
                            this.port = 22;
                            String _host = dialog.getText();
                            if (_host == null) {
                                return;
                            }
                            String _user = _host.substring(0, _host.indexOf(64));
                            if ((_host = _host.substring(_host.indexOf(64) + 1)) == null || _host.length() == 0) {
                                return;
                            }
                            if (_host.indexOf(58) != -1) {
                                try {
                                    this.port = Integer.parseInt(_host.substring(_host.indexOf(58) + 1));
                                }
                                catch (Exception eee) {
                                    // empty catch block
                                }
                                _host = _host.substring(0, _host.indexOf(58));
                            }
                            this.user = _user;
                            this.host = _host;
                            this.openSession();
                            return;
                        }
                        catch (Exception ee) {
                            continue;
                        }
                        break;
                    }
                }
            } else if (action.equals("HTTP...")) {
                String foo = this.getProxyHttpHost();
                int bar = this.getProxyHttpPort();
                InputDialog dialog = new InputDialog("HTTP proxy server (hostname:port)", foo != null && bar != 0 ? foo + ":" + bar : "", false);
                String proxy = dialog.getText();
                if (proxy == null) {
                    return;
                }
                if (proxy.length() == 0) {
                    this.setProxyHttp(null, 0);
                    return;
                }
                try {
                    foo = proxy.substring(0, proxy.indexOf(58));
                    bar = Integer.parseInt(proxy.substring(proxy.indexOf(58) + 1));
                    if (foo != null) {
                        this.setProxyHttp(foo, bar);
                    }
                }
                catch (Exception ee) {}
            } else if (action.equals("SOCKS5...")) {
                String foo = this.getProxySOCKS5Host();
                int bar = this.getProxySOCKS5Port();
                InputDialog dialog = new InputDialog("SOCKS5 server (hostname:1080)", foo != null && bar != 0 ? foo + ":" + bar : "", false);
                String proxy = this.textf.getText();
                if (proxy == null) {
                    return;
                }
                if (proxy.length() == 0) {
                    this.setProxySOCKS5(null, 0);
                    return;
                }
                try {
                    foo = proxy.substring(0, proxy.indexOf(58));
                    bar = Integer.parseInt(proxy.substring(proxy.indexOf(58) + 1));
                    if (foo != null) {
                        this.setProxySOCKS5(foo, bar);
                    }
                }
                catch (Exception ee) {}
            } else if (action.equals("About...")) {
                MessageDialog msg = new MessageDialog("About...", COPYRIGHT);
            } else if (action.equals("Compression...")) {
                InputDialog dialog = new InputDialog("Compression level(0-9)", new Integer(this.compression).toString(), false);
                String foo = dialog.getText();
                try {
                    if (foo != null) {
                        this.compression = Integer.parseInt(foo);
                    }
                }
                catch (Exception ee) {}
            } else if (action.equals("Line Space...")) {
                InputDialog dialog = new InputDialog("Line Space", new Integer(this.line_space).toString(), false);
                String foo = dialog.getText();
                try {
                    if (foo != null) {
                        this.setLineSpace(Integer.parseInt(foo));
                    }
                }
                catch (Exception ee) {}
            } else if (action.equals("Local Port...") || action.equals("Remote Port...")) {
                if (this.session == null) {
                    MessageDialog msg = new MessageDialog("Error...", "Establish the connection before this setting.");
                    return;
                }
                try {
                    String title = "";
                    title = action.equals("Local Port...") ? title + "Local port forwarding" : title + "remote port forwarding";
                    title = title + "(port:host:hostport)";
                    InputDialog dialog = new InputDialog(title, "", false);
                    String foo = dialog.getText();
                    if (foo == null) {
                        return;
                    }
                    int port1 = Integer.parseInt(foo.substring(0, foo.indexOf(58)));
                    foo = foo.substring(foo.indexOf(58) + 1);
                    String host = foo.substring(0, foo.indexOf(58));
                    int port2 = Integer.parseInt(foo.substring(foo.indexOf(58) + 1));
                    if (action.equals("Local Port...")) {
                        this.setPortForwardingL(port1, host, port2);
                        break block53;
                    }
                    this.setPortForwardingR(port1, host, port2);
                }
                catch (Exception exception) {}
            } else if (action.equals("Quit")) {
                this.quit();
            } else if (action.equals("CANCEL")) {
                this.dialog.setVisible(false);
            }
        }
    }

    public MenuBar getMenuBar() {
        MenuBar mb = new MenuBar();
        Menu m = new Menu("File");
        MenuItem mi = new MenuItem("Open SHELL Session...");
        mi.addActionListener(this);
        m.add(mi);
        mi = new MenuItem("Open SFTP Session...");
        mi.addActionListener(this);
        m.add(mi);
        mi = new MenuItem("Open EXEC Session...");
        mi.addActionListener(this);
        m.add(mi);
        mi = new MenuItem("Quit");
        mi.addActionListener(this);
        m.add(mi);
        mb.add(m);
        m = new Menu("Proxy");
        mi = new MenuItem("HTTP...");
        mi.addActionListener(this);
        m.add(mi);
        mi = new MenuItem("SOCKS5...");
        mi.addActionListener(this);
        m.add(mi);
        mb.add(m);
        m = new Menu("PortForwarding");
        mi = new MenuItem("Local Port...");
        mi.addActionListener(this);
        m.add(mi);
        mi = new MenuItem("Remote Port...");
        mi.addActionListener(this);
        m.add(mi);
        mb.add(m);
        m = new Menu("Help");
        mi = new MenuItem("About...");
        mi.addActionListener(this);
        mi.setActionCommand("About...");
        m.add(mi);
        mb.add(m);
        return mb;
    }

    public static void main(String[] arg) {
        try {
            Class<?> c2 = Class.forName("org.bouncycastle.LICENSE");
            c2 = Class.forName("com.jcraft.jsch.bc.DH");
            c2 = Class.forName("com.jcraft.jsch.bc.BlowfishCBC");
            c2 = Class.forName("com.jcraft.jsch.bc.TripleDESCBC");
            c2 = Class.forName("com.jcraft.jsch.bc.SHA1");
            c2 = Class.forName("com.jcraft.jsch.bc.MD5");
            c2 = Class.forName("com.jcraft.jsch.bc.HMACMD5");
            c2 = Class.forName("com.jcraft.jsch.bc.HMACMD596");
            c2 = Class.forName("com.jcraft.jsch.bc.HMACSHA1");
            c2 = Class.forName("com.jcraft.jsch.bc.HMACSHA196");
            c2 = Class.forName("com.jcraft.jsch.bc.SignatureDSA");
            c2 = Class.forName("com.jcraft.jsch.bc.SignatureRSA");
            c2 = Class.forName("com.jcraft.jsch.bc.KeyPairGenDSA");
            c2 = Class.forName("com.jcraft.jsch.bc.KeyPairGenRSA");
            c2 = Class.forName("com.jcraft.jsch.bc.Random");
        }
        catch (Exception e) {
            // empty catch block
        }
        JCTermJ2MECDC term = new JCTermJ2MECDC();
        Frame frame = new Frame("JCTermJ2MECDC");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        MenuBar mb = term.getMenuBar();
        frame.setMenuBar(mb);
        frame.setSize(windowWidth - margin * 2, windowHeight - titleHeight - taskbarHeight - margin * 2);
        frame.add("Center", term);
        frame.pack();
        term.initGraphics();
        frame.setSize(windowWidth - margin * 2, windowHeight - titleHeight - taskbarHeight - margin * 2);
        frame.setResizable(false);
        term.setVisible(true);
        frame.setVisible(true);
        term.setFrame(frame);
    }

    public void quit() {
        this.thread = null;
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    public void setFGround(Object f) {
        if (f instanceof String) {
            this.fground = Color.getColor((String)f);
        }
        if (f instanceof Color) {
            this.fground = (Color)f;
        }
        this.graphics.setColor(this.fground);
    }

    public void setBGround(Object b2) {
        if (b2 instanceof String) {
            this.bground = Color.getColor((String)b2);
        }
        if (b2 instanceof Color) {
            this.bground = (Color)b2;
        }
        Graphics foog = this.background.getGraphics();
        foog.setColor(this.bground);
        foog.fillRect(0, 0, this.char_width, this.char_height);
        foog.dispose();
    }

    public Object getFGround() {
        return this.fground;
    }

    public Object getBGround() {
        return this.bground;
    }

    class MessageDialog
    implements ActionListener {
        Dialog dialog = null;

        MessageDialog(String title, String msg) {
            this.dialog = new Dialog(new Frame(), title, true);
            Button ok = new Button("OK");
            this.dialog.setLayout(new FlowLayout());
            this.dialog.setLocation(100, 50);
            ok.addActionListener(this);
            TextArea text = new TextArea(msg);
            this.dialog.add(text);
            text.setEditable(false);
            this.dialog.add(ok);
            this.dialog.pack();
            this.dialog.setVisible(true);
        }

        boolean isVisible() {
            return this.dialog.isVisible();
        }

        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            this.dialog.setVisible(false);
        }
    }

    class PromptDialog
    implements ActionListener {
        boolean result = false;
        Dialog dialog = null;

        PromptDialog(String title, String msg) {
            this.dialog = new Dialog(new Frame(), title, true);
            Button ok = new Button("YES");
            Button cancel = new Button("NO");
            this.dialog.setLayout(new FlowLayout());
            this.dialog.setLocation(100, 50);
            ok.addActionListener(this);
            cancel.addActionListener(this);
            TextArea text = new TextArea(msg);
            this.dialog.add(text);
            text.setEditable(false);
            this.dialog.add(ok);
            this.dialog.add(cancel);
            this.dialog.pack();
            this.dialog.setVisible(true);
        }

        boolean isVisible() {
            return this.dialog.isVisible();
        }

        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            if (action.equals("YES")) {
                this.result = true;
            }
            this.dialog.setVisible(false);
        }
    }

    class InputDialog
    implements ActionListener {
        String result = null;
        Dialog dialog = null;
        TextField textf = null;

        InputDialog(String title, String text, boolean passwd) {
            this.dialog = new Dialog(new Frame(), title, true);
            Button ok = new Button("OK");
            Button cancel = new Button("CANCEL");
            this.textf = new TextField(20);
            this.textf.setText(text);
            if (passwd) {
                this.textf.setEchoChar('*');
            }
            this.dialog.setLayout(new FlowLayout());
            this.dialog.setLocation(100, 50);
            ok.addActionListener(this);
            cancel.addActionListener(this);
            this.textf.addActionListener(this);
            this.dialog.add(this.textf);
            this.dialog.add(ok);
            this.dialog.add(cancel);
            this.dialog.pack();
            this.dialog.setVisible(true);
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ee) {
                    // empty catch block
                }
            } while (this.dialog.isVisible());
        }

        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            if (action.equals("OK")) {
                this.result = this.textf.getText();
            } else if (!action.equals("CANCEL")) {
                this.result = this.textf.getText();
            }
            this.dialog.setVisible(false);
        }

        String getText() {
            return this.result;
        }
    }

    public class MyUserInfo
    implements UserInfo {
        String passwd = null;
        String passphrase = null;

        public boolean promptYesNo(String str) {
            PromptDialog dialog = new PromptDialog("Warning", str);
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (dialog.isVisible());
            return dialog.result;
        }

        public String getPassword() {
            return this.passwd;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptPassword(String message) {
            InputDialog dialog = new InputDialog(message, "", true);
            this.passwd = dialog.getText();
            return this.passwd != null;
        }

        public boolean promptPassphrase(String message) {
            InputDialog dialog = new InputDialog(message, "", true);
            this.passphrase = dialog.getText();
            return this.passphrase != null;
        }

        public void showMessage(String message) {
            MessageDialog msg = new MessageDialog("", message);
        }
    }
}

