/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.settings;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropConfigGUI;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

public class PosConfigGUI
extends JPanel
implements PropConfigGUI {
    private Logger logger = Logger.getLogger(PosConfigGUI.class.getName());
    private GlobalProperties properties;
    private String key;
    private JTextField x;
    private JTextField y;
    private JTextField z;

    public PosConfigGUI(String text, String key, GlobalProperties properties) {
        this.key = key;
        this.properties = properties;
        this.setBorder(new TitledBorder(text));
        this.init();
    }

    private void init() {
        JPanel px = new JPanel();
        px.setBorder(new TitledBorder("x"));
        JPanel py = new JPanel();
        py.setBorder(new TitledBorder("y"));
        JPanel pz = new JPanel();
        pz.setBorder(new TitledBorder("z"));
        this.x = new JTextField(5);
        this.y = new JTextField(5);
        this.z = new JTextField(5);
        px.add(this.x);
        py.add(this.y);
        pz.add(this.z);
        this.setLayout(new BoxLayout(this, 0));
        this.add(px);
        this.add(py);
        this.add(pz);
        this.load();
        this.x.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                PosConfigGUI.this.save();
            }
        });
        this.y.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                PosConfigGUI.this.save();
            }
        });
        this.z.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                PosConfigGUI.this.save();
            }
        });
    }

    public void save() {
        try {
            String sx = this.x.getText().trim();
            String sy = this.y.getText().trim();
            String sz = this.z.getText().trim();
            Double.parseDouble(sx);
            Double.parseDouble(sy);
            Double.parseDouble(sz);
            String res = sx + "," + sy + "," + sz;
            this.properties.setProperty(this.key, res);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void load() {
        try {
            String[] spos = this.properties.getProperty(this.key).split(",");
            Float.parseFloat(spos[0]);
            Float.parseFloat(spos[1]);
            Float.parseFloat(spos[2]);
            this.x.setText(spos[0]);
            this.y.setText(spos[1]);
            this.z.setText(spos[2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

