/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser.tools;

import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.sftp.SftpClientPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class FileListPanel
extends ProjectManipulator {
    private Logger logger = Logger.getLogger(FileListPanel.class.getName());
    private SftpClientPanel sftpPanel;
    private HostInfo info;

    public FileListPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void init() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.sftpPanel = new SftpClientPanel(this.projectInfo.getProjectDirectory(), false);
        this.add(this.sftpPanel);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new BoxLayout(btnpanel, 0));
        JButton btnconnect = new JButton("connect");
        JButton btndisconnect = new JButton("disconnect");
        this.info = this.projectInfo.getHostInfo();
        JLabel label = new JLabel("target host: " + this.info.getName() + ", " + " target dir: " + this.projectInfo.getTargetDirectory());
        JPanel plabel = new JPanel();
        plabel.add(label);
        p.add(plabel);
        btnpanel.add(btnconnect);
        btnpanel.add(btndisconnect);
        p.add(btnpanel);
        boolean isLocal = this.info.isLocalHost();
        btnconnect.setEnabled(!isLocal);
        btndisconnect.setEnabled(!isLocal);
        this.add(p);
        btnconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListPanel.this.sftpPanel.setRemoteInitialDir(FileListPanel.this.projectInfo.getTargetDirectory());
                FileListPanel.this.sftpPanel.connect(FileListPanel.this.info);
            }
        });
        btndisconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListPanel.this.sftpPanel.disconnect();
                FileListPanel.this.init();
            }
        });
    }

    public boolean postProcess() {
        if (this.sftpPanel != null) {
            this.sftpPanel.disconnect();
        }
        return true;
    }

    public void initializeProject() {
    }
}

