/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeEvent;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeListener;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ChaseFileChooser
extends JFileChooser
implements ProjectDirBrowserNodeChangeListener,
ActionListener {
    private Logger logger = Logger.getLogger(ChaseFileChooser.class.getName());
    public static final String base = "base";
    public static final String graph = "graph";
    public static final String pp = "pp";
    public static final String atom = "atom";
    public static final String media = "media";
    public static final String log = "log";
    public static final String path = "path";
    public static final String script = "script";
    public static final String input = "input";
    private String type;
    private static GlobalProperties mrud = PropertiesManager.getGlobalProperties(5);

    public ChaseFileChooser() {
        this.type = base;
        String initDir = mrud.getProperty(this.type);
        if (initDir == null) {
            initDir = ".";
        }
        this.setCurrentDirectory(new File(initDir));
    }

    public ChaseFileChooser(String type) {
        this.type = type;
        String initDir = mrud.getProperty(type);
        if (initDir == null) {
            initDir = ".";
        }
        this.setCurrentDirectory(new File(initDir));
    }

    public ChaseFileChooser(boolean projDirBrowser) {
        if (projDirBrowser) {
            JPanel pac = new JPanel();
            pac.setLayout(new BoxLayout(pac, 1));
            JButton btn = new JButton("to install dir");
            JPanel p = new JPanel();
            p.add(btn);
            pac.add(p);
            pac.add(new ProjectDirBrowser("projects", new ProjectDirBrowserNodeChangeListener[]{this}));
            this.setAccessory(pac);
            btn.addActionListener(this);
        }
        this.type = base;
        String initDir = mrud.getProperty(this.type);
        if (initDir == null) {
            initDir = ".";
        }
        this.setCurrentDirectory(new File(initDir));
    }

    public ChaseFileChooser(String type, boolean projDirBrowser) {
        if (projDirBrowser) {
            JPanel pac = new JPanel();
            pac.setLayout(new BoxLayout(pac, 1));
            JButton btn = new JButton("to install directory");
            JPanel p = new JPanel();
            p.add(btn);
            pac.add(p);
            pac.add(new ProjectDirBrowser("projects", new ProjectDirBrowserNodeChangeListener[]{this}));
            this.setAccessory(pac);
            btn.addActionListener(this);
        }
        this.type = type;
        String initDir = mrud.getProperty(type);
        if (initDir == null) {
            initDir = ".";
        }
        this.setCurrentDirectory(new File(initDir));
    }

    public File getSelectedFile() {
        File file = super.getSelectedFile();
        if (file == null) {
            return file;
        }
        String parent = file.isDirectory() ? file.getAbsolutePath() : file.getParent();
        mrud.setProperty(this.type, parent);
        mrud.storeProperty();
        return file;
    }

    public File[] getSelectedFiles() {
        File[] file = super.getSelectedFiles();
        if (file == null) {
            return null;
        }
        String parent = file[0].getParent();
        if (file[0].isDirectory()) {
            parent = file[0].getAbsolutePath();
        }
        mrud.setProperty(this.type, parent);
        mrud.storeProperty();
        return file;
    }

    public void nodeSelected(ProjectDirBrowserNodeChangeEvent e) {
        if (e == null || e.getSource() == null) {
            return;
        }
        ProjectDirBrowserNode node = (ProjectDirBrowserNode)e.getSource();
        ProjectInfo proj = node.getProjectInfo();
        this.setCurrentDirectory(new File(proj.getProjectDirectory()));
    }

    public void actionPerformed(ActionEvent arg0) {
        File chasedir = new File(System.getProperty("pviewer.home"));
        this.setCurrentDirectory(chasedir);
    }

    protected int getSelectedFileFilterIndex() {
        int index = 0;
        FileFilter[] filters = this.getChoosableFileFilters();
        FileFilter currFilter = this.getFileFilter();
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] != currFilter) continue;
            index = i;
        }
        return index;
    }
}

