/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.keylistener;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.apache.log4j.Logger;

public class SelectAll
implements KeyListener,
PropertiesListener {
    private Logger logger = Logger.getLogger(SelectAll.class.getName());
    private J3DPanel parent;
    private TGAtom tgatom;

    public SelectAll(J3DPanel parent) {
        this.parent = parent;
        PropertiesManager.getGlobalProperties(1);
        GlobalProperties.addPropertiesListener(this);
        if (parent instanceof CoordsViewerInterface) {
            this.tgatom = (TGAtom)((CoordsViewerInterface)((Object)parent)).getScene().getTGAtom();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (!(this.parent instanceof CoordsViewerInterface)) {
            return;
        }
        this.logger.debug("keyCode: " + e.getKeyCode());
        if (e.isControlDown() && e.getKeyCode() == 65) {
            AtomObject[] aobjs = this.tgatom.getAtomObjects();
            int nselec = 0;
            int nnselec = 0;
            for (AtomObject aobj : aobjs) {
                boolean b = aobj.toggleSelected();
                if (b) {
                    ++nselec;
                    continue;
                }
                ++nnselec;
            }
            if (nselec > 0) {
                this.logger.info("selected " + nselec + " atoms");
            }
            if (nnselec > 0) {
                this.logger.info("deselected " + nnselec + " atoms");
            }
        }
    }

    public void propertiesStored(GlobalProperties properties) {
    }
}

