/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer;

import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;

class Rectangle
extends BranchGroup {
    private Shape3D rectangle;
    private float width;
    private float height;
    private int resolution = 4;
    private int length = this.resolution + 1;
    private Appearance appearance = new Appearance();
    private LineAttributes lineAttrib = new LineAttributes();

    protected Rectangle(float width, float height) {
        this.width = width;
        this.height = height;
        this.appearance.setColoringAttributes(new ColoringAttributes(0.0f, 0.0f, 0.0f, 1));
        this.lineAttrib.setLineWidth(1.0f);
        this.appearance.setLineAttributes(this.lineAttrib);
        this.setCapability(17);
        this.rectangle = this.createRectangle();
        this.rectangle.setCapability(12);
        this.rectangle.setCapability(13);
        this.addChild((Node)this.rectangle);
    }

    protected void setRectangleShape(float width, float height) {
        this.width = width;
        this.height = height;
    }

    protected void updateRectangle() {
        this.rectangle.setGeometry((Geometry)this.getGeometry());
    }

    private Shape3D createRectangle() {
        LineStripArray lsa = this.getGeometry();
        Shape3D shape = new Shape3D((Geometry)lsa, this.appearance);
        return shape;
    }

    private LineStripArray getGeometry() {
        LineStripArray lsa = new LineStripArray(this.length, 1, new int[]{this.length});
        Point3f pt0 = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f pt1 = new Point3f(0.0f, this.height, 0.0f);
        Point3f pt2 = new Point3f(this.width, this.height, 0.0f);
        Point3f pt3 = new Point3f(this.width, 0.0f, 0.0f);
        Point3f pt4 = new Point3f(0.0f, 0.0f, 0.0f);
        lsa.setCoordinate(0, pt0);
        lsa.setCoordinate(1, pt1);
        lsa.setCoordinate(2, pt2);
        lsa.setCoordinate(3, pt3);
        lsa.setCoordinate(4, pt4);
        try {
            lsa.setCapability(18);
        }
        catch (RestrictedAccessException rae) {
            // empty catch block
        }
        return lsa;
    }
}

