/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import org.freehep.graphicsio.font.FontIncluder;
import org.freehep.graphicsio.font.encoding.CharTable;
import org.freehep.graphicsio.pdf.PDFCharTableWriter;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFFontIncluder
extends FontIncluder {
    private static final int PLAIN = 0;
    private static final int BOLD = 1;
    private static final int ITALIC = 2;
    private static final int BOLDITALIC = 3;
    private static final int COURIER = 0;
    private static final int HELVETICA = 1;
    private static final int TIMES = 2;
    private static final int SYMBOL = 3;
    private static final int DINGBATS = 4;
    private static final String[][] STANDARD_FONT = new String[][]{{"Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique"}, {"Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-BoldOblique"}, {"Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic"}, {"Symbol"}, {"ZapfDingbats"}};
    private PDFWriter pdf;
    private String reference;
    private PDFRedundanceTracker redundanceTracker;

    public PDFFontIncluder(FontRenderContext context, PDFWriter pdf, String reference, PDFRedundanceTracker redundanceTracker) {
        super(context);
        this.pdf = pdf;
        this.reference = reference;
        this.redundanceTracker = redundanceTracker;
    }

    protected void openIncludeFont() throws IOException {
        int style = PDFFontIncluder.getFontStyle(this.getFont());
        int fontBaseIndex = PDFFontIncluder.getFontBaseIndex(this.getFont());
        PDFDictionary font = this.pdf.openDictionary(this.reference);
        font.entry("Type", this.pdf.name("Font"));
        font.entry("Subtype", this.pdf.name("Type1"));
        font.entry("Name", this.pdf.name(this.reference));
        font.entry("BaseFont", this.pdf.name(STANDARD_FONT[fontBaseIndex][style]));
        font.entry("Encoding", this.redundanceTracker.getReference(this.getEncodingTable(), PDFCharTableWriter.getInstance()));
        this.pdf.close(font);
    }

    protected void writeEncoding(CharTable charTable) throws IOException {
    }

    public static boolean isStandardFont(Font font) {
        String fontName = font.getName().toLowerCase();
        return fontName.indexOf("helvetica") >= 0 || fontName.indexOf("times") >= 0 || fontName.indexOf("courier") >= 0 || fontName.indexOf("symbol") >= 0 || fontName.indexOf("dingbats") >= 0;
    }

    private static int getFontBaseIndex(Font font) {
        String fontName = font.getName().toLowerCase();
        if (fontName.indexOf("helvetica") >= 0) {
            return 1;
        }
        if (fontName.indexOf("times") >= 0) {
            return 2;
        }
        if (fontName.indexOf("courier") >= 0) {
            return 0;
        }
        if (fontName.indexOf("symbol") >= 0) {
            return 3;
        }
        if (fontName.indexOf("dingbats") >= 0) {
            return 4;
        }
        return 1;
    }

    private static int getFontStyle(Font font) {
        int fontBase = PDFFontIncluder.getFontBaseIndex(font);
        if (fontBase >= 0 && STANDARD_FONT[fontBase].length == 1) {
            return 0;
        }
        if (fontBase < 0) {
            return -1;
        }
        if (font.isBold()) {
            if (font.isItalic()) {
                return 3;
            }
            return 1;
        }
        if (font.isItalic()) {
            return 2;
        }
        return 0;
    }
}

