/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.remotehostexecuter;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.advancesoft.chase.common.InputPanel;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.ssh.remotehostexecuter.FileTransferSchemeManager;
import jp.advancesoft.chase.ssh.remotehostexecuter.FileTransferSchemeTable;
import jp.advancesoft.chase.ssh.remotehostexecuter.FileTransferSchemeTableModel;
import org.apache.log4j.Logger;

public class FileTransferSchemePanel
extends InternalFrameChase {
    private Logger logger = Logger.getLogger(FileTransferSchemePanel.class.getClass());
    private FileTransferSchemeTableModel tableModel;
    private InputPanel target;
    private InputPanel local;
    private FileTransferSchemeManager manager;

    public FileTransferSchemePanel(FileTransferSchemeManager manager) {
        super("edit file transfer scheme", true, true, true, true, new Dimension(800, 450));
        this.manager = manager;
        this.init();
    }

    private void init() {
        Container cont = this.getContentPane();
        cont.setLayout(new BoxLayout(cont, 1));
        cont.add(this.createPathViewers());
        cont.add(this.createTable());
        cont.add(this.createButtons());
    }

    private JPanel createPathViewers() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.target = new InputPanel("target dir for " + this.manager.getHostInfo().getName(), 0, 10);
        this.target.setValue(this.manager.getTargetDir());
        this.target.getTextField().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                FileTransferSchemePanel.this.manager.setTargetDir(FileTransferSchemePanel.this.target.getValue());
            }
        });
        panel.add(this.target);
        panel.setPreferredSize(new Dimension(800, 60));
        panel.setMinimumSize(new Dimension(800, 60));
        panel.setMaximumSize(new Dimension(800, 60));
        return panel;
    }

    private JPanel createTable() {
        this.logger.debug("at createtable");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 1));
        int numfiles = this.manager.getNumFiles();
        Object[] colnames = this.manager.getColNames();
        if (colnames == null) {
            this.logger.error("invalid file transfer scheme ...");
            return panel;
        }
        this.tableModel = new FileTransferSchemeTableModel(colnames, numfiles);
        this.manager.createTableModel(this.tableModel);
        FileTransferSchemeTable table = new FileTransferSchemeTable(this.tableModel, this.manager);
        JScrollPane scrpane = new JScrollPane();
        scrpane.getViewport().setView(table);
        panel.add(scrpane);
        return panel;
    }

    private JPanel createButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2));
        JButton btnsave = new JButton("save to disk");
        JButton btnclose = new JButton("close");
        btnsave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileTransferSchemePanel.this.manager.saveToDisk(FileTransferSchemePanel.this.tableModel);
            }
        });
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileTransferSchemePanel.this.dispose();
            }
        });
        panel.add(btnsave);
        panel.add(btnclose);
        return panel;
    }
}

