/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import jp.advancesoft.chase.common.ElementInfo;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.phase.AddButton;
import jp.advancesoft.chase.phase.ChoicePanelPhase;
import jp.advancesoft.chase.phase.CloseButton;
import jp.advancesoft.chase.phase.DeleteButton;
import jp.advancesoft.chase.phase.InputPanelPhase;
import jp.advancesoft.chase.phase.PhaseInputChildrenPanel;
import jp.advancesoft.chase.phase.PhaseInputPanelInterface;
import jp.advancesoft.chase.phase.TableForInputInterface;
import jp.advancesoft.chase.phase.TableModelForInputInterface;
import org.apache.log4j.Logger;

class ElementList
extends PhaseInputChildrenPanel {
    private static Logger logger = Logger.getLogger(ElementList.class.getName());
    private ElementInfo eI;
    private String[] elements_list;
    private String[] atomic_num_list;
    private JComboBox combo_elm;
    private JComboBox combo_num;
    private TableForInputInterface tbl_elm;
    private ChoicePanelPhase cppelm;
    private ChoicePanelPhase cppatnum;
    private InputPanelPhase ippmass;

    public ElementList(InputInterface inputInterface) {
        super("Element List", true, true, true, true, inputInterface, new Dimension(500, 450));
    }

    void createGUI() {
        Container cont = this.getContentPane();
        cont.setLayout(new BoxLayout(cont, 1));
        cont.add(this.createElementListPanel());
        cont.add(new CloseButton(this));
        this.setResizable(true);
    }

    public void delete() {
    }

    public void add() {
    }

    public void save() {
    }

    private JPanel createElementListPanel() {
        JPanel p = new JPanel();
        p.setSize(500, 250);
        this.eI = new ElementInfo();
        int num_elements = this.eI.num_elements;
        this.elements_list = new String[num_elements - 1];
        this.atomic_num_list = new String[num_elements - 1];
        for (int i = 1; i < num_elements; ++i) {
            this.elements_list[i - 1] = this.eI.getSymbolFromNumber(i);
            this.atomic_num_list[i - 1] = Integer.toString(i);
            logger.debug("got symbol: " + this.eI.getSymbolFromNumber(i) + " whose atomic number is: " + i);
        }
        JPanel p_element = new JPanel();
        p_element.setLayout(new BoxLayout(p_element, 0));
        String[] elmSpec = new String[]{"structure.element_list.table"};
        this.tbl_elm = new TableForInputInterface(elmSpec, this.inputInterface);
        this.tbl_elm.setColumnSelectionAllowed(true);
        this.tbl_elm.setRowSelectionAllowed(true);
        Object[] colname_elm = new String[]{"element", "atomicnumber", "mass", "zeta", "deviation"};
        TableModelForInputInterface tblmod_elm = new TableModelForInputInterface(this.tbl_elm, colname_elm, 0, (EventListener)this);
        this.tbl_elm.setModel(tblmod_elm);
        this.setEditorForElementTable();
        JScrollPane scrPane = new JScrollPane();
        scrPane.getViewport().setView(this.tbl_elm);
        scrPane.setPreferredSize(new Dimension(450, 250));
        p_element.add(Box.createVerticalStrut(100));
        p_element.add(scrPane);
        p_element.add(Box.createVerticalStrut(100));
        p.add(p_element);
        p.add(Box.createVerticalStrut(5));
        JPanel p_element_new = new JPanel();
        p_element_new.setLayout(new GridLayout(2, 3, 1, 1));
        String[] dummy = new String[]{""};
        this.cppelm = new ChoicePanelPhase(dummy, this.inputInterface, "element", this.elements_list);
        p_element_new.add(this.cppelm);
        this.cppatnum = new ChoicePanelPhase(dummy, this.inputInterface, "atomic number", this.atomic_num_list);
        p_element_new.add(this.cppatnum);
        this.ippmass = new InputPanelPhase(dummy, this.inputInterface, "mass", 0, 7);
        p_element_new.add(this.ippmass);
        InputPanelPhase ippzeta = new InputPanelPhase(dummy, this.inputInterface, "zeta", 0, 7);
        p_element_new.add(ippzeta);
        InputPanelPhase ippdev = new InputPanelPhase(dummy, this.inputInterface, "deviation", 0, 7);
        p_element_new.add(ippdev);
        this.cppelm.getComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String symbol = (String)ElementList.this.cppelm.getComboBox().getSelectedItem();
                String number = String.valueOf(ElementList.this.eI.getNumberFromSymbol(symbol));
                String mass = ElementList.this.eI.getMassFromSymbol(symbol);
                ElementList.this.cppatnum.getComboBox().setSelectedItem(number);
                ElementList.this.ippmass.getTextField().setText(mass);
            }
        });
        this.cppatnum.getComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String number = (String)ElementList.this.cppatnum.getComboBox().getSelectedItem();
                String symbol = ElementList.this.eI.getSymbolFromNumber(Integer.parseInt(number));
                String mass = ElementList.this.eI.getMassFromNumber(Integer.parseInt(number));
                ElementList.this.cppelm.getComboBox().setSelectedItem(symbol);
                ElementList.this.ippmass.getTextField().setText(mass);
            }
        });
        this.cppelm.getComboBox().setSelectedItem("H");
        p.add(p_element_new);
        PhaseInputPanelInterface[] guis = new PhaseInputPanelInterface[]{this.cppelm, this.cppatnum, this.ippmass, ippzeta, ippdev};
        AddButton addButton = new AddButton(this.tbl_elm, guis, this);
        DeleteButton deleteButton = new DeleteButton(this.tbl_elm, this);
        JPanel p_elmbtn = new JPanel();
        p_elmbtn.setLayout(new BoxLayout(p_elmbtn, 0));
        p_elmbtn.setSize(300, 50);
        p_elmbtn.add(addButton);
        p_elmbtn.add(deleteButton);
        p.add(p_elmbtn);
        p.add(Box.createVerticalStrut(5));
        p.add(p_elmbtn);
        p.add(Box.createVerticalStrut(5));
        return p;
    }

    private void setEditorForElementTable() {
        TableColumn column_elm = this.tbl_elm.getColumnModel().getColumn(0);
        this.combo_elm = new JComboBox<String>(this.elements_list);
        column_elm.setCellEditor(new DefaultCellEditor(this.combo_elm));
        TableColumn column_num = this.tbl_elm.getColumnModel().getColumn(1);
        this.combo_num = new JComboBox<String>(this.atomic_num_list);
        column_num.setCellEditor(new DefaultCellEditor(this.combo_num));
        this.combo_elm.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String symbolSelected = (String)ElementList.this.combo_elm.getSelectedItem();
                int row = ElementList.this.tbl_elm.getSelectedRow();
                if (row >= 0 && ElementList.this.combo_elm.isPopupVisible()) {
                    try {
                        ElementList.this.tbl_elm.setValueAt(String.valueOf(ElementList.this.eI.getNumberFromSymbol(symbolSelected)), row, 1);
                        ElementList.this.tbl_elm.setValueAt(ElementList.this.eI.getMassFromSymbol(symbolSelected), row, 2);
                    }
                    catch (Exception ee) {
                        System.out.println("failed to obtain number and mass from symbol");
                        ee.printStackTrace();
                    }
                }
                ElementList.this.updateTable();
            }
        });
        this.combo_num.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String numberSelected = (String)ElementList.this.combo_num.getSelectedItem();
                int row = ElementList.this.tbl_elm.getSelectedRow();
                if (row >= 0 && ElementList.this.combo_num.isPopupVisible()) {
                    try {
                        ElementList.this.tbl_elm.setValueAt(ElementList.this.eI.getSymbolFromNumber(Integer.parseInt(numberSelected)), row, 0);
                        ElementList.this.tbl_elm.setValueAt(ElementList.this.eI.getMassFromNumber(Integer.parseInt(numberSelected)), row, 2);
                    }
                    catch (Exception ee) {
                        System.out.println("failed to obtain symbol and mass from atomic number");
                    }
                }
                ElementList.this.updateTable();
            }
        });
    }

    private void updateTable() {
        this.tbl_elm.update(this.tbl_elm.getGraphics());
    }
}

