/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfaceBlock;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import jp.advancesoft.chase.phase.PhaseInputFrame;
import org.apache.log4j.Logger;

class ComboBoxPhase
extends JComboBox
implements Command {
    private static Logger logger = Logger.getLogger(ComboBoxPhase.class.getName());
    private String[] inputSpecifications;
    private InputInterface inputinterface;
    private String[] choices;
    private Vector disabableGUIs = new Vector();

    public ComboBoxPhase(String[] choices, String[] inputSpecifications, InputInterface inputinterface) {
        super(choices);
        this.choices = choices;
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
    }

    public void execute(EventObject e) {
        this.inputinterface.selectRoot();
        String newText = (String)super.getSelectedItem();
        logger.debug(super.getSelectedItem());
        String inp = this.inputSpecifications[0];
        logger.debug("inp: " + inp);
        String[] fullName = inp.split("\\.");
        for (int i = 0; i < fullName.length - 1; ++i) {
            String ident = fullName[i];
            if (this.inputinterface.selectBlock(ident)) continue;
            logger.debug("creating block: " + ident);
            this.inputinterface.addBlock(new InputInterfaceBlock(ident));
        }
        InputInterfacePrimitiveEntry entry = this.inputinterface.getPrimitiveEntry(fullName[fullName.length - 1]);
        entry.setName(fullName[fullName.length - 1]);
        entry.setValue(((String)super.getSelectedItem()).toLowerCase());
        entry.setUnit("");
        if (newText != null || !newText.equals(PhaseInputFrame.NO_SELECTION)) {
            this.inputinterface.replaceEntry(entry);
            logger.debug("replaced: " + entry.getName() + "=" + entry.getValue());
        } else {
            this.inputinterface.removeEntry(entry);
            logger.debug("removed: " + entry.getName() + "=" + entry.getValue());
        }
        this.inputinterface.selectRoot();
        for (int i = 0; i < this.disabableGUIs.size(); ++i) {
            Vector disset = (Vector)this.disabableGUIs.get(i);
            int[] index = (int[])disset.get(0);
            JComponent jcomponent = (JComponent)disset.get(1);
            int selectedIndex = super.getSelectedIndex();
            boolean enable = true;
            for (int j2 = 0; j2 < index.length; ++j2) {
                logger.debug("diabable gui, index: " + index[j2]);
                if (selectedIndex != index[j2]) continue;
                enable = false;
            }
            jcomponent.setEnabled(enable);
        }
    }

    protected void setDisabableGUI(int[] index, JComponent jcomponent) {
        Vector<Object> disset = new Vector<Object>();
        disset.add(index);
        disset.add(jcomponent);
        this.disabableGUIs.add(disset);
    }
}

