/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.common;

import java.io.IOException;
import java.net.URL;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XMLUtils {
    private static Logger logger = Logger.getLogger(XMLUtils.class.getName());

    private XMLUtils() {
    }

    public static Document getDocumentFrom(URL url) {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        if (url == null) {
            url = XMLUtils.class.getResource("/jp/advancesoft/chase/main/properties.xml");
        }
        try {
            doc = builder.build(url);
        }
        catch (JDOMException jde) {
            logger.error("failed to parse " + url);
            logger.error("unrecoverable error... contact AdvanceSoft.");
            jde.printStackTrace();
        }
        catch (IOException ioe) {
            logger.error("failed to parse " + url);
            logger.error("unrecoverable error... contact AdvanceSoft.");
            ioe.printStackTrace();
        }
        return doc;
    }

    public static Element[] getElementsFromTableModel(TableModel model, String rowname) {
        int numrow = model.getRowCount();
        Element[] ret = new Element[numrow];
        if (model == null) {
            logger.error("'table model' is null.");
            return null;
        }
        int numcol = model.getColumnCount();
        for (int i = 0; i < numrow; ++i) {
            Element elemroot = new Element(rowname);
            for (int j = 0; j < numcol; ++j) {
                String colname = model.getColumnName(j);
                Element element = new Element(colname);
                Object obj = model.getValueAt(i, j);
                String sobj = "";
                if (obj instanceof String) {
                    sobj = (String)obj;
                } else if (obj instanceof Boolean) {
                    sobj = ((Boolean)obj).toString();
                }
                element.addContent(sobj);
                elemroot.addContent(element);
            }
            ret[i] = elemroot;
        }
        return ret;
    }
}

