/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.scenegraphelements;

import com.sun.j3d.utils.geometry.Text2D;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.text.Format;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import jp.advancesoft.chase.acviewer.CylinderCreator;
import jp.advancesoft.chase.acviewer.mouselistener.MouseMotionListenerAction;
import jp.advancesoft.chase.acviewer.scenegraphelements.Atom;
import jp.advancesoft.chase.acviewer.scenegraphelements.AtomBufferBranchGroup;
import jp.advancesoft.chase.acviewer.scenegraphelements.Circle;
import jp.advancesoft.chase.acviewer.scenegraphelements.DynamicallyEditableTG;
import jp.advancesoft.chase.acviewer.scenegraphelements.TGAtom;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.common.ElementInfo;
import jp.advancesoft.chase.common.VectorOperations;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;

public class AtomObject
extends DynamicallyEditableTG {
    private static Logger logger = Logger.getLogger(AtomObject.class.getName());
    private int mobile;
    private int weight;
    private int atomicNumber;
    private String ID;
    private double[] dp;
    private double[] force;
    private Vector3d pos;
    private Vector3d vforce;
    private Transform3D translate = new Transform3D();
    private int labelOffset = 0;
    private float mobilityFactor = 1.0f;
    private float[] color = new float[3];
    private float scaleatom = 1.0f;
    private float radius = 1.0f;
    private int numNodes = 20;
    private Canvas3D canvas;
    private Atom atom;
    private boolean selected = false;
    private Circle circle;
    private BranchGroup forceArrow;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    private JPopupMenu popup = new JPopupMenu();
    private JLabel menuItem = new JLabel();
    private JLabel menuDist = new JLabel();
    private Format format = ConstParameters.formater_smaller_digits;
    private String elementName;
    private boolean drawArrow = false;
    private double arrowScale = 1.0;
    private double arrowRadius = 0.005;
    private float arrowHeadRadius = 0.02f;
    private float arrowHeadHeight = 0.04f;
    float[] color_wk = new float[]{0.2f, 0.2f, 0.5f};

    public AtomObject(String ID, int atomicNumber, double[] dp, int mobile, int weight) {
        this.ID = ID;
        this.atomicNumber = atomicNumber;
        this.mobile = mobile;
        this.weight = weight;
        this.dp = dp;
        this.pos = new Vector3d(dp);
        this.translate.set(this.pos);
        this.translate.setScale(1.0);
        this.setTransform(this.translate);
    }

    public AtomObject(String ID, int atomicNumber, double[] dp, double[] force, int mobile, int weight) {
        this.ID = ID;
        this.atomicNumber = atomicNumber;
        this.mobile = mobile;
        this.weight = weight;
        this.dp = dp;
        this.force = force;
        this.pos = new Vector3d(dp);
        this.vforce = new Vector3d(force);
        this.translate.set(this.pos);
        this.translate.setScale(1.0);
        this.setTransform(this.translate);
    }

    public void showPopup(int canvx, int canvy, double scale) {
        TransformGroup tg = this.getTransformBuffer();
        if (tg == null) {
            return;
        }
        Point loc = this.getLocationOnScreen(canvx, canvy, scale, tg);
        double[] cds = this.getCoordinatesInRealWorld(tg);
        this.menuItem.setText("atom No. " + this.ID + ", " + this.elementName + ", x: " + this.format.format(cds[0]) + ", y: " + this.format.format(cds[1]) + " z: " + this.format.format(cds[2]));
        double[] origPos = this.getCoordinatesInRealWorld(this);
        double[] diff = new double[]{cds[0] - origPos[0], cds[1] - origPos[1], cds[2] - origPos[2]};
        String ori = this.format.format(VectorOperations.norm(diff));
        this.menuDist.setText("distance from original position: " + ori);
        this.popup.setLocation(loc.x, loc.y);
        if (!this.popup.isVisible()) {
            this.popup.setVisible(true);
        }
    }

    public Point getLocationOnScreen(int canvx, int canvy, double scale, TransformGroup atomTransform) {
        if (atomTransform == null) {
            return new Point(0, 0);
        }
        Transform3D tf3d = new Transform3D();
        this.parent.getTransform(tf3d);
        Transform3D atomTrans = new Transform3D();
        atomTransform.getTransform(atomTrans);
        Vector3d vec = new Vector3d();
        atomTrans.get(vec);
        Point3d atomvec = new Point3d();
        atomvec.x = vec.x;
        atomvec.y = vec.y;
        atomvec.z = vec.z;
        tf3d.transform(atomvec);
        int x = (int)((atomvec.x + scale) * (double)canvx / (2.0 * scale));
        int y = (int)((-atomvec.y + scale) * (double)canvy / (2.0 * scale));
        return new Point(x + this.mACVD.getParent().getLocationOnScreen().x, y + this.mACVD.getParent().getLocationOnScreen().y);
    }

    public void removePopup() {
        this.popup.setVisible(false);
    }

    private BranchGroup getCopyOfAtom(float transparency, Transform3D transform) {
        Appearance app = this.createAppearance(transparency);
        Atom tmpatom = new Atom(this.radius * this.scaleatom, 1, this.numNodes, app, this);
        tmpatom.isTemp(true);
        BranchGroup bra = new BranchGroup();
        bra.addChild((Node)tmpatom);
        TransformGroup group = new TransformGroup();
        group.setCapability(17);
        group.setCapability(18);
        group.setTransform(transform);
        group.addChild((Node)bra);
        AtomBufferBranchGroup ret = new AtomBufferBranchGroup();
        ret.addChild((Node)group);
        ret.setTransformGroup(group);
        ret.setAtomObject(this);
        return ret;
    }

    private Appearance createAppearance(float transparency) {
        Appearance app = new Appearance();
        ColoringAttributes ca = new ColoringAttributes();
        RenderingAttributes ra = new RenderingAttributes();
        ra.setIgnoreVertexColors(true);
        app.setRenderingAttributes(ra);
        Material material = new Material();
        material.setDiffuseColor(new Color3f(this.color));
        material.setShininess(120.0f);
        app.setMaterial(material);
        TransparencyAttributes ta = new TransparencyAttributes(2, 0.0f);
        ta.setTransparency(transparency);
        app.setTransparencyAttributes(ta);
        return app;
    }

    public void setAttributes() {
        if (this.mACVD.getText()) {
            this.setLabelOffset(this.mACVD.getLabelOffset());
        }
        if (this.mACVD.getMobile()) {
            this.setMobilityDisplayMode(this.mACVD.getMobilityDisplayMode());
        }
        float scaleatom = 2.2f * this.mACVD.getScaleAtom() / (float)Math.pow(this.mCD.getNumAt(), 0.3333333432674408);
        this.setScale(scaleatom);
        this.setColor(this.mACVD.getColor()[this.atomicNumber]);
        this.setRad(this.mACVD.getRad()[this.atomicNumber]);
        this.setNumNodes(this.mACVD.getNumNodesAtom());
    }

    public void configDataUpdate() {
        if (this.mACVD.getParent().doRedraw()) {
            return;
        }
        double lenmax = this.parent.getLenMax();
        double[] jusin = this.parent.getCOM();
        double[] pos_moto = this.mCD.getPos(Integer.parseInt(this.ID) - 1);
        logger.debug("atom no. " + this.ID + " is updating.");
        for (int i = 0; i < 3; ++i) {
            this.dp[i] = (pos_moto[i] - jusin[i]) / lenmax;
        }
        this.pos = new Vector3d(this.dp);
        this.translate.set(this.pos);
        this.setTransform(this.translate);
        this.force = this.mCD.getForce(Integer.parseInt(this.ID) - 1);
        if (this.forceArrow != null) {
            this.forceArrow.detach();
        }
        this.getArrowProps();
        if (this.force != null && this.drawArrow) {
            this.forceArrow = this.createForceArrow();
            this.addChild((Node)this.forceArrow);
        }
    }

    public void setPos(Vector3d newpos) {
        double[] dnewpos = this.mCD.getPosfromVirtualWorld(newpos.x, newpos.y, newpos.z);
        AtomCoords coords = this.mCD.getAtomCoords();
        jp.advancesoft.chase.atomcoord.Atom atnow = coords.getAtomList().getAtomAt(Integer.parseInt(this.ID) - 1);
        coords.getAtomList().replaceAtomAt(Integer.parseInt(this.ID) - 1, new jp.advancesoft.chase.atomcoord.Atom(atnow.getElementName(), dnewpos, atnow.getAuxil()));
        this.mCD.setCoordsNoUpdate(coords);
    }

    private double[] getCoordinatesInRealWorld(TransformGroup trans) {
        Transform3D t3d = new Transform3D();
        trans.getTransform(t3d);
        Vector3d vec3d = new Vector3d();
        t3d.get(vec3d);
        double lenmax = this.parent.getLenMax();
        double[] jusin = this.parent.getCOM();
        double[] ret = new double[]{vec3d.x * lenmax + jusin[0], vec3d.y * lenmax + jusin[1], vec3d.z * lenmax + jusin[2]};
        return ret;
    }

    public Vector3d getCoordinatesInVirtualWorld() {
        return this.getCoordinatesInVirtualWorld(this);
    }

    public Vector3d getCoordinatesInVirtualWorld(TransformGroup trans) {
        Transform3D t3d = new Transform3D();
        trans.getTransform(t3d);
        double lenmax = this.parent.getLenMax();
        double[] jusin = this.parent.getCOM();
        double[] pos_moto = this.mCD.getPos(Integer.parseInt(this.ID) - 1);
        logger.debug("atom no. " + this.ID + " is updating.");
        for (int i = 0; i < 3; ++i) {
            this.dp[i] = (pos_moto[i] - jusin[i]) / lenmax;
        }
        this.pos = new Vector3d(this.dp);
        t3d.transform(this.pos);
        return this.pos;
    }

    public void configDataUpdate(boolean foo) {
        this.configDataUpdate();
    }

    public boolean needsUpdate() {
        return true;
    }

    public int getAtomicNumber() {
        return this.atomicNumber;
    }

    public void setAtomicNumber(int atomicNumber) {
        this.atomicNumber = atomicNumber;
    }

    public String getMobile() {
        return String.valueOf(this.mobile);
    }

    public void setMobile(String mobile) {
        try {
            this.mobile = Integer.parseInt(mobile);
        }
        catch (NumberFormatException nfe) {
            this.mobile = 0;
        }
    }

    public String getWeight() {
        return String.valueOf(this.weight);
    }

    public void setWeight(String weight) {
        try {
            this.weight = Integer.parseInt(weight);
        }
        catch (NumberFormatException nfe) {
            this.weight = 1;
        }
    }

    public int getType() {
        return 0;
    }

    public Point3d getPos() {
        return new Point3d(this.dp);
    }

    public double[] getPosDouble() {
        return this.dp;
    }

    public void setPos(double[] pos) {
        this.dp = this.dp;
    }

    public void setForce(double[] force) {
        this.force = force;
    }

    public void update() {
        this.pos = new Vector3d(this.dp);
        this.translate.set(this.pos);
        this.setTransform(this.translate);
    }

    protected void create() {
        Appearance app = new Appearance();
        ColoringAttributes ca = new ColoringAttributes();
        RenderingAttributes ra = new RenderingAttributes();
        ra.setIgnoreVertexColors(true);
        app.setRenderingAttributes(ra);
        Material material = new Material();
        material.setDiffuseColor(new Color3f(this.color));
        material.setShininess(120.0f);
        app.setMaterial(material);
        this.atom = new Atom(this.radius * this.scaleatom, 1, this.numNodes, app, this);
        BranchGroup bra = new BranchGroup();
        bra.addChild((Node)this.atom);
        this.addChild((Node)bra);
        this.getArrowProps();
        if (this.force != null && this.drawArrow) {
            this.forceArrow = this.createForceArrow();
            this.addChild((Node)this.forceArrow);
        }
        ElementInfo info = new ElementInfo();
        this.elementName = info.getSymbolFromNumber(this.atomicNumber + 1);
        this.popup.setLightWeightPopupEnabled(false);
        this.popup.add(this.menuItem);
        this.popup.add(this.menuDist);
        this.popup.setInvoker(this.mACVD.getParent());
        this.setCapability(3);
        this.setCapability(4);
    }

    private void getArrowProps() {
        try {
            this.drawArrow = new Boolean(this.gp.getProperty("arrow_draw"));
            this.arrowScale = Double.parseDouble(this.gp.getProperty("arrow_scale"));
            this.arrowHeadRadius = Float.parseFloat(this.gp.getProperty("arrow_head_radius"));
            this.arrowHeadHeight = Float.parseFloat(this.gp.getProperty("arrow_head_height"));
            this.arrowRadius = Double.parseDouble(this.gp.getProperty("arrow_radius"));
            this.color_wk[0] = Float.parseFloat(this.gp.getProperty("arrow_color_r"));
            this.color_wk[1] = Float.parseFloat(this.gp.getProperty("arrow_color_g"));
            this.color_wk[2] = Float.parseFloat(this.gp.getProperty("arrow_color_b"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BranchGroup createForceArrow() {
        double len = VectorOperations.norm(new double[]{this.force[0] * this.arrowScale, this.force[1] * this.arrowScale, this.force[2] * this.arrowScale});
        float coneScale = 1.0f;
        if (len < (double)(this.radius * this.scaleatom)) {
            this.arrowScale = 0.0;
            coneScale = 0.0f;
        }
        Point3d siten = new Point3d(0.0, 0.0, 0.0);
        Point3d syuten = new Point3d(this.force[0] * this.arrowScale, this.force[1] * this.arrowScale, this.force[2] * this.arrowScale);
        Appearance app = new Appearance();
        Material material = new Material();
        material.setDiffuseColor(new Color3f(this.color_wk));
        material.setShininess(120.0f);
        app.setMaterial(material);
        CylinderCreator cylindercreate = new CylinderCreator();
        return cylindercreate.create(siten, syuten, this.arrowRadius, this.arrowHeadRadius * coneScale, this.arrowHeadHeight * coneScale, app);
    }

    public Atom getAtom() {
        return this.atom;
    }

    public String getID() {
        return this.ID;
    }

    protected void setLabelOffset(int labelOffset) {
        Point3f lp3f = new Point3f(0.0f, 0.0f, 0.0f);
        this.labelOffset = labelOffset;
        Color3f color_wkl2 = new Color3f(0.0f, 0.0f, 0.0f);
        String offset = new String();
        for (int i = 0; i < labelOffset; ++i) {
            offset = offset + " ";
        }
        Font font = this.mACVD.getFont();
        Text2D text2d = new Text2D(offset + this.ID, color_wkl2, font.getName(), font.getSize(), font.getStyle());
        OrientedShape3D orientedShape = new OrientedShape3D(text2d.getGeometry(), text2d.getAppearance(), 1, lp3f);
        this.addChild((Node)orientedShape);
    }

    protected void setMobilityDisplayMode(int mobilityDisplayMode) {
        if (this.mobile == 1) {
            if (mobilityDisplayMode == 0) {
                this.mobilityFactor = 0.6f;
            } else if (mobilityDisplayMode == 1) {
                this.mobilityFactor = 1.5f;
            }
        }
    }

    protected void setScale(float scaleatom) {
        this.scaleatom = scaleatom;
    }

    protected void setColor(float[] color) {
        this.color = color;
        for (int i = 0; i < 3; ++i) {
            color[i] = color[i] * this.mobilityFactor;
            if (!(color[i] >= 1.0f)) continue;
            color[i] = 1.0f;
        }
    }

    protected void setRad(float radius) {
        this.radius = radius;
    }

    public float getRad() {
        return this.radius;
    }

    protected void setNumNodes(int numNodes) {
        this.numNodes = numNodes;
    }

    protected void setCanvas(Canvas3D canvas) {
        this.canvas = canvas;
    }

    public void toggleSelected() {
        this.selected = !this.selected;
        this.doSelection();
    }

    public void unSelect() {
        this.selected = false;
        this.doSelection();
    }

    public void setSelected() {
        this.selected = true;
        this.doSelection();
    }

    public void createBuffer() {
        Transform3D t3d = new Transform3D();
        this.getTransform(t3d);
        float tr = 0.6f;
        try {
            tr = Float.parseFloat(this.gp.getProperty("transparency_of_temporary_atom"));
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.buffer = this.getCopyOfAtom(tr, t3d);
        for (int i = 0; i < this.buffer.numChildren(); ++i) {
            if (!(this.buffer.getChild(i) instanceof TransformGroup)) continue;
            this.transformBuffer = (TransformGroup)this.buffer.getChild(i);
        }
    }

    protected void postIntermediateState(Transform3D diff, TransformGroup parent, InputEvent event) {
        if (!this.selected) {
            return;
        }
        MouseEvent me = (MouseEvent)event;
        TGAtom tgatom = (TGAtom)parent;
        double screenScale = MouseMotionListenerAction.getScreenScale(tgatom.getParentFrame());
        Point3d ptmp = MouseMotionListenerAction.getCoordsFromMousePos(tgatom.getParentFrame(), me);
        int canvSizex = tgatom.getParentFrame().getCanvas().getSize().width;
        int canvSizey = tgatom.getParentFrame().getCanvas().getSize().height;
        if (((TGAtom)parent).getSelectedAtomCount() == 1 && me.getModifiersEx() == 4224) {
            Point patom = this.getLocationOnScreen(canvSizex, canvSizey, screenScale, this.getTransformBuffer());
            logger.debug("atom: getLocationOnScreen: " + patom);
            this.showPopup(canvSizex, canvSizey, screenScale);
        }
    }

    protected boolean intermediateStateNecessary() {
        return this.selected;
    }

    private void doSelection() {
        if (this.selected) {
            this.createBuffer();
            if (this.circle == null) {
                this.circle = new Circle(this.radius * this.scaleatom);
            }
            this.addChild((Node)this.circle);
            this.parent.selected(this);
        } else {
            if (this.buffer != null) {
                this.buffer.detach();
            }
            for (int i = 0; i < this.numChildren(); ++i) {
                Node child = this.getChild(i);
                if (!(child instanceof Circle)) continue;
                this.removeChild(i);
            }
            this.parent.deselected(this);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public BoundingSphere getTransformedBounds() {
        Transform3D translate = new Transform3D();
        this.getTransform(translate);
        Transform3D etc = new Transform3D();
        this.parent.getTransform(etc);
        etc.mul(translate);
        Bounds ret = this.getBounds();
        ret.transform(etc);
        return (BoundingSphere)ret;
    }

    public void dynamicallyEditFinalize(TransformGroup parent) {
        if (this.selected) {
            Transform3D t3d = new Transform3D();
            this.transformBuffer.getTransform(t3d);
            Vector3d atompos = new Vector3d();
            t3d.get(atompos);
            this.setPos(atompos);
            this.removePopup();
        }
    }

    public String toString() {
        String ret = "ID: " + this.ID + ", atomic number: " + String.valueOf(this.atomicNumber) + ", pos: " + this.pos;
        return ret;
    }
}

