/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.scenegraphelements;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.advancesoft.chase.acviewer.MainPanel;
import jp.advancesoft.chase.acviewer.scenegraphelements.ACVMultipleAtomEditor;
import jp.advancesoft.chase.acviewer.scenegraphelements.AtomObject;
import jp.advancesoft.chase.acviewer.scenegraphelements.TGAtom;
import jp.advancesoft.chase.atomcoord.Atom;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;

class ACVMultipleAtomEditorPanel
extends JPanel {
    private Logger logger = Logger.getLogger(ACVMultipleAtomEditorPanel.class.getName());
    private ACVMultipleAtomEditor parent;
    public JButton applyButton;
    public JButton closeButton;
    public JButton deleteButton;
    public JTextField editX;
    public JTextField editY;
    public JTextField editZ;
    public JPanel jPanel1;
    public JPanel jPanel2;
    public JPanel jPanel4;
    public JPanel jPanel5;
    public JPanel jPanel6;
    public JTextField jTextField5;

    protected ACVMultipleAtomEditorPanel(ACVMultipleAtomEditor parent) {
        this.parent = parent;
        this.initComponents();
    }

    private void initComponents() {
        this.jTextField5 = new JTextField();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.editY = new JTextField();
        this.jPanel5 = new JPanel();
        this.editZ = new JTextField();
        this.jPanel6 = new JPanel();
        this.editX = new JTextField();
        this.jPanel2 = new JPanel();
        this.closeButton = new JButton();
        this.applyButton = new JButton();
        this.deleteButton = new JButton();
        this.jTextField5.setText("0.0");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Translation", 0, 0, new Font("MS UI Gothic", 0, 12), new Color(0, 51, 102)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "y", 0, 0, new Font("MS UI Gothic", 2, 12)));
        this.editY.setText("0.0");
        this.editY.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ACVMultipleAtomEditorPanel.this.editYActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(1).add(this.editY, -1, 100, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(1).add(1, jPanel4Layout.createSequentialGroup().add(this.editY, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "z", 0, 0, new Font("MS UI Gothic", 2, 12)));
        this.editZ.setText("0.0");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(1).add(this.editZ, -1, 100, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(1).add(1, jPanel5Layout.createSequentialGroup().add(this.editZ, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(null, "x", 0, 0, new Font("MS UI Gothic", 2, 12)));
        this.editX.setText("0.0");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(1).add(this.editX, -1, 100, Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(1).add(1, jPanel6Layout.createSequentialGroup().add(this.editX, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(1, jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jPanel6, -2, -1, -2).add(20, 20, 20).add(this.jPanel4, -2, -1, -2).addPreferredGap(0, 17, Short.MAX_VALUE).add(this.jPanel5, -2, -1, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(1, jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(2, false).add(1, this.jPanel5).add(1, this.jPanel4).add(this.jPanel6)).addContainerGap()));
        this.closeButton.setText("close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ACVMultipleAtomEditorPanel.this.closeButtonActionPerformed(evt);
            }
        });
        this.applyButton.setText("apply");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ACVMultipleAtomEditorPanel.this.applyButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText("delete selected atoms");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ACVMultipleAtomEditorPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.applyButton).addPreferredGap(0).add(this.deleteButton).addPreferredGap(0).add(this.closeButton).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(1, jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(this.closeButton).add(1, jPanel2Layout.createParallelGroup(3).add(this.applyButton).add(this.deleteButton))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(1, layout.createSequentialGroup().add(layout.createParallelGroup(1).add(1, layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2)).add(1, layout.createSequentialGroup().add(69, 69, 69).add(this.jPanel2, -2, -1, -2))).addContainerGap(24, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(1, layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, 81, -2).addPreferredGap(0, 14, Short.MAX_VALUE).add(this.jPanel2, -2, -1, -2).addContainerGap()));
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.deleteAll();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.doTranslation();
        this.parent.getParentFrame().getCD().update();
        this.revalidate();
    }

    private void deleteAll() {
        MainPanel parentFrame = this.parent.getParentFrame();
        TGAtom tgatom = (TGAtom)parentFrame.getScene().getTGAtom();
        AtomObject[] atoms = tgatom.getSelectedAtoms();
        if (atoms == null || atoms.length == 0) {
            return;
        }
        AtomCoords coords = this.parent.getParentFrame().getCD().getAtomCoords();
        Vector<Integer> indexVector = new Vector<Integer>();
        for (int i = 0; i < atoms.length; ++i) {
            int id = Integer.parseInt(atoms[i].getID()) - 1;
            indexVector.addElement(new Integer(id));
        }
        if (indexVector.size() == 0) {
            return;
        }
        Object[] indeces = new Integer[indexVector.size()];
        indexVector.copyInto(indeces);
        Arrays.sort(indeces);
        for (int i = indeces.length - 1; i >= 0; --i) {
            coords.getAtomList().removeAtomAt((Integer)indeces[i]);
        }
        coords.getAtomList().setUndoCount(atoms.length);
        this.parent.getParentFrame().getCD().setCoords(coords);
        tgatom.deselectAll();
        this.revalidate();
    }

    private void doTranslation() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        try {
            x = Double.parseDouble(this.editX.getText());
            y = Double.parseDouble(this.editY.getText());
            z = Double.parseDouble(this.editZ.getText());
        }
        catch (NumberFormatException nfe) {
            this.logger.error("enter double values.");
            return;
        }
        catch (NullPointerException npe) {
            this.logger.error("found invalid value at 'translation'");
            return;
        }
        MainPanel parentFrame = this.parent.getParentFrame();
        TGAtom tgatom = (TGAtom)parentFrame.getScene().getTGAtom();
        AtomObject[] atoms = tgatom.getSelectedAtoms();
        if (atoms == null || atoms.length == 0) {
            return;
        }
        AtomCoords coords = this.parent.getParentFrame().getCD().getAtomCoords();
        for (int i = 0; i < atoms.length; ++i) {
            int id = Integer.parseInt(atoms[i].getID()) - 1;
            double[] pos = this.parent.getParentFrame().getCD().getPos(id);
            pos[0] = pos[0] + x;
            pos[1] = pos[1] + y;
            pos[2] = pos[2] + z;
            Atom atnow = coords.getAtomList().getAtomAt(id);
            coords.getAtomList().replaceAtomAt(id, new Atom(atnow.getElementName(), pos, atnow.getAuxil()));
        }
        coords.getAtomList().setUndoCount(atoms.length);
        this.parent.getParentFrame().getCD().setCoordsNoUpdate(coords);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.parent.dispose();
    }

    private void editYActionPerformed(ActionEvent evt) {
    }
}

