/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.PyArray;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public class ArrayModule {
    public static PyString __doc__ = new PyString("This module defines a new object type which can efficiently represent\nan array of basic values: characters, integers, floating point\nnumbers.  Arrays are sequence types and behave very much like lists,\nexcept that the type of objects stored in them is constrained.  The\ntype is specified at object creation time by using a type code, which\nis a single character.  The following type codes are defined:\n\n    Type code   C Type             Minimum size in bytes \n    'z'         boolean            1 \n    'c'         character          1 \n    'b'         signed integer     1 \n    'h'         signed integer     2 \n    'i'         signed integer     2 \n    'l'         signed integer     4 \n    'f'         floating point     4 \n    'd'         floating point     8 \n\nFunctions:\n\narray(typecode [, initializer]) -- create a new array\n\nSpecial Objects:\n\nArrayType -- type object for array objects\n");
    public static PyString __name__ = new PyString("array");

    public static PyArray ArrayType(char TypeCode) {
        return PyArray.array((PyObject)new PyList(), TypeCode);
    }

    public static PyObject ArrayType(char TypeCode, PyObject sequence) {
        return PyArray.array(sequence, TypeCode);
    }

    public static PyObject array(char TypeCode) {
        return PyArray.array((PyObject)new PyList(), TypeCode);
    }

    public static PyObject array(char TypeCode, PyObject sequence) {
        return PyArray.array(sequence, TypeCode);
    }

    public static PyArray array(Class type, PyObject seq) {
        return PyArray.array(seq, type);
    }

    public static PyArray zeros(char typecode, int n) {
        return PyArray.zeros(n, typecode);
    }

    public static PyArray zeros(Class type, int n) {
        return PyArray.zeros(n, type);
    }
}

