/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.util.comparison;

import hep.aida.ext.IComparisonAlgorithm;
import hep.aida.ext.IComparisonData;
import hep.aida.ext.IComparisonResult;
import hep.aida.ref.AidaUtils;
import hep.aida.util.comparison.ComparisonResult;
import java.util.Map;

public abstract class AbstractComparisonAlgorithm
implements IComparisonAlgorithm {
    private Map optionsMap;
    public static final int ONLY_BINNED_DATA = 0;
    public static final int ONLY_UNBINNED_DATA = 1;
    public static final int ANY_DATA = 2;
    public static final int ONLY_SAME_NUMBER_OF_EVENTS = 0;
    public static final int ANY_NUMBER_OF_EVENTS = 1;
    private int dataType;
    private int eventsType;
    private double rejectionLevel = 0.05;

    AbstractComparisonAlgorithm(int dataType, int eventsType) {
        this.dataType = dataType;
        this.eventsType = eventsType;
    }

    public IComparisonResult compare(IComparisonData d1, IComparisonData d2, String options) {
        if (!this.canCompare(d1, d2)) {
            throw new IllegalArgumentException("This algorithm " + this.algorithmNames()[0] + " cannot compare the given data sets.");
        }
        this.optionsMap = AidaUtils.parseOptions(options);
        this.applyOptions();
        this.setRejectionLevel();
        ComparisonResult result = new ComparisonResult();
        result.setMatchBounds(this.matchLowerBound(), this.matchUpperBound());
        result.setQuality(this.quality(d1, d2));
        result.setnDof(this.nDof(d1, d2));
        return result;
    }

    public abstract double quality(IComparisonData var1, IComparisonData var2);

    public void applyOptions() {
    }

    public int nDof(IComparisonData d1, IComparisonData d2) {
        return d1.nPoints();
    }

    public double matchLowerBound() {
        return this.rejectionLevel();
    }

    public double matchUpperBound() {
        return 1.0;
    }

    public boolean isOptionSet(String option) {
        return this.optionsMap.containsKey(option);
    }

    public String optionValue(String option) {
        return (String)this.optionsMap.get(option);
    }

    public abstract String[] algorithmNames();

    public void setRejectionLevel() {
        String rejectionLevelStr = this.optionValue("rejectionLevel");
        if (rejectionLevelStr != null) {
            this.rejectionLevel = Double.valueOf(rejectionLevelStr);
        }
    }

    public double rejectionLevel() {
        return this.rejectionLevel;
    }

    public double[] getCumulativeArray(IComparisonData d) {
        int i;
        int nPoints = d.nPoints();
        double[] cumulativeWeights = new double[nPoints];
        double sumOfWeights = 0.0;
        for (i = 0; i < nPoints; ++i) {
            double weight = d.weight(i);
            if (weight < 0.0) {
                weight = 0.0;
            }
            cumulativeWeights[i] = sumOfWeights += weight;
        }
        if (sumOfWeights != 0.0) {
            i = 0;
            while (i < nPoints) {
                int n = i++;
                cumulativeWeights[n] = cumulativeWeights[n] / sumOfWeights;
            }
        }
        return cumulativeWeights;
    }

    public boolean canCompare(IComparisonData d1, IComparisonData d2) {
        if (d1.type() != d2.type()) {
            throw new IllegalArgumentException("Cannot compare a binned data set with an unbinned one.");
        }
        if (d1.type() == 0 && this.dataType == 1) {
            return false;
        }
        if (d1.type() == 1 && this.dataType == 0) {
            return false;
        }
        if (d1.type() == 0 && !this.isBinningCompatible(d1, d2)) {
            return false;
        }
        return this.eventsType != 0 || d1.nPoints() == d2.nPoints();
    }

    private boolean isBinningCompatible(IComparisonData d1, IComparisonData d2) {
        int nBins = d1.nPoints();
        if (nBins != d2.nPoints()) {
            return false;
        }
        for (int i = 0; i < nBins; ++i) {
            if (d1.value(i) == d2.value(i)) continue;
            return false;
        }
        return true;
    }

    public double sumOfWeights(IComparisonData d) {
        double sumOfWeights = 0.0;
        for (int i = 0; i < d.nPoints(); ++i) {
            sumOfWeights += d.weight(i);
        }
        return sumOfWeights;
    }

    public int entries(IComparisonData d) {
        int entries = 0;
        for (int i = 0; i < d.nPoints(); ++i) {
            entries += d.entries(i);
        }
        return entries;
    }
}

