/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IDataPoint;
import hep.aida.IFunction;
import hep.aida.IManagedObject;
import hep.aida.IMeasurement;
import hep.aida.IModelFunction;
import hep.aida.dev.IDevManagedObject;
import hep.aida.dev.IDevTree;
import hep.aida.ref.Annotation;
import hep.aida.ref.function.FunctionCatalog;
import hep.aida.ref.histogram.Cloud1D;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.Cloud3D;
import hep.aida.ref.histogram.DataPointSet;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.histogram.Histogram3D;
import hep.aida.ref.histogram.Profile1D;
import hep.aida.ref.histogram.Profile2D;
import hep.aida.ref.histogram.VariableAxis;
import hep.aida.ref.tree.Folder;
import hep.aida.ref.tree.Tree;
import hep.aida.ref.tuple.Tuple;
import hep.aida.ref.xml.AidaHandler;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AidaHandlerImpl
implements AidaHandler {
    public static final boolean DEBUG = false;
    private Cloud1D cloud1d;
    private Cloud2D cloud2d;
    private Cloud3D cloud3d;
    private DataPointSet dataPointSet;
    private IAnnotation annotation;
    private IAnnotation saveAnnotation;
    private IDataPoint dataPoint;
    private Stack stack = new Stack();
    private String aidaVersion;
    private String name;
    private String options;
    private String path;
    private String saveName;
    private String saveTitle;
    private String title;
    private Tree tree;
    private Tuple tuple;
    private IAxis[] axes = new IAxis[3];
    private double[] binBorders;
    private int[] entries1d;
    private int[][] entries2d;
    private int[][][] entries3d;
    private double[] errors1d;
    private double[][] errors2d;
    private double[][][] errors3d;
    private double[] heights1d;
    private double[][] heights2d;
    private double[][][] heights3d;
    private double[] mean = new double[3];
    private double[] means1d;
    private double[][] meansx2d;
    private double[][][] meansx3d;
    private double[][] meansy2d;
    private double[][][] meansy3d;
    private double[][][] meansz3d;
    private double[] rms = new double[3];
    private double[] rmss1d;
    private double[][] rmssx2d;
    private double[][][] rmssx3d;
    private double[][] rmssy2d;
    private double[][][] rmssy3d;
    private double[][][] rmssz3d;
    private boolean aida22;
    private boolean beforeAida33;
    private boolean hasBinMeanAndRms;
    private double binMax;
    private double binMin;
    private int column;
    private int nAxis;
    private int nBin;
    private int nBins;
    private int nextCoord;
    private IFunction function;
    private String argName;
    private boolean isNormalized;
    private String tupleString = "";
    private int innerFolders = 0;

    public AidaHandlerImpl(IDevTree tree) {
        this.tree = (Tree)tree;
    }

    public void end_aida() throws SAXException {
    }

    public void end_annotation() throws SAXException {
    }

    public void end_argument() throws SAXException {
    }

    public void end_arguments() throws SAXException {
        if (this.function instanceof IModelFunction) {
            IModelFunction model = (IModelFunction)this.function;
            model.normalize(this.isNormalized);
        }
    }

    public void end_axis() throws SAXException {
        this.axes[this.nAxis] = this.binBorders != null ? new VariableAxis(this.binBorders) : new FixedAxis(this.nBins, this.binMin, this.binMax);
    }

    public void end_cloud1d() throws SAXException {
        if (this.annotation != null) {
            this.cloud1d.setAnnotation(this.annotation);
            this.annotation = null;
        }
        this.cloud1d.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)this.cloud1d);
        this.cloud1d = null;
    }

    public void end_cloud2d() throws SAXException {
        if (this.annotation != null) {
            this.cloud2d.setAnnotation(this.annotation);
            this.annotation = null;
        }
        this.cloud2d.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)this.cloud2d);
        this.cloud2d = null;
    }

    public void end_cloud3d() throws SAXException {
        if (this.annotation != null) {
            this.cloud3d.setAnnotation(this.annotation);
            this.annotation = null;
        }
        this.cloud3d.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)this.cloud3d);
        this.cloud3d = null;
    }

    public void end_columns() throws SAXException {
        if (this.innerFolders != 0) {
            this.tupleString = this.tupleString + "}";
            --this.innerFolders;
        }
    }

    public void end_data1d() throws SAXException {
    }

    public void end_data2d() throws SAXException {
    }

    public void end_data3d() throws SAXException {
    }

    public void end_dataPoint() throws SAXException {
    }

    public void end_dataPointSet() throws SAXException {
        if (this.annotation != null) {
            this.dataPointSet.setAnnotation(this.annotation);
            this.annotation = null;
        }
        this.dataPointSet.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)this.dataPointSet);
        this.dataPointSet = null;
    }

    public void end_entries1d() throws SAXException {
    }

    public void end_entries2d() throws SAXException {
    }

    public void end_entries3d() throws SAXException {
    }

    public void end_entryITuple() throws SAXException {
        Object[] elements = (Object[])this.stack.pop();
        this.tuple = (Tuple)elements[0];
        this.column = (Integer)elements[1];
        ++this.column;
    }

    public void end_function() throws SAXException {
        ((IDevManagedObject)this.function).setName(this.name);
        this.add(this.path, (IManagedObject)this.function);
    }

    public void end_histogram1d() throws SAXException {
        Histogram1D hist = new Histogram1D();
        hist.setName(this.name);
        hist.initHistogram1D(this.axes[0], this.options);
        hist.setContents(this.heights1d, this.errors1d, this.entries1d, this.means1d, this.rmss1d);
        if (!this.hasBinMeanAndRms) {
            hist.setMean(this.mean[0]);
            hist.setRms(this.rms[0]);
        }
        if (this.annotation != null) {
            hist.setAnnotation(this.annotation);
            this.annotation = null;
        }
        hist.setTitle(this.title == null ? this.name : this.title);
        if (this.cloud1d != null) {
            this.cloud1d.setHistogram(hist);
            this.annotation = this.saveAnnotation;
            this.title = this.saveTitle;
            this.name = this.saveName;
        } else {
            this.add(this.path, (IManagedObject)hist);
        }
    }

    public void end_histogram2d() throws SAXException {
        Histogram2D hist = new Histogram2D();
        hist.setName(this.name);
        hist.initHistogram2D(this.axes[0], this.axes[1], this.options);
        hist.setContents(this.heights2d, this.errors2d, this.entries2d, this.meansx2d, this.rmssx2d, this.meansy2d, this.rmssy2d);
        if (!this.hasBinMeanAndRms) {
            hist.setMeanX(this.mean[0]);
            hist.setRmsX(this.rms[0]);
            hist.setMeanY(this.mean[1]);
            hist.setRmsY(this.rms[1]);
        }
        if (this.annotation != null) {
            hist.setAnnotation(this.annotation);
            this.annotation = null;
        }
        hist.setTitle(this.title == null ? this.name : this.title);
        if (this.cloud2d != null) {
            this.cloud2d.setHistogram(hist);
            this.annotation = this.saveAnnotation;
            this.title = this.saveTitle;
            this.name = this.saveName;
        } else {
            this.add(this.path, (IManagedObject)hist);
        }
    }

    public void end_histogram3d() throws SAXException {
        Histogram3D hist = new Histogram3D();
        hist.setName(this.name);
        hist.initHistogram3D(this.axes[0], this.axes[1], this.axes[2], this.options);
        hist.setContents(this.heights3d, this.errors3d, this.entries3d, this.meansx3d, this.rmssx3d, this.meansy3d, this.rmssy3d, this.meansz3d, this.rmssz3d);
        if (!this.hasBinMeanAndRms) {
            hist.setMeanX(this.mean[0]);
            hist.setRmsX(this.rms[0]);
            hist.setMeanY(this.mean[1]);
            hist.setRmsY(this.rms[1]);
            hist.setMeanZ(this.mean[2]);
            hist.setRmsZ(this.rms[2]);
        }
        if (this.annotation != null) {
            hist.setAnnotation(this.annotation);
            this.annotation = null;
        }
        hist.setTitle(this.title == null ? this.name : this.title);
        if (this.cloud3d != null) {
            this.cloud3d.setHistogram(hist);
            this.annotation = this.saveAnnotation;
            this.title = this.saveTitle;
            this.name = this.saveName;
        } else {
            this.add(this.path, (IManagedObject)hist);
        }
    }

    public void end_parameters() throws SAXException {
    }

    public void end_profile1d() throws SAXException {
        Profile1D hist = new Profile1D();
        hist.setName(this.name);
        hist.initProfile1D(this.axes[0]);
        hist.setContents(this.heights1d, this.errors1d, this.entries1d, this.rmss1d, this.means1d);
        hist.setMean(this.mean[0]);
        hist.setRms(this.rms[0]);
        if (this.annotation != null) {
            hist.setAnnotation(this.annotation);
            this.annotation = null;
        }
        hist.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)hist);
    }

    public void end_profile2d() throws SAXException {
        Profile2D hist = new Profile2D();
        hist.setName(this.name);
        hist.initProfile2D(this.axes[0], this.axes[1]);
        hist.setContents(this.heights2d, this.errors2d, this.entries2d, this.rmssx2d, this.meansx2d, this.meansy2d);
        hist.setMeanX(this.mean[0]);
        hist.setRmsX(this.rms[0]);
        hist.setMeanY(this.mean[1]);
        hist.setRmsY(this.rms[1]);
        if (this.annotation != null) {
            hist.setAnnotation(this.annotation);
            this.annotation = null;
        }
        hist.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)hist);
    }

    public void end_row() throws SAXException {
        this.tuple.addRow();
    }

    public void end_rows() throws SAXException {
    }

    public void end_statistics() throws SAXException {
    }

    public void end_tuple() throws SAXException {
        if (this.annotation != null) {
            this.tuple.setAnnotation(this.annotation);
            this.annotation = null;
        }
        this.tuple.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)this.tuple);
    }

    public void handle_bin1d(Attributes meta) throws SAXException {
        int bin = this.binStringToInt(meta.getValue("binNum"), this.axes[0].bins());
        this.errors1d[bin] = this.toDouble(meta, "error", Double.NaN);
        this.entries1d[bin] = this.toInt(meta, "entries");
        this.heights1d[bin] = this.toDouble(meta, "height", this.entries1d[bin]);
        if (this.hasBinMeanAndRms) {
            int index1 = meta.getIndex("weightedMean");
            int index2 = meta.getIndex("weightedRms");
            if (index2 < 0) {
                index2 = meta.getIndex("rms");
            }
            if (index1 < 0 || index2 < 0) {
                this.hasBinMeanAndRms = false;
            } else {
                this.means1d[bin] = this.toDouble(meta, index1);
                this.rmss1d[bin] = this.toDouble(meta, index2);
            }
        }
    }

    public void handle_bin2d(Attributes meta) throws SAXException {
        int xBin = this.binStringToInt(meta.getValue("binNumX"), this.axes[0].bins());
        int yBin = this.binStringToInt(meta.getValue("binNumY"), this.axes[1].bins());
        this.errors2d[xBin][yBin] = this.toDouble(meta, "error", Double.NaN);
        this.entries2d[xBin][yBin] = this.toInt(meta, "entries");
        this.heights2d[xBin][yBin] = this.toDouble(meta, "height", this.entries2d[xBin][yBin]);
        if (this.hasBinMeanAndRms) {
            int index1 = meta.getIndex("weightedMeanX");
            int index2 = meta.getIndex("weightedRmsX");
            if (index2 < 0) {
                index2 = meta.getIndex("rms");
            }
            int index3 = meta.getIndex("weightedMeanY");
            int index4 = meta.getIndex("weightedRmsY");
            if (index1 < 0 || index2 < 0 || index3 < 0) {
                this.hasBinMeanAndRms = false;
            } else {
                this.meansx2d[xBin][yBin] = this.toDouble(meta, index1);
                this.rmssx2d[xBin][yBin] = this.toDouble(meta, index2);
                this.meansy2d[xBin][yBin] = this.toDouble(meta, index3);
                if (index4 >= 0) {
                    this.rmssy2d[xBin][yBin] = this.toDouble(meta, index4);
                }
            }
        }
    }

    public void handle_bin3d(Attributes meta) throws SAXException {
        int xBin = this.binStringToInt(meta.getValue("binNumX"), this.axes[0].bins());
        int yBin = this.binStringToInt(meta.getValue("binNumY"), this.axes[1].bins());
        int zBin = this.binStringToInt(meta.getValue("binNumZ"), this.axes[2].bins());
        this.errors3d[xBin][yBin][zBin] = this.toDouble(meta, "error", Double.NaN);
        this.entries3d[xBin][yBin][zBin] = this.toInt(meta, "entries");
        this.heights3d[xBin][yBin][zBin] = this.toDouble(meta, "height", this.entries3d[xBin][yBin][zBin]);
        if (this.hasBinMeanAndRms) {
            int index1 = meta.getIndex("weightedMeanX");
            int index2 = meta.getIndex("weightedRmsX");
            int index3 = meta.getIndex("weightedMeanY");
            int index4 = meta.getIndex("weightedRmsY");
            int index5 = meta.getIndex("weightedMeanZ");
            int index6 = meta.getIndex("weightedRmsZ");
            if (index1 < 0 || index2 < 0 || index3 < 0 || index4 < 0 || index5 < 0 || index6 < 0) {
                this.hasBinMeanAndRms = false;
            } else {
                this.meansx3d[xBin][yBin][zBin] = this.toDouble(meta, index1);
                this.rmssx3d[xBin][yBin][zBin] = this.toDouble(meta, index2);
                this.meansy3d[xBin][yBin][zBin] = this.toDouble(meta, index3);
                this.rmssy3d[xBin][yBin][zBin] = this.toDouble(meta, index4);
                this.meansz3d[xBin][yBin][zBin] = this.toDouble(meta, index5);
                this.rmssz3d[xBin][yBin][zBin] = this.toDouble(meta, index6);
            }
        }
    }

    public void handle_binBorder(Attributes meta) throws SAXException {
        if (this.binBorders == null) {
            this.binBorders = new double[this.nBins + 1];
            this.binBorders[0] = this.binMin;
            this.binBorders[this.nBins] = this.binMax;
            this.nBin = 1;
        }
        this.binBorders[this.nBin++] = this.toDouble(meta, "value");
    }

    public void handle_codelet(String data, Attributes meta) throws SAXException {
        String codelet = data;
        if (codelet.startsWith("\n")) {
            codelet = codelet.substring(1);
        }
        if (codelet.endsWith("\n")) {
            codelet = codelet.substring(0, codelet.length() - 1);
        }
        codelet = codelet.trim();
        this.function = FunctionCatalog.getFunctionCatalog().getFunctionCreator().createFromCodelet(codelet);
        if (this.title != null) {
            this.function.setTitle(this.title);
        }
    }

    public void handle_column(Attributes meta) throws SAXException {
        String type = meta.getValue("type");
        if (!(this.tupleString.equals("") || this.tupleString.endsWith(",") || this.tupleString.endsWith("{"))) {
            this.tupleString = this.tupleString + ",";
        }
        this.tupleString = this.tupleString + type + " " + meta.getValue("name");
        if (!this.beforeAida33 && type.equalsIgnoreCase("ITuple")) {
            this.tupleString = this.tupleString + "={";
            ++this.innerFolders;
        }
    }

    public void handle_entry(Attributes meta) throws SAXException {
        Class colType = this.tuple.columnType(this.column);
        String value = meta.getValue("value");
        if (colType == Integer.TYPE) {
            this.tuple.fill(this.column, Integer.parseInt(value));
        } else if (colType == Short.TYPE) {
            this.tuple.fill(this.column, Short.parseShort(value));
        } else if (colType == Long.TYPE) {
            this.tuple.fill(this.column, Long.parseLong(value));
        } else if (colType == Float.TYPE) {
            this.tuple.fill(this.column, Float.parseFloat(value));
        } else if (colType == Double.TYPE) {
            this.tuple.fill(this.column, this.parseDouble(value));
        } else if (colType == Boolean.TYPE) {
            this.tuple.fill(this.column, "true".equalsIgnoreCase(value));
        } else if (colType == Byte.TYPE) {
            this.tuple.fill(this.column, Byte.parseByte(value));
        } else if (colType == Character.TYPE) {
            this.tuple.fill(this.column, value.charAt(0));
        } else if (colType == String.class) {
            this.tuple.fill(this.column, value);
        } else {
            this.tuple.fill(this.column, value);
        }
        ++this.column;
    }

    public void handle_entry1d(Attributes meta) throws SAXException {
        double value = this.toDouble(meta, "valueX");
        double weight = this.toDouble(meta, "weight", 1.0);
        this.cloud1d.fill(value, weight);
    }

    public void handle_entry2d(Attributes meta) throws SAXException {
        double x = this.toDouble(meta, "valueX");
        double y = this.toDouble(meta, "valueY");
        double weight = this.toDouble(meta, "weight", 1.0);
        this.cloud2d.fill(x, y, weight);
    }

    public void handle_entry3d(Attributes meta) throws SAXException {
        double x = this.toDouble(meta, "valueX");
        double y = this.toDouble(meta, "valueY");
        double z = this.toDouble(meta, "valueZ");
        double weight = this.toDouble(meta, "weight", 1.0);
        this.cloud3d.fill(x, y, z, weight);
    }

    public void handle_implementation(Attributes meta) throws SAXException {
    }

    public void handle_item(Attributes meta) throws SAXException {
        String key = meta.getValue("key");
        String val = meta.getValue("value");
        boolean sticky = "true".equalsIgnoreCase(meta.getValue("sticky"));
        this.annotation.addItem(key, val, sticky);
    }

    public void handle_measurement(Attributes meta) throws SAXException {
        IMeasurement m = this.dataPoint.coordinate(this.nextCoord++);
        m.setValue(this.toDouble(meta, "value"));
        int index = meta.getIndex("errorPlus");
        if (index >= 0) {
            m.setErrorPlus(this.toDouble(meta, index));
        }
        if ((index = meta.getIndex("errorMinus")) >= 0) {
            m.setErrorMinus(this.toDouble(meta, index));
        }
    }

    public void handle_parameter(Attributes meta) throws SAXException {
        String parName = meta.getValue("name");
        this.function.setParameter(parName, this.toDouble(meta, "value"));
    }

    public void handle_range(Attributes meta) throws SAXException {
        if (this.function instanceof IModelFunction) {
            IModelFunction model = (IModelFunction)this.function;
            int argIndex = -1;
            for (int i = 0; i < model.dimension(); ++i) {
                if (!model.variableName(i).equals(this.argName)) continue;
                argIndex = i;
                break;
            }
            double min = this.toDouble(meta, "min");
            double max = this.toDouble(meta, "max");
            model.normalizationRange(argIndex).include(min, max);
        }
    }

    public void handle_statistic(Attributes meta) throws SAXException {
        int dir = this.toDirection(meta, "direction");
        this.mean[dir] = this.toDouble(meta, "mean");
        this.rms[dir] = this.toDouble(meta, "rms");
    }

    public void start_aida(Attributes meta) throws SAXException {
        this.aidaVersion = meta.getValue("version");
        this.aida22 = this.aidaVersion.startsWith("2.2");
        StringTokenizer st = new StringTokenizer(this.aidaVersion, ".");
        int nTokens = st.countTokens();
        if (nTokens > 3) {
            throw new RuntimeException("Illegal version for parsing.");
        }
        int majorVersion = Integer.parseInt(st.nextToken());
        int revisionVersion = Integer.parseInt(st.nextToken());
        boolean patchVersion = false;
        if (nTokens == 3) {
            Integer.parseInt(st.nextToken());
        }
        this.beforeAida33 = majorVersion < 3 || majorVersion == 3 && revisionVersion <= 2;
    }

    public void start_annotation(Attributes meta) throws SAXException {
        this.annotation = new Annotation();
    }

    public void start_argument(Attributes meta) throws SAXException {
        this.argName = meta.getValue("name");
    }

    public void start_arguments(Attributes meta) throws SAXException {
    }

    public void start_axis(Attributes meta) throws SAXException {
        this.binMin = this.toDouble(meta, "min");
        this.binMax = this.toDouble(meta, "max");
        this.nBins = this.toInt(meta, "numberOfBins");
        this.nAxis = this.toDirection(meta, "direction");
        this.binBorders = null;
    }

    public void start_cloud1d(Attributes meta) throws SAXException {
        String conversionBinsStr;
        this.start_managedObject(meta);
        this.cloud1d = new Cloud1D();
        this.cloud1d.initCloud(this.toInt(meta, "maxEntries"), this.options);
        this.cloud1d.setName(this.name);
        double uE = this.toDouble(meta, "upperEdgeX", Double.NaN);
        double lE = this.toDouble(meta, "lowerEdgeX", Double.NaN);
        if (!Double.isNaN(uE)) {
            this.cloud1d.setUpperEdge(uE);
        }
        if (!Double.isNaN(lE)) {
            this.cloud1d.setLowerEdge(lE);
        }
        if ((conversionBinsStr = meta.getValue("conversionBins")) != null) {
            int conversionBins = Integer.parseInt(conversionBinsStr);
            double le = this.toDouble(meta, "conversionLowerEdge", Double.NaN);
            double ue = this.toDouble(meta, "conversionUpperEdge", Double.NaN);
            this.cloud1d.setConversionParameters(conversionBins, le, ue);
        }
    }

    public void start_cloud2d(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
        this.cloud2d = new Cloud2D();
        this.cloud2d.initCloud(this.toInt(meta, "maxEntries"), this.options);
        this.cloud2d.setName(this.name);
        double uE = this.toDouble(meta, "upperEdgeX", Double.NaN);
        double lE = this.toDouble(meta, "lowerEdgeX", Double.NaN);
        if (!Double.isNaN(uE)) {
            this.cloud2d.setUpperEdgeX(uE);
        }
        if (!Double.isNaN(lE)) {
            this.cloud2d.setLowerEdgeX(lE);
        }
        uE = this.toDouble(meta, "upperEdgeY", Double.NaN);
        lE = this.toDouble(meta, "lowerEdgeY", Double.NaN);
        if (!Double.isNaN(uE)) {
            this.cloud2d.setUpperEdgeY(uE);
        }
        if (!Double.isNaN(lE)) {
            this.cloud2d.setLowerEdgeY(lE);
        }
        String conversionBinsXStr = meta.getValue("conversionBinsX");
        String conversionBinsYStr = meta.getValue("conversionBinsY");
        if (conversionBinsXStr != null && conversionBinsYStr != null) {
            int conversionBinsX = Integer.parseInt(conversionBinsXStr);
            int conversionBinsY = Integer.parseInt(conversionBinsYStr);
            double lex = this.toDouble(meta, "conversionLowerEdgeX", Double.NaN);
            double uex = this.toDouble(meta, "conversionUpperEdgeX", Double.NaN);
            double ley = this.toDouble(meta, "conversionLowerEdgeY", Double.NaN);
            double uey = this.toDouble(meta, "conversionUpperEdgeY", Double.NaN);
            this.cloud2d.setConversionParameters(conversionBinsX, lex, uex, conversionBinsY, ley, uey);
        }
    }

    public void start_cloud3d(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
        this.cloud3d = new Cloud3D();
        this.cloud3d.initCloud(this.toInt(meta, "maxEntries"), this.options);
        this.cloud3d.setName(this.name);
        double uE = this.toDouble(meta, "upperEdgeX", Double.NaN);
        double lE = this.toDouble(meta, "lowerEdgeX", Double.NaN);
        if (!Double.isNaN(uE)) {
            this.cloud3d.setUpperEdgeX(uE);
        }
        if (!Double.isNaN(lE)) {
            this.cloud3d.setLowerEdgeX(lE);
        }
        uE = this.toDouble(meta, "upperEdgeY", Double.NaN);
        lE = this.toDouble(meta, "lowerEdgeY", Double.NaN);
        if (!Double.isNaN(uE)) {
            this.cloud3d.setUpperEdgeY(uE);
        }
        if (!Double.isNaN(lE)) {
            this.cloud3d.setLowerEdgeY(lE);
        }
        uE = this.toDouble(meta, "upperEdgeZ", Double.NaN);
        lE = this.toDouble(meta, "lowerEdgeZ", Double.NaN);
        if (!Double.isNaN(uE)) {
            this.cloud3d.setUpperEdgeZ(uE);
        }
        if (!Double.isNaN(lE)) {
            this.cloud3d.setLowerEdgeZ(lE);
        }
        String conversionBinsXStr = meta.getValue("conversionBinsX");
        String conversionBinsYStr = meta.getValue("conversionBinsY");
        String conversionBinsZStr = meta.getValue("conversionBinsZ");
        if (conversionBinsXStr != null && conversionBinsYStr != null && conversionBinsZStr != null) {
            int conversionBinsX = Integer.parseInt(conversionBinsXStr);
            int conversionBinsY = Integer.parseInt(conversionBinsYStr);
            int conversionBinsZ = Integer.parseInt(conversionBinsZStr);
            double lex = this.toDouble(meta, "conversionLowerEdgeX", Double.NaN);
            double uex = this.toDouble(meta, "conversionUpperEdgeX", Double.NaN);
            double ley = this.toDouble(meta, "conversionLowerEdgeY", Double.NaN);
            double uey = this.toDouble(meta, "conversionUpperEdgeY", Double.NaN);
            double lez = this.toDouble(meta, "conversionLowerEdgeZ", Double.NaN);
            double uez = this.toDouble(meta, "conversionUpperEdgeZ", Double.NaN);
            this.cloud3d.setConversionParameters(conversionBinsX, lex, uex, conversionBinsY, ley, uey, conversionBinsZ, lez, uez);
        }
    }

    public void start_columns(Attributes meta) throws SAXException {
    }

    public void start_data1d(Attributes meta) throws SAXException {
        int xBins = this.axes[0].bins() + 2;
        this.heights1d = new double[xBins];
        this.errors1d = new double[xBins];
        this.entries1d = new int[xBins];
        this.means1d = new double[xBins];
        this.rmss1d = new double[xBins];
        this.hasBinMeanAndRms = true;
    }

    public void start_data2d(Attributes meta) throws SAXException {
        int xBins = this.axes[0].bins() + 2;
        int yBins = this.axes[1].bins() + 2;
        this.heights2d = new double[xBins][yBins];
        this.errors2d = new double[xBins][yBins];
        this.entries2d = new int[xBins][yBins];
        this.meansx2d = new double[xBins][yBins];
        this.rmssx2d = new double[xBins][yBins];
        this.meansy2d = new double[xBins][yBins];
        this.rmssy2d = new double[xBins][yBins];
        this.hasBinMeanAndRms = true;
    }

    public void start_data3d(Attributes meta) throws SAXException {
        int xBins = this.axes[0].bins() + 2;
        int yBins = this.axes[1].bins() + 2;
        int zBins = this.axes[2].bins() + 2;
        this.heights3d = new double[xBins][yBins][zBins];
        this.errors3d = new double[xBins][yBins][zBins];
        this.entries3d = new int[xBins][yBins][zBins];
        this.meansx3d = new double[xBins][yBins][zBins];
        this.rmssx3d = new double[xBins][yBins][zBins];
        this.meansy3d = new double[xBins][yBins][zBins];
        this.rmssy3d = new double[xBins][yBins][zBins];
        this.meansz3d = new double[xBins][yBins][zBins];
        this.rmssz3d = new double[xBins][yBins][zBins];
        this.hasBinMeanAndRms = true;
    }

    public void start_dataPoint(Attributes meta) throws SAXException {
        this.dataPointSet.addPoint();
        this.dataPoint = this.dataPointSet.point(this.dataPointSet.size() - 1);
        this.nextCoord = 0;
    }

    public void start_dataPointSet(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
        int dim = this.toInt(meta, "dimension");
        this.dataPointSet = new DataPointSet(this.name, this.title, dim);
    }

    public void start_entries1d(Attributes meta) throws SAXException {
    }

    public void start_entries2d(Attributes meta) throws SAXException {
    }

    public void start_entries3d(Attributes meta) throws SAXException {
    }

    public void start_entryITuple(Attributes meta) throws SAXException {
        this.stack.push(new Object[]{this.tuple, new Integer(this.column)});
        this.tuple = (Tuple)this.tuple.getObject(this.column);
        this.column = 0;
    }

    public void start_function(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
        this.isNormalized = this.toBoolean(meta, "isNormalized");
    }

    public void start_histogram1d(Attributes meta) throws SAXException {
        if (this.cloud1d != null) {
            this.saveAnnotation = this.annotation;
            this.saveTitle = this.title;
            this.saveName = this.name;
        }
        this.start_managedObject(meta);
    }

    public void start_histogram2d(Attributes meta) throws SAXException {
        if (this.cloud2d != null) {
            this.saveAnnotation = this.annotation;
            this.saveTitle = this.title;
            this.saveName = this.name;
        }
        this.start_managedObject(meta);
    }

    public void start_histogram3d(Attributes meta) throws SAXException {
        if (this.cloud3d != null) {
            this.saveAnnotation = this.annotation;
            this.saveTitle = this.title;
            this.saveName = this.name;
        }
        this.start_managedObject(meta);
    }

    public void start_parameters(Attributes meta) throws SAXException {
    }

    public void start_profile1d(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
    }

    public void start_profile2d(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
    }

    public void start_row(Attributes meta) throws SAXException {
        this.column = 0;
    }

    public void start_rows(Attributes meta) throws SAXException {
        if (this.tupleString.endsWith(",")) {
            this.tupleString = this.tupleString.substring(0, this.tupleString.length() - 1);
        }
        this.tuple = new Tuple(this.name, this.title, this.tupleString, this.options);
    }

    public void start_statistics(Attributes meta) throws SAXException {
    }

    public void start_tuple(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
        this.tupleString = "";
    }

    private void add(String path, IManagedObject obj) {
        if (path == null) {
            path = "/";
            this.tree.hasBeenFilled("/");
        } else {
            this.tree.mkdirs(path);
            StringTokenizer st = new StringTokenizer(path, "/");
            String currentpath = "/";
            if (st.countTokens() > 0) {
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    currentpath = currentpath + token + "/";
                    this.tree.hasBeenFilled(currentpath);
                    if (!(obj instanceof Folder)) continue;
                    this.tree.hasBeenFilled(currentpath + obj.name());
                }
            }
        }
        this.tree.add(path, obj);
    }

    private int binStringToInt(String bin, int nBins) {
        if (bin.equals("UNDERFLOW")) {
            return 0;
        }
        if (bin.equals("OVERFLOW")) {
            return nBins + 1;
        }
        return Integer.parseInt(bin) + 1;
    }

    private void start_managedObject(Attributes meta) throws SAXException {
        this.name = meta.getValue("name");
        this.title = meta.getValue(this.aida22 ? "label" : "title");
        this.path = meta.getValue("path");
        this.options = meta.getValue("options");
    }

    private int toDirection(Attributes meta, String name) throws SAXException {
        String dir = meta.getValue(name);
        if (dir == null || dir.equalsIgnoreCase("x")) {
            return 0;
        }
        if (dir.equalsIgnoreCase("y")) {
            return 1;
        }
        if (dir.equalsIgnoreCase("z")) {
            return 2;
        }
        throw new SAXException("Illegal value for direction: " + dir);
    }

    private double toDouble(Attributes meta, String name) {
        return this.parseDouble(meta.getValue(name));
    }

    private double toDouble(Attributes meta, int index) {
        return this.parseDouble(meta.getValue(index));
    }

    private double toDouble(Attributes meta, String name, double def) {
        String val = meta.getValue(name);
        if (val == null) {
            return def;
        }
        return this.parseDouble(val);
    }

    private double parseDouble(String strDouble) {
        if (strDouble.equalsIgnoreCase("nan")) {
            strDouble = "NaN";
        }
        return Double.parseDouble(strDouble);
    }

    private int toInt(Attributes meta, String name) {
        return Integer.parseInt(meta.getValue(name));
    }

    private boolean toBoolean(Attributes meta, String name) {
        return Boolean.valueOf(meta.getValue(name));
    }
}

