/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.editor;

import com.l2fprod.common.propertysheet.DefaultProperty;
import hep.aida.IBaseStyle;
import hep.aida.ref.plotter.BaseStyle;
import java.awt.Color;
import java.awt.Font;
import java.util.logging.Logger;
import org.freehep.swing.ColorConverter;

public class StyleProperty
extends DefaultProperty {
    private BaseStyle style;
    private Logger styleLogger;

    StyleProperty(IBaseStyle style, String parameterName) {
        this.style = (BaseStyle)style;
        this.styleLogger = Logger.getLogger("hep.aida.ref.plotter.style.editor");
        this.init(parameterName);
    }

    void init(String parameterName) {
        this.setName(parameterName);
        this.setEditable(true);
        this.readFromObject(this.style);
    }

    public String[] getAvailableValues() {
        return this.style.availableParameterOptions(this.getName());
    }

    public void readFromObject(Object object) {
        String parameterName = this.getName();
        this.setDisplayName(parameterName);
        Class t = this.style.parameter(parameterName).type();
        String value = this.style.parameterValue(parameterName);
        String[] options = this.style.availableParameterOptions(parameterName);
        if (options != null && options.length > 0) {
            this.setCategory("preset");
        }
        Object objValue = null;
        this.styleLogger.fine("StyleProperty.readFromObject: Style=" + this.style.name() + ", parameter=" + parameterName + ", value=" + value + ", type=" + t);
        this.setType(t);
        if (t == Boolean.TYPE) {
            objValue = Boolean.valueOf(value);
            this.setCategory("boolean");
        } else if (t == Color.class) {
            this.setCategory("color");
            try {
                if (value != null && value.length() > 0) {
                    objValue = ColorConverter.get((String)value);
                }
                this.setCategory("color");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (t == Double.TYPE) {
            if (options != null && options.length > 0) {
                this.setType(String.class);
                objValue = value;
            } else {
                if (value != null && value.length() > 0) {
                    objValue = Double.valueOf(value);
                }
                this.setCategory("double");
            }
        } else if (t == Font.class) {
            if (options != null && options.length > 0) {
                this.setType(String.class);
                this.setCategory("preset");
                objValue = value;
            } else {
                if (value != null && value.length() > 0) {
                    objValue = Font.getFont(value);
                }
                this.setCategory("font");
            }
        } else if (t == Integer.TYPE) {
            if (options != null && options.length > 0) {
                this.setType(String.class);
                objValue = value;
            } else {
                if (value != null && value.length() > 0) {
                    objValue = Integer.valueOf(value);
                }
                this.setCategory("integer");
            }
        } else if (t == String.class) {
            objValue = value;
            if (options == null || options.length == 0) {
                this.setCategory("string");
            }
        } else {
            throw new RuntimeException("**** Unknown type of parameter: name=" + parameterName + ", type=" + t);
        }
        this.setValue(objValue);
    }

    public void writeToObject(Object object) {
        String parameterName = this.getName();
        Class t = this.getType();
        Object objValue = this.getValue();
        String objString = objValue == null ? "null" : objValue.getClass().getName();
        String value = null;
        if (objValue == null) {
            value = null;
        } else if (objValue instanceof Boolean) {
            value = objValue.toString();
        } else if (objValue instanceof Color) {
            value = ColorConverter.get((Color)((Color)objValue));
        } else if (objValue instanceof Double) {
            value = objValue.toString();
        } else if (objValue instanceof Integer) {
            value = objValue.toString();
        } else if (objValue instanceof String) {
            value = (String)objValue;
        } else {
            throw new RuntimeException("Unknown return type of parameter: name=" + parameterName + ", type=" + objValue);
        }
        String oldValue = this.style.parameterValue(parameterName);
        this.styleLogger.fine("StyleProperty.writeToObject: Style=" + this.style.name() + ", parameter=" + parameterName + ", newValue=" + value + ", oldValue=" + oldValue);
        this.style.setParameter(parameterName, value);
    }
}

