/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.editor;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import hep.aida.IAnalysisFactory;
import hep.aida.IHistogram1D;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.style.editor.ConfigurePreviewPanel;
import hep.aida.ref.plotter.style.editor.StylePreviewCreator;
import hep.aida.ref.plotter.style.editor.StyleTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class StyleEditorPanel
extends JSplitPane
implements TreeSelectionListener,
PropertyChangeListener {
    private IPlotterStyle style;
    private JComboBox previewTypeBox;
    private Class previewType = IHistogram1D.class;
    private JTree styleTree;
    private DefaultTreeModel styleModel;
    private StylePreviewCreator stylePreviewCreator;
    private JSplitPane rightPanel;
    private boolean previewFitRegion = true;
    private PropertySheetPanel currentStylePanel;

    public StyleEditorPanel(IPlotterStyle style) {
        this(style, null, StylePreviewCreator.getPossiblePreviewTypes()[0]);
    }

    public StyleEditorPanel(IPlotterStyle style, Class previewType) {
        this(style, null, previewType);
    }

    public StyleEditorPanel(IPlotterStyle style, ConfigurePreviewPanel configurePanel) {
        this(style, configurePanel, StylePreviewCreator.getPossiblePreviewTypes()[0]);
    }

    public StyleEditorPanel(IPlotterStyle style, ConfigurePreviewPanel configurePanel, Class previewType) {
        super(1);
        this.init(style, configurePanel, previewType);
    }

    public IPlotterStyle getStyle() {
        return this.style;
    }

    public void setCurrentPreviewPanelDimension(Dimension d) {
        this.previewFitRegion = d.width < 0 && d.height < 0;
        this.stylePreviewCreator.setPreviewPanelDimension(d);
        this.updatePreview();
    }

    public Dimension getCurrentPreviewPanelDimension() {
        return ((JComponent)this.rightPanel.getBottomComponent()).getComponent(1).getSize();
    }

    public void setupEditorPanel(ConfigurePreviewPanel configurePanel) {
        this.stylePreviewCreator.setupPreviewCreator(configurePanel);
        Dimension d = null;
        if (configurePanel == null || configurePanel.previewFitRegion) {
            d = new Dimension(-1, -1);
            this.previewFitRegion = true;
        } else {
            d = new Dimension(configurePanel.previewWidth, configurePanel.previewHeight);
            this.previewFitRegion = false;
        }
        this.setCurrentPreviewPanelDimension(d);
    }

    public void clear() {
        if (this.styleTree != null) {
            this.styleTree.removeTreeSelectionListener(this);
        }
    }

    public void setPreviewType(Class previewType) {
        this.previewTypeBox.setSelectedItem(previewType.getName());
    }

    void executeSetPreviewType(Class previewType) {
        this.previewType = previewType;
        this.updatePreview();
    }

    public Class getPreviewType() {
        return this.previewType;
    }

    public void updatePreview() {
        JComponent bp = (JComponent)this.rightPanel.getBottomComponent();
        try {
            bp.getComponent(1);
            bp.remove(1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        JComponent newComponent = this.stylePreviewCreator.getPreviewPanel(this.style, this.previewType);
        if (this.previewFitRegion) {
            Dimension d = null;
            newComponent.setMaximumSize(d);
            newComponent.setPreferredSize(d);
            newComponent.setMinimumSize(d);
        }
        bp.add((Component)newComponent, "Center");
    }

    private void init(IPlotterStyle ps, ConfigurePreviewPanel configurePanel, Class previewType) {
        this.style = ps;
        this.previewType = previewType;
        this.rightPanel = new JSplitPane(0);
        this.createStyleTree(ps);
        this.setRightComponent(this.rightPanel);
        this.setDividerLocation(200);
        this.rightPanel.setDividerLocation(250);
        JPanel bp = new JPanel();
        bp.setLayout(new BoxLayout(bp, 1));
        Class[] possibleTypes = StylePreviewCreator.getPossiblePreviewTypes();
        String[] possibleTypesString = new String[possibleTypes.length];
        for (int i = 0; i < possibleTypes.length; ++i) {
            possibleTypesString[i] = possibleTypes[i].getName();
        }
        this.previewTypeBox = new JComboBox<String>(possibleTypesString);
        this.previewTypeBox.setSelectedItem(previewType.getName());
        this.previewTypeBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    try {
                        Class<?> pt = Class.forName((String)evt.getItem());
                        StyleEditorPanel.this.executeSetPreviewType(pt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        JPanel toolsPanel = new JPanel(new FlowLayout(0));
        toolsPanel.add(new JLabel("Preview Type: "));
        toolsPanel.add(this.previewTypeBox);
        bp.add(toolsPanel);
        this.rightPanel.setBottomComponent(bp);
        this.stylePreviewCreator = new StylePreviewCreator(configurePanel);
        this.previewFitRegion = configurePanel.previewFitRegion;
        this.styleTree.expandRow(0);
        this.styleTree.setSelectionRow(0);
        this.updatePreview();
    }

    private void createStyleTree(IPlotterStyle plotterStyle) {
        StyleTreeNode rootNode = new StyleTreeNode(plotterStyle, false);
        TreePath rootPath = new TreePath(rootNode);
        this.styleModel = new DefaultTreeModel(rootNode);
        this.styleTree = new JTree(this.styleModel);
        this.styleTree.addTreeSelectionListener(this);
        this.setLeftComponent(new JScrollPane(this.styleTree));
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object obj = e.getNewLeadSelectionPath().getLastPathComponent();
        if (obj instanceof StyleTreeNode) {
            StyleTreeNode node = (StyleTreeNode)obj;
            JComponent panel = node.getStylePanel();
            int rdl = this.rightPanel.getDividerLocation();
            if (this.currentStylePanel != null) {
                this.currentStylePanel.removePropertySheetChangeListener((PropertyChangeListener)this);
            }
            this.rightPanel.setTopComponent(panel);
            this.rightPanel.setDividerLocation(rdl);
            if (panel instanceof PropertySheetPanel) {
                this.currentStylePanel = (PropertySheetPanel)panel;
                this.currentStylePanel.addPropertySheetChangeListener((PropertyChangeListener)this);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Property prop = (Property)evt.getSource();
        this.updatePreview();
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("PropertySheet");
        frame.getContentPane().setLayout(new BorderLayout());
        IPlotterStyle style = IAnalysisFactory.create().createPlotterFactory().createPlotterStyle();
        StyleEditorPanel sePanel = new StyleEditorPanel(style, IHistogram1D.class);
        frame.getContentPane().add("Center", sePanel);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setSize(600, 500);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }
}

