/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.ICloud;
import hep.aida.ICloud2D;
import hep.aida.IHistogram2D;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.HistUtils;
import hep.aida.ref.plotter.adapter.AIDACloudAdapter;
import hep.aida.ref.plotter.adapter.AIDACloudStatistics2D;
import jas.hist.HasScatterPlotData;
import jas.hist.HasStatistics;
import jas.hist.HasStyle;
import jas.hist.JASHistScatterPlotStyle;
import jas.hist.JASHistStyle;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.ScatterEnumeration;
import jas.hist.Statistics;

public class AIDACloudAdapter2D
extends AIDACloudAdapter
implements Rebinnable2DHistogramData,
HasScatterPlotData,
HasStatistics,
HasStyle {
    private JASHistScatterPlotStyle style;
    private ICloud2D cloud;
    private int xBins;
    private int yBins;

    public AIDACloudAdapter2D(ICloud2D cloud) {
        super((ICloud)cloud);
        this.cloud = cloud;
        this.xBins = 50;
        this.yBins = 50;
        String tmp = null;
        try {
            tmp = cloud.annotation().value("xAxisType");
            if (tmp != null && tmp.equalsIgnoreCase("date")) {
                this.xAxisType = 3;
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            tmp = cloud.annotation().value("yAxisType");
            if (tmp != null && tmp.equalsIgnoreCase("date")) {
                this.xAxisType = 3;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.style = new JASHistScatterPlotStyle();
    }

    public double[][][] rebin(int xbins, double xmin, double xmax, int ybins, double ymin, double ymax, boolean wantErrors, boolean hurry, boolean overflow) {
        this.setValid();
        IHistogram2D histo = this.isRebinnable() ? HistUtils.toShowableHistogram(this.cloud, xbins, xmin, xmax, ybins, ymin, ymax) : this.cloud.histogram();
        double[][][] data = new double[2][histo.xAxis().bins()][histo.yAxis().bins()];
        for (int i = 0; i < histo.xAxis().bins(); ++i) {
            for (int j = 0; j < histo.yAxis().bins(); ++j) {
                data[0][i][j] = histo.binHeight(i, j);
                if (Double.isInfinite(data[0][i][j])) {
                    data[0][i][j] = Double.NaN;
                }
                data[1][i][j] = histo.binError(i, j);
            }
        }
        return data;
    }

    public double getXMin() {
        if (this.isRebinnable()) {
            if (this.cloud instanceof Cloud2D) {
                return ((Cloud2D)this.cloud).lowerEdgeXWithMargin();
            }
            return this.cloud.lowerEdgeX();
        }
        return this.cloud.histogram().xAxis().lowerEdge();
    }

    public double getXMax() {
        if (this.isRebinnable()) {
            if (this.cloud instanceof Cloud2D) {
                return ((Cloud2D)this.cloud).upperEdgeXWithMargin();
            }
            return this.cloud.upperEdgeX();
        }
        return this.cloud.histogram().xAxis().upperEdge();
    }

    public double getYMin() {
        if (this.isRebinnable()) {
            if (this.cloud instanceof Cloud2D) {
                return ((Cloud2D)this.cloud).lowerEdgeYWithMargin();
            }
            return this.cloud.lowerEdgeY();
        }
        return this.cloud.histogram().yAxis().lowerEdge();
    }

    public double getYMax() {
        if (this.isRebinnable()) {
            if (this.cloud instanceof Cloud2D) {
                return ((Cloud2D)this.cloud).upperEdgeYWithMargin();
            }
            return this.cloud.upperEdgeY();
        }
        return this.cloud.histogram().yAxis().upperEdge();
    }

    public int getXBins() {
        return this.isRebinnable() ? this.xBins : this.cloud.histogram().xAxis().bins();
    }

    public int getYBins() {
        return this.isRebinnable() ? this.yBins : this.cloud.histogram().yAxis().bins();
    }

    public boolean isRebinnable() {
        return !this.cloud.isConverted();
    }

    public int getXAxisType() {
        return this.xAxisType;
    }

    public int getYAxisType() {
        return this.yAxisType;
    }

    public void setXAxisType(int type) {
        this.xAxisType = type;
    }

    public void setYAxisType(int type) {
        this.yAxisType = type;
    }

    public String[] getXAxisLabels() {
        return null;
    }

    public String[] getYAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.cloud.title();
    }

    public Statistics getStatistics() {
        return new AIDACloudStatistics2D(this.cloud);
    }

    public boolean hasScatterPlotData() {
        return this.isRebinnable();
    }

    public ScatterEnumeration startEnumeration() {
        this.setValid();
        return new CloudEnumeration();
    }

    public ScatterEnumeration startEnumeration(double xMin, double xMax, double yMin, double yMax) {
        this.setValid();
        return new CloudEnumeration();
    }

    public JASHistStyle getStyle() {
        this.style.setDisplayAsScatterPlot(this.isRebinnable());
        return this.style;
    }

    private class CloudEnumeration
    implements ScatterEnumeration {
        private int index = 0;

        private CloudEnumeration() {
        }

        public boolean getNextPoint(double[] values) {
            if (this.index < AIDACloudAdapter2D.this.cloud.entries()) {
                try {
                    values[0] = AIDACloudAdapter2D.this.cloud.valueX(this.index);
                    values[1] = AIDACloudAdapter2D.this.cloud.valueY(this.index);
                    ++this.index;
                    return true;
                }
                catch (RuntimeException x) {
                    AIDACloudAdapter2D.this.style.setDisplayAsScatterPlot(false);
                    return false;
                }
            }
            return false;
        }

        public void restart() {
            AIDACloudAdapter2D.this.setValid();
            this.index = 0;
        }

        public void resetEndPoint() {
        }
    }
}

