/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelDirectTCPIP
extends Channel {
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    String host;
    int port;
    String originator_IP_address = "127.0.0.1";
    int originator_port = 0;

    ChannelDirectTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
    }

    void init() {
        try {
            this.io = new IO();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void connect() throws JSchException {
        block8: {
            try {
                int n;
                if (!this.session.isConnected()) {
                    throw new JSchException("session is down");
                }
                Buffer buffer = new Buffer(150);
                Packet packet = new Packet(buffer);
                packet.reset();
                buffer.putByte((byte)90);
                buffer.putString("direct-tcpip".getBytes());
                buffer.putInt(this.id);
                buffer.putInt(this.lwsize);
                buffer.putInt(this.lmpsize);
                buffer.putString(this.host.getBytes());
                buffer.putInt(this.port);
                buffer.putString(this.originator_IP_address.getBytes());
                buffer.putInt(this.originator_port);
                this.session.write(packet);
                try {
                    for (n = 1000; this.getRecipient() == -1 && this.session.isConnected() && n > 0 && !this.eof_remote; --n) {
                        Thread.sleep(50L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.session.isConnected()) {
                    throw new JSchException("session is down");
                }
                if (n == 0 || this.eof_remote) {
                    throw new JSchException("channel is not opened.");
                }
                this.connected = true;
                this.thread = new Thread(this);
                this.thread.start();
            }
            catch (Exception exception) {
                this.io.close();
                this.io = null;
                Channel.del(this);
                if (!(exception instanceof JSchException)) break block8;
                throw (JSchException)exception;
            }
        }
    }

    public void run() {
        Buffer buffer = new Buffer(this.rmpsize);
        Packet packet = new Packet(buffer);
        int n = 0;
        try {
            while (this.isConnected() && this.thread != null && this.io != null && this.io.in != null) {
                n = this.io.in.read(buffer.buffer, 14, buffer.buffer.length - 14 - 32 - 20);
                if (n <= 0) {
                    this.eof();
                } else if (!this.close) {
                    packet.reset();
                    buffer.putByte((byte)94);
                    buffer.putInt(this.recipient);
                    buffer.putInt(n);
                    buffer.skip(n);
                    this.session.write(packet, this, n);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.disconnect();
    }

    public void setInputStream(InputStream inputStream) {
        this.io.setInputStream(inputStream);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.io.setOutputStream(outputStream);
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setOrgIPAddress(String string) {
        this.originator_IP_address = string;
    }

    public void setOrgPort(int n) {
        this.originator_port = n;
    }
}

