/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.sftp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuBar;
import jp.advancesoft.chase.common.MyJMenu;
import jp.advancesoft.chase.common.MyJMenuItem;
import jp.advancesoft.chase.ssh.hosts.HostConfigurator;
import jp.advancesoft.chase.ssh.hosts.HostSelectorMenu;
import jp.advancesoft.chase.ssh.sftp.SftpClient;
import jp.advancesoft.chase.ssh.terminal.Terminal;
import org.apache.log4j.Logger;

class SftpClientMenuBar
extends JMenuBar {
    private static Logger logger = Logger.getLogger(SftpClientMenuBar.class.getName());
    private SftpClient parent;

    protected SftpClientMenuBar(SftpClient parent) {
        this.parent = parent;
        this.createMenu();
    }

    private void createMenu() {
        this.add(this.fileMenu());
        this.add(new HostSelectorMenu(this.parent, "hosts", 72));
        this.add(this.toolMenu());
    }

    private MyJMenu fileMenu() {
        MyJMenu file = new MyJMenu("File", 70, false);
        MyJMenu local = new MyJMenu("local", 76);
        MyJMenuItem[] localitems = this.getLocalItems();
        for (int i = 0; i < localitems.length; ++i) {
            local.add(localitems[i]);
        }
        MyJMenu remote = new MyJMenu("remote", 82, false);
        MyJMenuItem[] remoteitems = this.getRemoteItems();
        for (int i = 0; i < remoteitems.length; ++i) {
            remote.add(remoteitems[i]);
        }
        MyJMenuItem exit = new MyJMenuItem("exit", 88);
        file.add(local);
        file.add(remote);
        file.add(exit);
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClientMenuBar.this.parent.dispose();
            }
        });
        return file;
    }

    private MyJMenuItem[] getLocalItems() {
        MyJMenuItem locdel = new MyJMenuItem("delete", 68);
        MyJMenuItem locchfname = new MyJMenuItem("rename", 67);
        MyJMenuItem locmkdir = new MyJMenuItem("create new dir", 78);
        MyJMenuItem locprops = new MyJMenuItem("property", 80);
        MyJMenuItem[] ret = new MyJMenuItem[]{locchfname, locmkdir, locprops, locdel};
        locdel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClientMenuBar.this.parent.deleteSelectedFiles(1);
            }
        });
        locchfname.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClientMenuBar.this.parent.rename(1);
            }
        });
        locmkdir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClientMenuBar.this.parent.mkdir(1);
            }
        });
        locprops.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClientMenuBar.this.parent.bootFilePropertyViewer(1);
            }
        });
        return ret;
    }

    private MyJMenuItem[] getRemoteItems() {
        MyJMenuItem remdel = new MyJMenuItem("delete", 68);
        MyJMenuItem remchfname = new MyJMenuItem("rename", 67);
        MyJMenuItem remmkdir = new MyJMenuItem("create new dir", 78);
        MyJMenuItem remprops = new MyJMenuItem("property", 80);
        MyJMenuItem[] ret = new MyJMenuItem[]{remchfname, remmkdir, remprops, remdel};
        remdel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClientMenuBar.this.parent.deleteSelectedFiles(0);
            }
        });
        remchfname.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClientMenuBar.this.parent.rename(0);
            }
        });
        remmkdir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClientMenuBar.this.parent.mkdir(0);
            }
        });
        remprops.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClientMenuBar.this.parent.bootFilePropertyViewer(0);
            }
        });
        return ret;
    }

    private MyJMenu toolMenu() {
        MyJMenu tool = new MyJMenu("Tools", 67, false);
        MyJMenuItem host = new MyJMenuItem("host configurator", 72);
        MyJMenuItem term = new MyJMenuItem("terminal", 80);
        tool.add(host);
        tool.add(term);
        host.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator configurator = new HostConfigurator();
            }
        });
        term.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Terminal te = new Terminal(SftpClientMenuBar.this.parent.getHostInfo());
            }
        });
        return tool;
    }
}

