/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.util.Vector;
import jp.advancesoft.chase.ssh.filechooser.RemoteFile;
import jp.advancesoft.chase.ssh.sftp.MyProgressMonitor;
import jp.advancesoft.chase.ssh.sftp.SftpEvent;
import jp.advancesoft.chase.ssh.sftp.SftpListener;
import org.apache.log4j.Logger;

class Download
implements Runnable {
    private static Logger logger = Logger.getLogger(Download.class.getName());
    private RemoteFile[] files;
    private RemoteFile dir;
    private ChannelSftp c;
    private Vector listeners;
    private boolean recursive = true;

    protected Download(RemoteFile[] files, RemoteFile dir, ChannelSftp c2, Vector listeners) {
        this.files = files;
        this.dir = dir;
        this.c = c2;
        this.listeners = listeners;
    }

    protected Download(RemoteFile[] files, RemoteFile dir, ChannelSftp c2, Vector listeners, boolean recursive) {
        this.files = files;
        this.dir = dir;
        this.c = c2;
        this.listeners = listeners;
        this.recursive = recursive;
    }

    public void run() {
        this.download(this.files, this.dir);
    }

    private void download(RemoteFile[] files, RemoteFile dir) {
        int i;
        if (files != null && dir != null) {
            for (i = 0; i < files.length; ++i) {
                String downfile = files[i].getAbsolutePath();
                if (files[i].isDirectory()) {
                    if (this.recursive || files[i].getName().trim().equals(".") || files[i].getName().trim().equals("..")) continue;
                    RemoteFile newDir = new RemoteFile(dir.getAbsolutePath(), files[i].getName());
                    newDir.mkdir();
                    this.download((RemoteFile[])files[i].listFiles(), newDir);
                    continue;
                }
                String toDir = dir.getAbsolutePath();
                try {
                    int mode = 0;
                    logger.info("downloading file: " + downfile + " to " + dir.getAbsolutePath());
                    MyProgressMonitor monitor = new MyProgressMonitor();
                    this.c.get(downfile, toDir, monitor, mode);
                    logger.info("... done");
                    continue;
                }
                catch (SftpException e) {
                    logger.error("failed to download: " + downfile);
                }
            }
        }
        if (this.listeners != null) {
            for (i = 0; i < this.listeners.size(); ++i) {
                ((SftpListener)this.listeners.elementAt(i)).downloadFinished(new SftpEvent(this));
            }
        }
    }
}

