/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser.fileinfo;

import java.io.File;
import java.util.Vector;
import jp.advancesoft.chase.common.RegExpedString;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfoEvent;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfoListener;
import org.apache.log4j.Logger;

public class FileInfo {
    public static final int ALWAYS = 0;
    public static final int NEVER = 1;
    public static final int ON_DEMAND = 2;
    public static final int IN = 3;
    public static final int OUT = 4;
    public static final int INOUT = 5;
    public static final int NEWEST_ONLY = 6;
    public static final int ALL = 7;
    private static Logger logger = Logger.getLogger(FileInfo.class.getName());
    private RegExpedString identifier;
    private int intent = 3;
    private RegExpedString defaultName;
    private Vector names = new Vector();
    private Vector paths = new Vector();
    private int editlevel = 0;
    private int transfer = 7;
    private boolean multiple = false;
    private Vector listeners = new Vector();
    private String parser;
    private String regexpedName;

    public FileInfo(RegExpedString identifier, int intent, RegExpedString defaultName) {
        this.identifier = identifier;
        this.intent = intent;
        this.defaultName = defaultName;
    }

    public RegExpedString getIdentifier() {
        return this.identifier;
    }

    public String getParser() {
        return this.parser;
    }

    public void setParser(String parser) {
        this.parser = parser;
    }

    public int getIntent() {
        return this.intent;
    }

    public RegExpedString getDefaultName() {
        return this.defaultName;
    }

    public void setTransferScheme(int transfer) {
        this.transfer = transfer;
    }

    public int getTransferScheme() {
        return this.transfer;
    }

    public void setName(String name) {
        this.names.addElement(name);
        this.notifyListeners();
    }

    public void setRegExpedName(String regexpedName) {
        this.regexpedName = regexpedName;
    }

    public String getRegExpedName() {
        return this.regexpedName;
    }

    public void setNameAt(String name, int index) {
        if (this.names.size() > index) {
            this.names.setElementAt(name, index);
        } else {
            for (int i = this.names.size(); i < index; ++i) {
                this.names.addElement("");
            }
            this.names.addElement(name);
        }
        this.notifyListeners();
    }

    public void deleteNameAt(int index) {
        if (this.names.size() <= index) {
            return;
        }
        this.names.remove(index);
    }

    public void deletePathAt(int index) {
        if (this.paths.size() <= index) {
            return;
        }
        this.paths.remove(index);
    }

    public void setPath(String path) {
        this.setPath(new File(path));
    }

    public void setPath(File path) {
        this.paths.addElement(path);
        this.notifyListeners();
    }

    public void setPathAt(String path, int index) {
        this.setPathAt(new File(path), index);
    }

    public void setPathAt(File path, int index) {
        if (this.paths.size() > index) {
            this.paths.setElementAt(path, index);
        } else {
            for (int i = this.paths.size(); i < index; ++i) {
                this.paths.addElement("");
            }
            this.paths.addElement(path);
        }
        this.notifyListeners();
    }

    public void hasMultipleFiles(boolean multiple) {
        this.multiple = multiple;
    }

    public boolean hasMultipleFiles() {
        return this.multiple;
    }

    public String getName() {
        if (this.names.size() == 0) {
            return "";
        }
        return (String)this.names.elementAt(this.names.size() - 1);
    }

    public File getPath() {
        if (this.paths.size() == 0) {
            return new File(".");
        }
        return (File)this.paths.elementAt(this.paths.size() - 1);
    }

    public void delete(String name, File path) {
        String[] tmpnames = this.getNames();
        File[] tmppaths = this.getPaths();
        if (tmpnames != null && tmppaths != null) {
            for (int i = 0; i < tmpnames.length; ++i) {
                if (!tmpnames[i].equals(name) || tmppaths[i].compareTo(path) != 0) continue;
                this.names.remove(i);
                this.paths.remove(i);
            }
        }
    }

    public String[] getNames() {
        if (this.names.size() == 0) {
            String[] ret = new String[]{""};
            return ret;
        }
        String[] ret = null;
        if (this.multiple) {
            ret = new String[this.names.size()];
            for (int i = 0; i < this.names.size(); ++i) {
                ret[i] = (String)this.names.elementAt(i);
            }
        } else {
            ret = new String[]{(String)this.names.elementAt(this.names.size() - 1)};
        }
        return ret;
    }

    public File[] getPaths() {
        if (this.paths.size() == 0) {
            File[] ret = new File[]{new File(".")};
            return ret;
        }
        File[] ret = null;
        if (this.multiple) {
            ret = new File[this.paths.size()];
            for (int i = 0; i < this.paths.size(); ++i) {
                ret[i] = (File)this.paths.elementAt(i);
            }
        } else {
            ret = new File[]{(File)this.paths.elementAt(this.paths.size() - 1)};
        }
        return ret;
    }

    public void setFileNameEditLevel(String editlevel) {
        if (editlevel.equalsIgnoreCase("always")) {
            this.editlevel = 0;
        } else if (editlevel.equalsIgnoreCase("never")) {
            this.editlevel = 1;
            if (this.names.size() == 0) {
                this.names.addElement(this.getDefaultName().getValue());
                logger.debug("name: " + this.getName());
            }
            if (this.paths.size() == 0) {
                this.paths.addElement(new File("."));
            }
        } else if (editlevel.equalsIgnoreCase("on_demand")) {
            this.editlevel = 2;
        }
    }

    public int getFileNameEditLevel() {
        return this.editlevel;
    }

    public void addFileInfoChangeListener(FileInfoListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeFileInfoChangeListener(FileInfoListener listener) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.elementAt(i) != listener) continue;
            this.listeners.remove(i);
        }
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((FileInfoListener)this.listeners.elementAt(i)).fileInfoChanged(new FileInfoEvent(this));
        }
    }

    public String toString() {
        int i;
        String ls = System.getProperty("line.separator");
        String retValue = "fileinfo: " + ls;
        String[] names = this.getNames();
        File[] paths = this.getPaths();
        for (i = 0; i < names.length; ++i) {
            retValue = retValue + "filename: " + names[i] + ls;
        }
        for (i = 0; i < paths.length; ++i) {
            retValue = retValue + "path: " + paths[i].getPath() + ls;
        }
        retValue = retValue + "is path absolute? " + String.valueOf(this.getPath().isAbsolute()) + ls;
        retValue = retValue + "filename editlevel: " + this.editlevel + ls;
        return retValue;
    }
}

