/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser.fileinfo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import jp.advancesoft.chase.common.RegExpedString;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfo;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DefaultFileInfo {
    private static Logger logger = Logger.getLogger(DefaultFileInfo.class.getName());
    protected Vector fileinfovec = new Vector();
    private URL fileinfofile;
    private String fileinfoname;
    private boolean validFileInfo = true;

    public DefaultFileInfo(URL fileinfofile, String fileinfoname) {
        this.fileinfofile = fileinfofile;
        this.fileinfoname = fileinfoname;
        this.validFileInfo = this.parseFileInfo(fileinfofile);
    }

    public FileInfo[] getFileInfos() {
        FileInfo[] ret = new FileInfo[this.fileinfovec.size()];
        for (int i = 0; i < this.fileinfovec.size(); ++i) {
            ret[i] = (FileInfo)this.fileinfovec.elementAt(i);
        }
        return ret;
    }

    public Vector getFileInfoVec() {
        return this.fileinfovec;
    }

    public String getFileInfoName() {
        return this.fileinfoname;
    }

    public boolean isFileInfoValid() {
        return this.validFileInfo;
    }

    private boolean parseFileInfo(URL fileinfofile) {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(fileinfofile);
        }
        catch (JDOMException jde) {
            logger.error("failed to parse " + fileinfofile);
            return false;
        }
        catch (IOException ioe) {
            logger.error("failed to parse " + fileinfofile);
            return false;
        }
        Element root = doc.getRootElement();
        if (!root.getName().equals("fileinfofile")) {
            logger.error("invalid fileinfo file.");
            return false;
        }
        List listroot = root.getChildren();
        List list = null;
        int nfileinfo = listroot.size();
        for (int i = 0; i < nfileinfo; ++i) {
            Element elem = (Element)listroot.get(i);
            if (!elem.getAttributeValue("fileinfoname").equals(this.fileinfoname)) continue;
            list = elem.getChildren();
            break;
        }
        if (list == null) {
            logger.error("couldn't find fileinfo: " + this.fileinfoname);
            return false;
        }
        int numfileinfo = list.size();
        if (numfileinfo == 0) {
            logger.error("invalid fileinfo file.");
            return false;
        }
        for (int i = 0; i < numfileinfo; ++i) {
            Element element = (Element)list.get(i);
            if (!element.getName().equals("file")) continue;
            String sintent = element.getChildTextTrim("intent");
            int intent = 3;
            if (sintent.equals("IN")) {
                intent = 3;
            } else if (sintent.equals("OUT")) {
                intent = 4;
            } else if (sintent.equals("INOUT")) {
                intent = 5;
            }
            int transfer = 7;
            String stransfer = element.getChildTextTrim("transfer");
            if (stransfer != null && stransfer.equals("NEWEST_ONLY")) {
                transfer = 6;
            }
            Element ident = element.getChild("identifier");
            boolean ident_has_reg = new Boolean(ident.getAttributeValue("hasregexp"));
            String identifier = ident.getTextTrim();
            String ident_replace = "";
            if (ident_has_reg) {
                ident_replace = ident.getAttributeValue("replace_string");
            }
            Element defname = element.getChild("defaultname");
            boolean defname_has_reg = new Boolean(defname.getAttributeValue("hasregexp"));
            String defaultname = defname.getTextTrim();
            String def_replace = "";
            if (defname_has_reg) {
                def_replace = defname.getAttributeValue("replace_string");
            }
            boolean hasMultiple = new Boolean(element.getChildTextTrim("multiple"));
            String parser = element.getChildTextTrim("parser");
            if (parser == null || parser.length() == 0) {
                parser = "";
            }
            logger.debug("defaultname: " + defaultname);
            logger.debug("defname_has_reg: " + defname_has_reg);
            logger.debug("def_replace: " + def_replace);
            FileInfo fileinfo = new FileInfo(new RegExpedString(identifier, ident_has_reg, ident_replace), intent, new RegExpedString(defaultname, defname_has_reg, def_replace));
            fileinfo.setFileNameEditLevel(element.getChildTextTrim("filenameeditlevel"));
            fileinfo.hasMultipleFiles(hasMultiple);
            fileinfo.setTransferScheme(transfer);
            fileinfo.setParser(parser);
            this.fileinfovec.addElement(fileinfo);
        }
        if (this.fileinfovec.size() == 0) {
            logger.error("no file info!");
            return false;
        }
        return true;
    }

    public void debug() {
        if (!this.validFileInfo) {
            logger.error("the file " + this.fileinfofile.getPath() + "seems to be invalid ... ");
            return;
        }
        FileInfo[] fileinfos = this.getFileInfos();
        for (int i = 0; i < fileinfos.length; ++i) {
            FileInfo fitmp = fileinfos[i];
            logger.debug("identifier: " + fitmp.getIdentifier() + " intent: " + fitmp.getIntent() + " defaultname: " + fitmp.getDefaultName());
            String[] names = fitmp.getNames();
            for (int j2 = 0; j2 < names.length; ++j2) {
                logger.debug("name: " + names[j2]);
            }
            File[] paths = fitmp.getPaths();
            for (int j3 = 0; j3 < paths.length; ++j3) {
                logger.debug("path: " + paths[j3].getPath());
            }
        }
    }
}

