/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser;

import java.awt.GridLayout;
import java.lang.reflect.Constructor;
import javax.swing.JPanel;
import jp.advancesoft.chase.main.PluginLoader;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.projectbrowser.ProjectManipulator;
import jp.advancesoft.chase.projectbrowser.TabbedProjectManipulator;
import org.apache.log4j.Logger;

class TabPanel
extends JPanel {
    private Logger logger = Logger.getLogger(TabPanel.class.getName());
    private String loadClass;
    private ProjectInfo info;
    private int ID;
    private ProjectManipulator manip = null;
    private TabbedProjectManipulator parent;
    private boolean reload = false;

    protected TabPanel(TabbedProjectManipulator parent, String loadClass, ProjectInfo info, int ID) {
        this.parent = parent;
        this.loadClass = loadClass;
        this.info = info;
        this.ID = ID;
        this.setLayout(new GridLayout());
    }

    protected int getID() {
        return this.ID;
    }

    protected void instantiate() {
        if (this.manip == null || this.reload) {
            PluginLoader loader = new PluginLoader();
            try {
                Class<?> cla = loader.loadClass(this.loadClass);
                Constructor<?>[] constructor = cla.getDeclaredConstructors();
                this.manip = (ProjectManipulator)constructor[0].newInstance(this.info);
                this.manip.init();
                this.info.getParent().registerProjectManipulators(this.manip);
                this.logger.debug("loaded class: " + cla.getName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.logger.error("failed to load class: " + this.loadClass + " ... contact AdvanceSoft.");
            }
            if (this.manip != null) {
                this.logger.debug("adding " + this.loadClass);
                this.removeAll();
                this.add(this.manip);
            }
        }
        this.reload = false;
    }

    protected void setReload(boolean reload) {
        this.reload = reload;
    }
}

