/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.List;
import javax.swing.JPanel;
import jp.advancesoft.chase.main.PluginLoader;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public abstract class ProjectManipulator
extends JPanel {
    private static Logger logger = Logger.getLogger(ProjectManipulator.class.getName());
    public static String PROJECT_MANIPULATOR_XML_PATH = "/jp/advancesoft/chase/projectbrowser/ProjectManipulator.xml";
    protected ProjectInfo projectInfo;
    protected Object[] args;

    public ProjectManipulator(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    public ProjectManipulator(ProjectInfo projectInfo, Object[] args) {
        this.projectInfo = projectInfo;
        this.args = args;
    }

    public static ProjectManipulator createProjectManipulator(ProjectInfo info) {
        String type = info.getProjectType();
        URL projurl = null;
        projurl = ProjectManipulator.class.getResource(PROJECT_MANIPULATOR_XML_PATH);
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(projurl);
        }
        catch (JDOMException jde) {
            logger.error("failed to parse " + projurl);
            logger.error("unrecoverable error... contact AdvanceSoft.");
        }
        catch (IOException ioe) {
            logger.error("failed to parse " + projurl);
            logger.error("unrecoverable error... contact AdvanceSoft.");
        }
        Element elem = doc.getRootElement();
        if (!elem.getName().equals("root")) {
            logger.error("invalid ProjectSpecification file... contact AdvanceSoft.");
        }
        List list = elem.getChildren("project");
        String loadclass = null;
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            String name = element.getChildTextTrim("name");
            if (!name.equals(type)) continue;
            loadclass = element.getChildTextTrim("loadclass");
            break;
        }
        if (loadclass == null) {
            logger.error("failed to get a valid class name to load... contact AdvanceSoft.");
        }
        if (loadclass.equalsIgnoreCase("null")) {
            return null;
        }
        ProjectManipulator manip = null;
        PluginLoader pl = new PluginLoader();
        try {
            Class<?> cla = pl.loadClass(loadclass);
            Constructor<?>[] constructor = cla.getDeclaredConstructors();
            manip = (ProjectManipulator)constructor[0].newInstance(info);
        }
        catch (Exception ex) {
            logger.error("failed to load class: " + loadclass + " ... contact AdvanceSoft.");
            ex.printStackTrace();
        }
        return manip;
    }

    public abstract void init();

    public abstract void initializeProject();

    public void initializeProject(ProjectDirBrowserNode node) {
    }

    public boolean postProcess() {
        return true;
    }

    public void recreate() {
    }
}

