/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser;

import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JSplitPane;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.projectbrowser.InternalFrameListenerProjectBrowser;
import jp.advancesoft.chase.projectbrowser.ProjectBrowserMenuBar;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.projectbrowser.ProjectManipulator;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChangeEvent;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChangeListener;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ProjectBrowser
extends InternalFrameChase
implements ProjectStateChangeListener {
    private static Logger logger = Logger.getLogger(ProjectBrowser.class.getName());
    private String myproj = System.getProperty("user.home") + System.getProperty("file.separator") + ".chase" + System.getProperty("file.separator") + "my_projects.xml";
    private JSplitPane splitpane;
    private Document doc;
    private ProjectDirBrowser dirbrowser;
    private Vector projectManipulators = new Vector();
    private ProjectInfo projectInfo;

    public ProjectBrowser(Dimension dim, ProjectInfo projectInfo) {
        super(projectInfo.getProjectName(), true, true, true, true, dim);
        projectInfo.setParent(this);
        this.init();
    }

    public void registerProjectManipulators(ProjectManipulator manip) {
        this.projectManipulators.addElement(manip);
    }

    public boolean isLoaded(Class clazz) {
        String cname = clazz.getName();
        for (int i = 0; i < this.projectManipulators.size(); ++i) {
            String regName = this.projectManipulators.elementAt(i).getClass().getName();
            if (!regName.equals(cname)) continue;
            return true;
        }
        return false;
    }

    public ProjectManipulator getProjectManipulator(String cname) {
        for (int i = 0; i < this.projectManipulators.size(); ++i) {
            String regName = this.projectManipulators.elementAt(i).getClass().getName();
            if (!regName.equals(cname)) continue;
            return (ProjectManipulator)this.projectManipulators.elementAt(i);
        }
        return null;
    }

    protected boolean imClosing() {
        boolean ret = true;
        for (int i = 0; i < this.projectManipulators.size(); ++i) {
            Object obj = this.projectManipulators.elementAt(i);
            if (obj == null || !((ProjectManipulator)obj).postProcess()) continue;
            ret = false;
        }
        return ret;
    }

    public void projectStateChanged(ProjectStateChangeEvent e) {
    }

    public ProjectDirBrowser getDirBrowser() {
        return this.dirbrowser;
    }

    private void init() {
        this.setJMenuBar(new ProjectBrowserMenuBar(this));
        this.addInternalFrameListener(new InternalFrameListenerProjectBrowser(this));
    }

    public void setProjectManipulator(ProjectManipulator manip) {
        Container container = this.getContentPane();
        container.removeAll();
        container.add(manip);
    }

    public ProjectDirBrowserNode getRootNode() {
        return this.dirbrowser.getRootNode();
    }

    public ProjectDirBrowserNode getSelectedNode() {
        return this.dirbrowser.getSelectedNode();
    }

    public static Document getDocument(File myproj_file) {
        Document docu;
        Element root;
        URL myproj_url;
        if (myproj_file.exists()) {
            try {
                myproj_url = new URL("file://localhost/" + myproj_file.getAbsolutePath());
            }
            catch (MalformedURLException ex) {
                logger.warn("malformed url found. using default.");
                myproj_url = ProjectBrowser.class.getResource("/jp/advancesoft/chase/projectbrowser/my_projects.xml");
            }
        } else {
            myproj_url = ProjectBrowser.class.getResource("/jp/advancesoft/chase/projectbrowser/my_projects.xml");
        }
        if (!(root = (docu = ProjectBrowser.createDoc(myproj_url)).getRootElement()).getName().equals("projects")) {
            logger.warn("not a valid my_projects file... using default");
            myproj_url = ProjectBrowser.class.getResource("/jp/advancesoft/chase/projectbrowser/my_projects.xml");
            docu = ProjectBrowser.createDoc(myproj_url);
        }
        return docu;
    }

    private static Document createDoc(URL url) {
        Document docu = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            docu = builder.build(url);
        }
        catch (JDOMException jde) {
            logger.error("failed to parse " + url);
            logger.error("unrecoverable error... contact AdvanceSoft.");
        }
        catch (IOException ioe) {
            logger.error("failed to parse " + url);
            logger.error("unrecoverable error... contact AdvanceSoft.");
        }
        logger.debug("doc: " + docu);
        return docu;
    }
}

