/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.primitiveguis.tableforinputinterface;

import java.text.DecimalFormat;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jp.advancesoft.chase.common.Utils;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfaceEntry;
import jp.advancesoft.chase.inputinterface.InputInterfaceEntryChangeEvent;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTable;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.TableModelForInputInterface;
import org.apache.log4j.Logger;

public class TableModelForTabularData
extends TableModelForInputInterface {
    private static Logger logger = Logger.getLogger(TableModelForTabularData.class.getName());
    private Vector tableData = new Vector();
    private String[] idents;

    public TableModelForTabularData(String[] inputSpecifications, InputInterface input, int[] mapSpecCol, EventListener el) {
        super(inputSpecifications, input, mapSpecCol, el);
        super.init();
    }

    public TableModelForTabularData(String[] inputSpecifications, InputInterface input, int[] mapSpecCol, EventListener el, int columnIndex) {
        super(inputSpecifications, input, mapSpecCol, el, columnIndex);
        super.init();
    }

    public void setValueAt(Object data, int row, int col) {
        if (col >= this.mapSpecCol.length) {
            super.setValueAt(data, row, col);
            return;
        }
        if (!this.columns[this.mapSpecCol[col]].format()) {
            super.setValueAt(data, row, col);
        } else {
            Object formatedData;
            DecimalFormat formatter = this.columns[this.mapSpecCol[col]].getFormatter();
            if (data instanceof Double) {
                formatedData = formatter.format((Double)data);
            } else if (data instanceof String) {
                try {
                    Double d = Double.valueOf((String)data);
                    formatedData = formatter.format(d);
                }
                catch (NumberFormatException ne) {
                    formatedData = data;
                }
            } else {
                formatedData = data;
            }
            super.setValueAt(formatedData, row, col);
        }
    }

    protected void createTableColumns() {
        if (this.columns == null) {
            return;
        }
        for (int i = 0; i < this.mapSpecCol.length; ++i) {
            this.addColumn(this.columns[this.mapSpecCol[i]].getName());
        }
        int nrw = this.manager.getTableSpec(this.inputSpecifications[0]).getNumRows();
        if (nrw > 0) {
            this.setRowCount(nrw);
        }
    }

    protected void extractInputFile() {
        InputInterfaceTable iitable = this.input.getInputInterfaceTable(this.inputSpecifications[0]);
        this.idents = iitable.getColumnIdentifiers();
        this.tableData = iitable.getTableData();
        this.setInputToModel();
    }

    protected void setInputToModel() {
        this.input.setUpdateUndoStack(false);
        this.updateInputInterface = false;
        int icol = this.getColumnCount();
        int irow = this.getRowCount();
        logger.debug("at setInputToModel(): dump tableData, whose size is " + this.tableData.size());
        logger.debug("at setInputToModel(): icol, irow: " + icol + " " + irow);
        for (int i = 0; i < this.tableData.size(); ++i) {
            String[] tmp = (String[])this.tableData.elementAt(i);
            for (int j2 = 0; j2 < tmp.length; ++j2) {
                logger.debug("tableData at " + i + " " + j2 + " : " + tmp[j2]);
            }
        }
        String[] columnNames = new String[icol];
        Vector<Integer[]> map = new Vector<Integer[]>();
        int firstLetterCapsCol = -1;
        if (this.idents != null && this.tableData != null) {
            int i;
            int i2;
            for (i2 = 0; i2 < icol; ++i2) {
                columnNames[i2] = this.getColumnName(i2);
                if (!this.columns[this.mapSpecCol[i2]].isFirstLetterCaps()) continue;
                firstLetterCapsCol = i2;
            }
            for (i2 = 0; i2 < icol; ++i2) {
                for (int j3 = 0; j3 < this.idents.length; ++j3) {
                    if (!columnNames[i2].equalsIgnoreCase(this.idents[j3])) continue;
                    Integer[] it = new Integer[]{new Integer(i2), new Integer(j3)};
                    map.addElement(it);
                }
            }
            Vector<Integer> itable = new Vector<Integer>();
            Vector<Integer> iinput = new Vector<Integer>();
            for (int i3 = 0; i3 < map.size(); ++i3) {
                Integer[] it = (Integer[])map.get(i3);
                itable.addElement(it[0]);
                iinput.addElement(it[1]);
            }
            int dataSize = this.tableData.size();
            Vector<String> dummy = new Vector<String>();
            if (dataSize > irow) {
                for (i = irow; i < dataSize; ++i) {
                    for (int j4 = 0; j4 < icol; ++j4) {
                        dummy.addElement("");
                    }
                    this.addRow(dummy);
                    dummy = new Vector();
                }
            }
            for (i = 0; i < this.tableData.size(); ++i) {
                String[] rowData = (String[])this.tableData.get(i);
                for (int j5 = 0; j5 < map.size(); ++j5) {
                    int it = (Integer)itable.get(j5);
                    int ii = (Integer)iinput.get(j5);
                    String dat = rowData[ii];
                    if (it == firstLetterCapsCol) {
                        dat = Utils.firstLetterCaps(dat);
                    }
                    logger.debug("setting value : " + dat + " at row: " + i + " and column: " + it);
                    this.setValueAt(dat, i, it);
                }
            }
        }
        this.updateInputInterface = true;
        this.input.setUpdateUndoStack(true);
    }

    public void inputInterfaceInitializing() {
        int i;
        logger.debug("intializing TableModel: " + this.inputSpecifications[0]);
        TableModelListener[] listeners = this.getTableModelListeners();
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            this.removeTableModelListener(listeners[i2]);
        }
        int row = this.getRowCount();
        int col = this.getColumnCount();
        int nullCount = 0;
        for (i = 0; i < row; ++i) {
            for (int j2 = 0; j2 < col; ++j2) {
                Object obj = this.getValueAt(i, j2);
                if (obj != null && obj instanceof String && ((String)obj).trim().length() == 0) {
                    ++nullCount;
                }
                this.setValueAt("", i, j2);
            }
            if (nullCount == col) break;
            nullCount = 0;
        }
        for (i = 0; i < listeners.length; ++i) {
            this.addTableModelListener(listeners[i]);
        }
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
        logger.debug("entry changed: " + e.getTag());
        if (e == null || e.getTag() == null) {
            logger.debug("something is wrong... InputInterfaceEntryChangeEvent not properly initialized.");
            return;
        }
        if (e.getSource() == this) {
            return;
        }
        if (!e.getTag().trim().equalsIgnoreCase(this.inputSpecifications[0])) {
            return;
        }
        InputInterfaceEntry entry = e.getEntry();
        if (entry.getEntryType() != 1) {
            return;
        }
        logger.debug("e.getSource(): " + e.getSource());
        logger.debug("this: " + this);
        InputInterfaceTable iitable = this.input.getInputInterfaceTable(this.inputSpecifications[0]);
        if (iitable.getColumnIdentifiers() != null) {
            this.idents = iitable.getColumnIdentifiers();
        }
        this.tableData = iitable.getTableData();
        logger.debug("dump tableData, whose size is " + this.tableData.size());
        for (int i = 0; i < this.tableData.size(); ++i) {
            String[] tmp = (String[])this.tableData.elementAt(i);
            for (int j2 = 0; j2 < tmp.length; ++j2) {
                logger.debug("tableData at " + i + " " + j2 + " : " + tmp[j2]);
            }
        }
        Utils.clearTableModel(this);
        this.setInputToModel();
    }

    public void execute(EventObject e) {
        TableModelListener[] listeners = this.getTableModelListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.removeTableModelListener(listeners[i]);
        }
        TableModelEvent tmde = (TableModelEvent)e;
        int first = 0;
        int last = 0;
        if (tmde == null) {
            this.restoreListeners(listeners);
            return;
        }
        first = tmde.getFirstRow();
        last = tmde.getLastRow();
        logger.debug("first row that changed: " + tmde.getFirstRow());
        logger.debug("last row that changed: " + tmde.getLastRow());
        logger.debug("row count: " + this.getRowCount());
        logger.debug("type: " + tmde.getType());
        if (first < 0 || last < 0) {
            this.restoreListeners(listeners);
            return;
        }
        for (int i = 0; i < this.mapSpecCol.length; ++i) {
            if (!this.columns[this.mapSpecCol[i]].getDefaultValue().trim().equals("INCRE") || !this.columns[this.mapSpecCol[i]].ignoreOnSave()) continue;
            this.setValueAt(new Integer(last + 1), last, i);
        }
        if (!this.updateInputInterface) {
            this.restoreListeners(listeners);
            return;
        }
        InputInterfaceTable iitable = this.input.getInputInterfaceTable(this.inputSpecifications[0]);
        Vector data = new Vector();
        logger.debug("updating table data ...");
        int nullCount = 0;
        String[] iden = new String[this.mapSpecCol.length];
        String[] row = new String[this.mapSpecCol.length];
        int rowC = this.getRowCount();
        for (int i = first; i < last + 1; ++i) {
            int j2;
            for (j2 = 0; j2 < this.mapSpecCol.length; ++j2) {
                InputInterfaceTableColumns col = this.columns[this.mapSpecCol[j2]];
                if (col.ignoreOnSave()) {
                    ++nullCount;
                    continue;
                }
                iitable.setWillChangeRow(i, InputInterfaceTable.REPLACE);
                iitable.saveState();
                String nam = this.columns[this.mapSpecCol[j2]].getInputSpecifications();
                if (i >= rowC) {
                    iitable.removeTableDataRow(i, last);
                    this.restoreListeners(listeners);
                    return;
                }
                Object obj = this.getValueAt(i, j2);
                iden[j2] = nam;
                String string = "";
                if (obj instanceof String) {
                    string = (String)obj;
                } else if (obj instanceof Boolean) {
                    boolean bool = (Boolean)obj;
                    String string2 = string = bool ? "1" : "0";
                }
                if (string == null || string.trim().length() == 0) {
                    row[j2] = "";
                    ++nullCount;
                    continue;
                }
                row[j2] = string;
            }
            for (j2 = 0; j2 < this.mapSpecCol.length; ++j2) {
                logger.debug("updating inputinterface object...");
                logger.debug("ident: " + iden[j2]);
                logger.debug("value: " + row[j2]);
            }
            iitable.replaceTableDataRow(iden, row, i);
        }
        this.input.replaceEntry(iitable, this);
        logger.debug("size of data: " + data.size());
        this.restoreListeners(listeners);
    }

    public void clearInputInterfaceTableData() {
        InputInterfaceTable iitable = this.input.getInputInterfaceTable(this.inputSpecifications[0]);
        iitable.initializeData();
    }

    public String toString() {
        String ret = "cols: ";
        for (int i = 0; i < this.columns.length; ++i) {
            ret = ret + " " + this.columns[i].getName();
        }
        return ret;
    }

    public void removeRow(int row) {
        logger.debug("removing row.");
        InputInterfaceTable iitable = this.input.getInputInterfaceTable(this.inputSpecifications[0]);
        iitable.setWillChangeRow(row, InputInterfaceTable.REMOVE);
        iitable.saveState();
        iitable.removeTableDataRow(row, row);
        this.input.replaceEntry(iitable, this, true);
        logger.debug("removing row from table.");
        this.updateInputInterface = false;
        super.removeRow(row);
        this.updateInputInterface = true;
        logger.debug("finished removing row");
    }
}

