/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.primitiveguis.tableforinputinterface;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.ColumnHeaderCheckBox;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.ColumnHeaderMouseListener;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.TableForInputInterface;
import org.apache.log4j.Logger;

class TableHeader
extends JTableHeader
implements Command {
    private Logger logger = Logger.getLogger(TableHeader.class.getName());
    private TableColumnModel model;
    private InputInterfaceTableColumns[] columns;
    private TableForInputInterface table;
    int[] map;

    protected TableHeader(TableForInputInterface table, InputInterfaceTableColumns[] columns, int[] map) {
        super(table.getColumnModel());
        this.table = table;
        this.model = table.getColumnModel();
        this.columns = columns;
        this.map = map;
        this.addMouseListener(new ColumnHeaderMouseListener());
    }

    public void execute(EventObject e) {
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            this.logger.debug("at: tableheader...");
            if (me.getButton() == 3) {
                this.logger.debug("right-clicked table header...");
                this.showMenu((MouseEvent)e);
            }
        }
    }

    private void showMenu(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        int numCol = this.model.getColumnCount();
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].isHideable()) continue;
            ColumnHeaderCheckBox item = new ColumnHeaderCheckBox(this.table, this.columns[i].getName(), true);
            boolean vis = false;
            for (int j2 = 0; j2 < numCol; ++j2) {
                if (!((String)this.model.getColumn(j2).getHeaderValue()).equalsIgnoreCase(this.columns[i].getName().trim())) continue;
                vis = true;
                break;
            }
            item.setState(vis);
            popup.add(item);
        }
        if (popup.getComponentCount() > 0) {
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

