/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.primitiveguis;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import jp.advancesoft.chase.inputinterface.InputInterfaceUnits;
import org.apache.log4j.Logger;

public abstract class PrimitiveInputComponents
extends JPanel {
    private static Logger logger = Logger.getLogger(PrimitiveInputComponents.class.getName());
    protected String[] inputSpecifications;
    protected String[] fullName;
    protected InputInterface inputInterface;
    protected InputInterfacePrimitiveEntry entry;
    protected InputInterfaceUnits units;

    public PrimitiveInputComponents(String[] inputSpecifications, InputInterface inputInterface) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.extractInputFile();
    }

    protected void addListeners(EventListener listener) {
        Component[] comps = this.getComponents();
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (comp == null || !(comp instanceof Command)) continue;
            if (comp instanceof AbstractButton) {
                ((AbstractButton)comp).addActionListener((ActionListener)listener);
                ((AbstractButton)comp).addItemListener((ItemListener)listener);
                if (!(comp instanceof JComboBox)) continue;
                ((JComboBox)comp).addPopupMenuListener((PopupMenuListener)listener);
                continue;
            }
            if (!(comp instanceof JTextComponent)) continue;
            ((JTextComponent)comp).addCaretListener((CaretListener)listener);
        }
    }

    protected void extractInputFile() {
        for (int is = 0; is < this.inputSpecifications.length; ++is) {
            String st;
            String inp = this.inputSpecifications[is];
            this.fullName = inp.split("\\.");
            String blockIdent = this.fullName[0];
            for (int i = 1; i < this.fullName.length - 1; ++i) {
                blockIdent = blockIdent + "." + this.fullName[i];
            }
            this.inputInterface.selectRoot();
            if (!this.inputInterface.selectBlock(blockIdent)) {
                logger.debug("couldn't select block: " + blockIdent);
            }
            boolean found = false;
            this.units = this.inputInterface.getUnits();
            if (this.units.getName().trim().length() != 0 || is == this.inputSpecifications.length - 1) {
                logger.debug("got entry: " + this.units.getName());
                st = this.inputSpecifications[0];
                found = true;
            }
            this.entry = this.inputInterface.getPrimitiveEntry(this.fullName[this.fullName.length - 1]);
            if (this.entry.getName().trim().length() != 0 || is == this.inputSpecifications.length - 1) {
                logger.debug("got entry: " + this.entry.getName() + " value: " + this.entry.getValue() + " unit: " + this.entry.getUnit());
                st = this.inputSpecifications[0];
                this.fullName = st.split("\\.");
                this.entry.setName(this.fullName[this.fullName.length - 1].trim());
                found = true;
            }
            if (found) break;
        }
    }
}

