/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.event.ActionListener;
import java.io.File;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import jp.advancesoft.chase.atomcoord.Exporters;
import jp.advancesoft.chase.common.Command;
import org.apache.log4j.Logger;

class ExportButton
extends JButton
implements Command {
    private static Logger logger = Logger.getLogger(ExportButton.class.getName());
    private Exporters exporters;

    public ExportButton(String title, Exporters exporters, EventListener listener) {
        super(title);
        this.exporters = exporters;
        super.addActionListener((ActionListener)listener);
    }

    public void execute(EventObject e) {
        JFileChooser fdlg = new JFileChooser(".");
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("select file for export");
        fdlg.setFileSelectionMode(0);
        if (fdlg.showOpenDialog(this) != 0) {
            return;
        }
        File file = fdlg.getSelectedFile();
        logger.info("exporting atomic coordinates to: " + file.getAbsolutePath());
        if (!this.exporters.exportAtomicCoordinatesTo(file)) {
            logger.warn("failed export to: " + file);
        } else {
            logger.info("import from " + file + " complete");
        }
    }
}

