/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jp.advancesoft.chase.common.ExcelAdapter;
import jp.advancesoft.chase.common.InputPanel;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;

class BandKptInputEditor
extends InternalFrameChase {
    private Container cont;
    private String fileName;
    private File file;
    private int sizex = 500;
    private int sizey = 350;
    private InputPanel ipdeltK;
    private InputPanel ipn1;
    private InputPanel ipn2;
    private InputPanel ipn3;
    private InputPanel ipnd;
    private InputPanel ipSymbol;
    private JTable tbl_kvec;
    private JTable tbl_special;
    private String[] colNameK = new String[]{"", "b1", "b2", "b3"};
    private String[] colNameSpecial = new String[]{"n1", "n2", "n3", "nd", "symbol"};
    private String[][] rowDataSpecial = new String[100][5];
    private String deltK;
    private String[][] Kvec = new String[][]{{"x", "", "", ""}, {"y", "", "", ""}, {"z", "", "", ""}};
    private Vector specialKpoints = new Vector();

    public BandKptInputEditor(String fileName) {
        super(new File(fileName).getName(), true, true, true, true);
        this.fileName = fileName;
        this.file = new File(fileName);
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        this.cont.add(this.createInputEditor());
        this.cont.add(this.createButtonPanel());
        if (this.file.exists()) {
            this.readInput();
        }
        this.setSize(this.sizex, this.sizey);
        this.setVisible(false);
    }

    public void display() {
        this.setVisible(true);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.file = new File(fileName);
    }

    private JPanel createInputEditor() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.ipdeltK = new InputPanel("delta k", 0, 10);
        p.add(this.ipdeltK);
        p.add(this.createTableKVec());
        p.add(this.createTableSpecial());
        return p;
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton btnsave = new JButton("save");
        JButton btnsaveclose = new JButton("save & close");
        JButton btnclose = new JButton("close");
        p.add(btnsave);
        p.add(btnsaveclose);
        p.add(btnclose);
        btnsave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BandKptInputEditor.this.saveInput();
            }
        });
        btnsaveclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BandKptInputEditor.this.saveInput();
                BandKptInputEditor.this.dispose();
            }
        });
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BandKptInputEditor.this.dispose();
            }
        });
        return p;
    }

    private JPanel createTableKVec() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder("reciprocal lattice vectors"));
        this.tbl_kvec = new JTable(this.Kvec, this.colNameK);
        this.tbl_kvec.setColumnSelectionAllowed(true);
        this.tbl_kvec.setRowSelectionAllowed(true);
        ExcelAdapter ea = new ExcelAdapter(this.tbl_kvec);
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setHorizontalAlignment(0);
        JTextField tf = new JTextField("");
        tf.setEnabled(false);
        tf.setBackground(Color.gray.brighter());
        DefaultCellEditor dce = new DefaultCellEditor(tf);
        this.tbl_kvec.getColumnModel().getColumn(0).setCellRenderer(dtcr);
        this.tbl_kvec.getColumnModel().getColumn(0).setCellEditor(dce);
        JScrollPane scrPane = new JScrollPane();
        scrPane.getViewport().setView(this.tbl_kvec);
        p.add(scrPane);
        return p;
    }

    private JPanel createTableSpecial() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder("symmetry points"));
        this.tbl_special = new JTable(this.rowDataSpecial, this.colNameSpecial);
        this.tbl_special.setColumnSelectionAllowed(true);
        this.tbl_special.setRowSelectionAllowed(true);
        ExcelAdapter ea = new ExcelAdapter(this.tbl_special);
        JScrollPane scrPane = new JScrollPane();
        scrPane.getViewport().setView(this.tbl_special);
        p.add(scrPane);
        return p;
    }

    private void readInput() {
        int lineCountK = 0;
        int lineCountS = 0;
        try {
            String inpLine;
            FileReader freader = new FileReader(this.fileName);
            BufferedReader breader = new BufferedReader(freader);
            while ((inpLine = breader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(inpLine);
                if (st.countTokens() == 1) {
                    this.ipdeltK.setValue(st.nextToken());
                    continue;
                }
                if (st.countTokens() == 3) {
                    this.tbl_kvec.getModel().setValueAt(st.nextToken(), lineCountK, 1);
                    this.tbl_kvec.getModel().setValueAt(st.nextToken(), lineCountK, 2);
                    this.tbl_kvec.getModel().setValueAt(st.nextToken(), lineCountK, 3);
                    ++lineCountK;
                    continue;
                }
                if (st.countTokens() < 4) continue;
                this.tbl_special.getModel().setValueAt(st.nextToken(), lineCountS, 0);
                this.tbl_special.getModel().setValueAt(st.nextToken(), lineCountS, 1);
                this.tbl_special.getModel().setValueAt(st.nextToken(), lineCountS, 2);
                this.tbl_special.getModel().setValueAt(st.nextToken(), lineCountS, 3);
                if (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    String symbol = new String();
                    if (str.startsWith("#")) {
                        while (st.hasMoreTokens()) {
                            symbol = symbol + st.nextToken();
                        }
                    }
                    this.tbl_special.getModel().setValueAt(symbol, lineCountS, 4);
                }
                ++lineCountS;
            }
        }
        catch (Exception e) {
            System.out.println("failed read from: " + this.fileName);
            e.printStackTrace();
        }
    }

    private void saveInput() {
        int lineCountS = 0;
        try {
            PrintWriter fout = new PrintWriter(new BufferedWriter(new FileWriter(this.fileName)));
            fout.println(this.ipdeltK.getValue());
            fout.println(this.tbl_kvec.getModel().getValueAt(0, 1) + " " + this.tbl_kvec.getModel().getValueAt(0, 2) + " " + this.tbl_kvec.getModel().getValueAt(0, 3));
            fout.println(this.tbl_kvec.getModel().getValueAt(1, 1) + " " + this.tbl_kvec.getModel().getValueAt(1, 2) + " " + this.tbl_kvec.getModel().getValueAt(1, 3));
            fout.println(this.tbl_kvec.getModel().getValueAt(2, 1) + " " + this.tbl_kvec.getModel().getValueAt(2, 2) + " " + this.tbl_kvec.getModel().getValueAt(2, 3));
            while ((String)this.tbl_special.getModel().getValueAt(lineCountS, 0) != null) {
                fout.println(this.tbl_special.getModel().getValueAt(lineCountS, 0) + " " + this.tbl_special.getModel().getValueAt(lineCountS, 1) + " " + this.tbl_special.getModel().getValueAt(lineCountS, 2) + " " + this.tbl_special.getModel().getValueAt(lineCountS, 3) + " # " + this.tbl_special.getModel().getValueAt(lineCountS, 4));
                ++lineCountS;
            }
            fout.close();
        }
        catch (Exception e) {
            System.out.println("failed write to: " + this.fileName);
            e.printStackTrace();
        }
    }
}

