/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.mainpanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.common.MyJMenu;
import jp.advancesoft.chase.common.MyJMenuItem;
import jp.advancesoft.chase.common.MyThread;
import jp.advancesoft.chase.common.Utils;
import jp.advancesoft.chase.graph.MainPanel;
import jp.advancesoft.chase.imageviewer.FixedImageViewer;
import jp.advancesoft.chase.imageviewer.ImageLoader;
import jp.advancesoft.chase.main.Main;
import jp.advancesoft.chase.mainpanel.Chase;
import jp.advancesoft.chase.mainpanel.Desktop;
import jp.advancesoft.chase.mainpanel.LookandFeel;
import jp.advancesoft.chase.mainpanel.ProcessMenu;
import jp.advancesoft.chase.mainpanel.WindowMenu;
import jp.advancesoft.chase.phase.PhaseFrame;
import jp.advancesoft.chase.pkg.ActivationPanel;
import jp.advancesoft.chase.process.ProcessFrame;
import jp.advancesoft.chase.process.ProcessViewer;
import jp.advancesoft.chase.project.NewProject;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import jp.advancesoft.chase.settings.PropertyManager;
import jp.advancesoft.chase.ssh.hosts.HostConfigurator;
import jp.advancesoft.chase.ssh.sftp.SftpClient;
import jp.advancesoft.chase.ssh.terminal.Terminal;
import jp.advancesoft.chase.test.materialeditor.MaterialEditor;
import jp.advancesoft.chase.textviewer.TextViewer;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class ChaseMenu
extends JMenuBar {
    private static Logger logger = Logger.getLogger(ChaseMenu.class.getName());
    private JDesktopPane desktop = Desktop.getDesktop();
    private final int NEW = 0;
    private final int OLD = 1;
    private GlobalProperties propChase = PropertiesManager.getGlobalProperties(0);
    private final String FS = System.getProperty("file.separator");
    private final String PS = System.getProperty("path.separator");
    private final String CR = System.getProperty("line.separator");
    private PropertyManager propProj;
    private Chase root;
    private LookandFeel l_and_f;
    private ProjectDirBrowser dirBrowser;

    protected ChaseMenu() {
        this.createMenu();
    }

    protected ChaseMenu(Chase root) {
        this.root = root;
        this.createMenu();
    }

    private void fileMenu() {
        MyJMenu projectmenu = new MyJMenu("Project", 80);
        MyJMenuItem newproj = new MyJMenuItem("new project", 80);
        MyJMenuItem newsubproj = new MyJMenuItem("new subproject", 83);
        MyJMenuItem remproj = new MyJMenuItem("remove project");
        MyJMenuItem remsubproj = new MyJMenuItem("remove sub project");
        MyJMenuItem exit = new MyJMenuItem("exit", 88);
        projectmenu.add(newproj);
        projectmenu.add(newsubproj);
        projectmenu.addSeparator();
        projectmenu.add(remproj);
        projectmenu.add(remsubproj);
        projectmenu.addSeparator();
        projectmenu.add(exit);
        this.add(projectmenu);
        this.dirBrowser = this.root.getProjectDirBrowser();
        newproj.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.dirBrowser.bootProjectCreator();
            }
        });
        newsubproj.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.dirBrowser.bootSubProjectCreator();
            }
        });
        remproj.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.dirBrowser.bootProjectRemover();
            }
        });
        remsubproj.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.dirBrowser.bootSubProjectRemover();
            }
        });
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.getRootFrame().exiting();
                Main.getRootFrame().dispose();
                System.exit(0);
            }
        });
    }

    private void createMenu() {
        this.l_and_f = new LookandFeel(this);
        this.fileMenu();
        MyJMenu modulemenu = new MyJMenu("Module", 77);
        MyJMenu elstrsubmenu = new MyJMenu("Electronic structure calculation", 69);
        modulemenu.add(elstrsubmenu);
        modulemenu.addSeparator();
        MyJMenu networkmenu = new MyJMenu("Network tools", 78);
        modulemenu.add(networkmenu);
        MyJMenuItem sshterminal = new MyJMenuItem("ssh terminal", 84);
        networkmenu.add(sshterminal);
        sshterminal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Terminal term = new Terminal();
                term.setVisible(true);
            }
        });
        MyJMenuItem sftpclient = new MyJMenuItem("sftp client", 70);
        networkmenu.add(sftpclient);
        sftpclient.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClient sftp = new SftpClient();
            }
        });
        MyJMenuItem networkconfig = new MyJMenuItem("configure host info", 67);
        networkmenu.add(networkconfig);
        networkconfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator configurator = new HostConfigurator();
            }
        });
        MyJMenuItem filebrowse = new MyJMenuItem("File browser", 66);
        modulemenu.add(filebrowse);
        MyJMenuItem materialEditor = new MyJMenuItem("Material editor", 77);
        modulemenu.add(materialEditor);
        materialEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MaterialEditor editor = new MaterialEditor();
                editor.setDefaultCloseOperation(3);
                editor.setBounds(10, 10, 600, 650);
                editor.setVisible(true);
            }
        });
        MyJMenu chasemenu = new MyJMenu("Analysis Tools", 65);
        modulemenu.add(chasemenu);
        this.add(modulemenu);
        MyJMenuItem mphase = new MyJMenuItem("PHASE", 80);
        mphase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.bootPhaseFrame(0, "");
            }
        });
        elstrsubmenu.add(mphase);
        MyJMenuItem macv = new MyJMenuItem("atomic configuration viewer", 65);
        macv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.bootACViewer();
            }
        });
        chasemenu.add(macv);
        MyJMenuItem mgraph = new MyJMenuItem("graph tool", 71);
        mgraph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.bootGraphTool();
            }
        });
        chasemenu.add(mgraph);
        MyJMenuItem mimageView = new MyJMenuItem("image viewer", 73);
        mimageView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.bootImageLoader();
            }
        });
        chasemenu.add(mimageView);
        MyJMenu toolmenu = new MyJMenu("External tools", 69);
        MyJMenuItem mexeeditor = new MyJMenuItem("Editor", 68);
        mexeeditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.bootEditor();
            }
        });
        toolmenu.add(mexeeditor);
        toolmenu.addSeparator();
        MyJMenuItem mexeviewer = new MyJMenuItem("BioStationViewer", 66);
        toolmenu.add(mexeviewer);
        toolmenu.addSeparator();
        mexeviewer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.bootBSV();
            }
        });
        MyJMenuItem mshell = new MyJMenuItem("shell", 83);
        toolmenu.add(mshell);
        mshell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.bootProcessFrame();
            }
        });
        this.add(toolmenu);
        MyJMenu processmenu = new MyJMenu("Process", 82);
        MyJMenuItem mprocessViewer = new MyJMenuItem("Process Viewer", 86);
        mprocessViewer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.bootProcessViewer();
            }
        });
        processmenu.add(mprocessViewer);
        ProcessMenu process = new ProcessMenu("Process", 82);
        this.add(process);
        MyJMenu prefs = new MyJMenu("Preferences", 70);
        MyJMenuItem msetappl = new MyJMenuItem("program paths", 80);
        msetappl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Utils.bootPropertyPanel();
            }
        });
        prefs.add(msetappl);
        WindowMenu window = new WindowMenu("Window(s)", 87);
        this.add(window);
        prefs.add(this.l_and_f);
        this.add(prefs);
        this.add(Box.createHorizontalGlue());
        MyJMenu helpmenu = new MyJMenu("Help", 72);
        MyJMenuItem mversion = new MyJMenuItem("Version", 86);
        mversion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseMenu.this.bootVersionDialog();
            }
        });
        helpmenu.add(mversion);
        MyJMenuItem msupportedpp = new MyJMenuItem("supported elements", 83);
        msupportedpp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FixedImageViewer fv = new FixedImageViewer(System.getProperty("chase.home") + ChaseMenu.this.FS + "lib" + ChaseMenu.this.FS + "resource" + ChaseMenu.this.FS + "pp_generated.png", "supported elements");
                fv.setVisible(true);
            }
        });
        helpmenu.add(msupportedpp);
        MyJMenuItem mmanual = new MyJMenuItem("Online manual", 77);
        mmanual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String helpPath = System.getProperty("chase.home") + ChaseMenu.this.FS + ChaseMenu.this.propChase.getProperty("htmlhelpdir") + ChaseMenu.this.FS + "index.html";
                TextViewer browser = new TextViewer(helpPath);
                browser.setVisible(true);
            }
        });
        helpmenu.add(mmanual);
        boolean activationRequired = Boolean.valueOf(this.propChase.getProperty("activationRequired"));
        if (activationRequired) {
            MyJMenuItem mactivation = new MyJMenuItem("activate product", 65);
            mactivation.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ChaseMenu.this.bootActivationPanel();
                }
            });
            helpmenu.addSeparator();
            helpmenu.add(mactivation);
        }
        this.add(helpmenu);
    }

    public void open_project(String proj) {
        String modulestr = new String();
        String[] potstr = new String[]{"", "", "", "", "", "", "", ""};
        if (!proj.endsWith(System.getProperty("file.separator"))) {
            proj = proj + System.getProperty("file.separator");
        }
        String projdir = proj.toString();
        File hanteiPhase = new File(projdir + "file_names.data");
        this.propProj = new PropertyManager(2);
        this.propProj.setProjDir(projdir);
        modulestr = this.propProj.getProperty("module");
        if (modulestr == null) {
            System.out.println("module string not found");
            modulestr = "";
        }
        if (modulestr.equalsIgnoreCase("PHASE")) {
            this.bootPhaseFrame(1, projdir);
        } else if (hanteiPhase.exists()) {
            this.bootPhaseFrame(1, projdir);
        } else {
            logger.warn("failed to open project");
            logger.warn("open: " + modulestr);
        }
    }

    protected void setUI(String str) {
        this.root.setUI(str);
    }

    private void bootProcessViewer() {
        if (!ConstParameters.osName.toLowerCase().trim().startsWith("windows")) {
            ProcessViewer psv = new ProcessViewer();
            psv.start();
            psv.setVisible(true);
        } else {
            String taskmgr = this.propChase.getProperty("taskmgr");
            MyThread myThread = new MyThread(taskmgr);
        }
    }

    private void bootActivationPanel() {
        ActivationPanel ap = new ActivationPanel();
        ap.display();
    }

    private void bootVersionDialog() {
        Document doc = Main.getDefaultPropertiesDocument();
        Element elem = doc.getRootElement().getChild("version_dialog");
        String title = elem.getChildTextTrim("title").trim();
        String message = elem.getChildTextTrim("message");
        URL advancelogo = this.getClass().getResource(elem.getChildTextTrim("imagefilepath").trim());
        ImageIcon icon = new ImageIcon(advancelogo);
        JOptionPane.showInternalMessageDialog(Desktop.getDesktop(), message, title, -1, icon);
    }

    private void bootEditor() {
        String editorPath = this.propChase.getProperty("editor");
        MyThread th = new MyThread(Utils.getPathDQ(this.propChase.getProperty("editor")));
    }

    private void bootBSV() {
        String BSVbooter = Utils.getPathDQ(ConstParameters.getJavaPath()) + " -jar ";
        BSVbooter = BSVbooter + Utils.getPathDQ(System.getProperty("chase.home") + this.FS + this.propChase.getProperty("BioStationViewer"));
        MyThread th = new MyThread(BSVbooter);
    }

    private void bootACViewer() {
    }

    private void bootGraphTool() {
        MainPanel mainPanel = new MainPanel();
        mainPanel.display();
    }

    private void bootImageLoader() {
        ImageLoader imageLoader = new ImageLoader(System.getProperty("user.home"));
        imageLoader.display();
    }

    private void bootNewProject() {
        NewProject newproj = new NewProject(this.root);
        newproj.display();
    }

    private void bootProcessFrame() {
        ProcessFrame procfrm = new ProcessFrame(this.root);
        procfrm.displayProc();
    }

    private void bootPhaseFrame(int mode, String projdir) {
        PhaseFrame phasefrm = new PhaseFrame(this.root);
        if (mode == 0) {
            phasefrm.setProjdir("");
            phasefrm.setInpFile("");
            phasefrm.display();
        } else if (mode == 1) {
            this.propProj.setProjDir(projdir);
            phasefrm.setPropertyProj(this.propProj);
            phasefrm.setProjdir(projdir);
            phasefrm.readChasePar(projdir);
            phasefrm.readFileNames(projdir);
            phasefrm.display();
        }
    }
}

