/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.imageviewer;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import jp.advancesoft.chase.common.MyMessageBox;
import jp.advancesoft.chase.imageviewer.GraphicsPanel;
import jp.advancesoft.chase.imageviewer.ImageLoader;
import jp.advancesoft.chase.imageviewer.ImagePrinter;
import jp.advancesoft.chase.mainpanel.Desktop;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;

public class MainPanel
extends InternalFrameChase {
    private Container cont;
    private JDesktopPane desktop;
    private String infile;
    private int iwidth;
    private int iheight;
    private int getaw = 100;
    private int getah = 50;
    private double scale = 1.0;
    private double rotscale = 0.0;
    private double rot = 0.0;
    private MyMessageBox mbox = new MyMessageBox();
    private boolean status = true;
    private int pageNum = 1;
    private int page = 0;
    private String[] pageArray;
    private ImageLoader loader;
    private String originalName;
    private JButton btnnextPage;
    private JButton btnprevPage;
    private BufferedImage biSave;

    public MainPanel(String infile, String originalName) {
        super(originalName, true, true, true, true);
        this.infile = infile;
        this.originalName = originalName;
        this.setResizable(true);
        this.createMainPanel();
    }

    public MainPanel(String infile) {
        super(infile, true, true, true, true);
        this.infile = infile;
        this.desktop = Desktop.getDesktop();
        this.setResizable(true);
        this.createMainPanel();
    }

    public void setInfile(String infile) {
        this.infile = infile;
    }

    public void redraw() {
        this.cont.removeAll();
        this.createMainPanel();
        this.pack();
    }

    public boolean getStatus() {
        return this.status;
    }

    public void redraw(boolean newmw) {
        this.redraw();
    }

    public void setLoader(ImageLoader loader) {
        this.loader = loader;
    }

    public void display() {
        this.setVisible(true);
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
        if (pageNum <= 1) {
            this.btnnextPage.setEnabled(false);
            this.btnprevPage.setEnabled(false);
        } else {
            this.setTitleWithPage();
        }
    }

    public void setPageArray(String[] pageArray) {
        this.pageArray = pageArray;
    }

    private void createMainPanel() {
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 0));
        this.cont.add(Box.createVerticalGlue());
        JPanel panel = this.createImagePanel();
        if (panel != null) {
            this.cont.add(panel);
        } else {
            this.mbox.setText("unsupported file type!");
            this.status = false;
        }
        this.cont.add(this.createButtonPanel());
    }

    private JPanel createImagePanel() {
        JPanel pimage = new JPanel();
        pimage.setLayout(new FlowLayout(1));
        try {
            BufferedImage bi = ImageIO.read(new File(this.infile));
            int width = bi.getWidth();
            int height = bi.getHeight();
            int irotscale = Math.abs((int)(this.rotscale / 90.0));
            AffineTransform transform = new AffineTransform();
            transform.scale(this.scale, this.scale);
            transform.rotate(Math.PI * this.rotscale / 180.0, width / 2, height / 2);
            AffineTransformOp transformOp = new AffineTransformOp(transform, 2);
            Rectangle2D rectangle = transformOp.getBounds2D(bi);
            int x = (int)rectangle.getX();
            int y = (int)rectangle.getY();
            width = (int)rectangle.getWidth();
            height = (int)rectangle.getHeight();
            transform = new AffineTransform();
            transform.rotate(Math.PI * this.rotscale / 180.0, width / 2, height / 2);
            transform.translate(-x, -y);
            transform.scale(this.scale, this.scale);
            transformOp = new AffineTransformOp(transform, 2);
            BufferedImage bit = null;
            this.biSave = bit = transformOp.filter(bi, null);
            GraphicsPanel graphicsPanel = new GraphicsPanel(bit);
            pimage.add(graphicsPanel);
            this.setMinimumSize(new Dimension(120, 350));
            int sizex = width + this.getaw < 120 ? 120 : width + this.getaw;
            int sizey = height + this.getah < 350 ? 350 : height + this.getah;
            this.setPreferredSize(new Dimension(sizex, sizey));
            this.setSize(sizex, sizey);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return pimage;
    }

    private JPanel createButtonPanel() {
        JPanel pbtn1 = new JPanel();
        pbtn1.setLayout(new BoxLayout(pbtn1, 0));
        JPanel pbtn2 = new JPanel();
        pbtn2.setLayout(new BoxLayout(pbtn2, 0));
        JPanel pbtn = new JPanel();
        int x = 100;
        int y = 30;
        int minSize = 500;
        pbtn.setLayout(new BoxLayout(pbtn, 1));
        pbtn.setPreferredSize(new Dimension(x, minSize));
        pbtn.setLayout(new FlowLayout());
        pbtn.setMinimumSize(new Dimension(x, minSize));
        pbtn.setMaximumSize(new Dimension(x, minSize));
        JButton btninitial = new JButton("initial");
        btninitial.setPreferredSize(new Dimension(x, y));
        JButton btnresizep = new JButton("   +   ");
        btnresizep.setPreferredSize(new Dimension(x, y));
        JButton btnresizem = new JButton("   -   ");
        btnresizem.setPreferredSize(new Dimension(x, y));
        JButton btnrotatep = new JButton("rot(+)");
        btnrotatep.setPreferredSize(new Dimension(x, y));
        JButton btnrotatem = new JButton("rot(-)");
        btnrotatem.setPreferredSize(new Dimension(x, y));
        this.btnprevPage = new JButton("pg up");
        this.btnprevPage.setPreferredSize(new Dimension(x, y));
        this.btnnextPage = new JButton("pg down");
        this.btnnextPage.setPreferredSize(new Dimension(x, y));
        pbtn.add(btninitial);
        pbtn.add(btnresizep);
        pbtn.add(btnresizem);
        pbtn.add(btnrotatep);
        pbtn.add(btnrotatem);
        pbtn.add(this.btnprevPage);
        pbtn.add(this.btnnextPage);
        JButton btnprint = new JButton("print");
        btnprint.setPreferredSize(new Dimension(x, y));
        JButton btnclose = new JButton("close");
        btnclose.setPreferredSize(new Dimension(x, y));
        pbtn.add(btnprint);
        pbtn.add(btnclose);
        btnprint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainPanel.this.printImage();
            }
        });
        btninitial.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainPanel.this.initializeImage();
            }
        });
        btnresizep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainPanel.this.scaleImage(0);
            }
        });
        btnresizem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainPanel.this.scaleImage(1);
            }
        });
        btnrotatep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainPanel.this.rotateImage(0);
            }
        });
        btnrotatem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainPanel.this.rotateImage(1);
            }
        });
        this.btnnextPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainPanel.this.page++;
                if (MainPanel.this.page > MainPanel.this.pageNum - 1) {
                    MainPanel.this.page = 0;
                }
                try {
                    MainPanel.this.infile = MainPanel.this.pageArray[MainPanel.this.page];
                    MainPanel.this.setTitleWithPage();
                    MainPanel.this.redraw();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.btnprevPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainPanel.this.page--;
                if (MainPanel.this.page < 0) {
                    MainPanel.this.page = MainPanel.this.pageNum - 1;
                }
                try {
                    MainPanel.this.infile = MainPanel.this.pageArray[MainPanel.this.page];
                    MainPanel.this.setTitleWithPage();
                    MainPanel.this.redraw();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainPanel.this.dispose();
            }
        });
        return pbtn;
    }

    private void printImage() {
        BufferedImage image = null;
        try {
            image = this.biSave;
            ImagePrinter ip = new ImagePrinter(image);
            ip.printImage();
        }
        catch (Exception exception) {
            this.mbox.setText("failed Print");
            exception.printStackTrace();
        }
    }

    private void scaleImage(int magormin) {
        this.scale = magormin == 0 ? (this.scale *= 1.1) : (this.scale /= 1.1);
        this.redraw();
    }

    private void rotateImage(int plusorminus) {
        this.rotscale = plusorminus == 0 ? (this.rotscale += 90.0) : (this.rotscale -= 90.0);
        if (this.rotscale >= 360.0) {
            this.rotscale -= 360.0;
        } else if (this.rotscale <= -360.0) {
            this.rotscale += 360.0;
        }
        this.redraw();
    }

    private void initializeImage() {
        this.scale = 1.0;
        this.rotscale = 0.0;
        this.redraw();
    }

    private void setTitleWithPage() {
        int pageDisplay = this.page + 1;
        super.setTitle(this.originalName + ", page " + pageDisplay + "/" + this.pageNum);
    }

    private final class MyListener
    extends WindowAdapter {
        private MyListener() {
        }

        public void windowClosing(WindowEvent event) {
            MainPanel.this.dispose();
        }
    }
}

