/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.common;

import java.util.StringTokenizer;
import jp.advancesoft.chase.common.OutputParser;

public class NfdynmParser
extends OutputParser {
    private int numColumns;
    private int numRows;
    private String SHARP = "#";
    private String iter_ion_str = new String();
    private String iter_total_str = new String();

    public NfdynmParser(String filename) {
        super(filename);
        this.setNumColumns(9);
    }

    public void parseString(String str) {
        StringTokenizer st = new StringTokenizer(str);
        String strdata = new String();
        boolean bloopisData = false;
        boolean bColumnName = true;
        if (str.trim().startsWith(this.SHARP)) {
            this.addHeader(str);
            this.addHeader(OutputParser.CR);
            bloopisData = false;
        } else if (str.trim().startsWith("cps")) {
            while (st.hasMoreTokens()) {
                strdata = st.nextToken();
                if (strdata.trim().startsWith("(") && bColumnName) {
                    this.addColumnName("iter_ion");
                    this.addColumnName("iter_total");
                    this.addColumnName("atom_label");
                    this.addColumnName("pos(x)");
                    this.addColumnName("pos(y)");
                    this.addColumnName("pos(z)");
                    this.addColumnName("forc(x)");
                    this.addColumnName("forc(y)");
                    this.addColumnName("forc(z)");
                    bColumnName = false;
                    continue;
                }
                if (!strdata.trim().startsWith("=")) continue;
                this.iter_ion_str = st.nextToken().trim();
                this.iter_total_str = st.nextToken().trim();
            }
            bloopisData = false;
        } else {
            this.addDataColumn(this.iter_ion_str);
            this.addDataColumn(this.iter_total_str);
            while (st.hasMoreTokens()) {
                strdata = st.nextToken();
                this.addDataColumn(strdata);
            }
            bloopisData = true;
        }
        if (bloopisData) {
            this.addDataRow();
        }
    }
}

