/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.atomcoord;

import java.io.File;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.atomcoord.CIFImporter;
import jp.advancesoft.chase.atomcoord.ImporterBase;
import jp.advancesoft.chase.atomcoord.XYZImporter;
import org.apache.log4j.Logger;

class Importer
extends ImporterBase {
    private static Logger logger = Logger.getLogger(Importer.class.getName());

    protected Importer(File file, AtomCoords coords) {
        super(file, coords);
        this.coords = coords;
    }

    public boolean importAtomCoords() {
        int fileType = super.getFileType();
        if (fileType == 2) {
            XYZImporter xyz = new XYZImporter(this.file, this.coords);
            return xyz.importAtomCoords();
        }
        if (fileType == 1) {
            CIFImporter cif = new CIFImporter(this.file, this.coords);
            return cif.importAtomCoords();
        }
        logger.warn("unsupported filetype");
        return false;
    }

    public boolean importCell() {
        boolean ret = true;
        return ret;
    }
}

