/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.scenegraphelements;

import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.picking.behaviors.PickMouseBehavior;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import jp.advancesoft.chase.acviewer.MainPanel;
import jp.advancesoft.chase.acviewer.scenegraphelements.ACVAtomEditor;
import jp.advancesoft.chase.acviewer.scenegraphelements.ACVMultipleAtomEditor;
import jp.advancesoft.chase.acviewer.scenegraphelements.Atom;
import jp.advancesoft.chase.acviewer.scenegraphelements.AtomObject;
import jp.advancesoft.chase.acviewer.scenegraphelements.Selectable;
import jp.advancesoft.chase.acviewer.scenegraphelements.TGAtom;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.atomcoord.AtomEvent;
import jp.advancesoft.chase.atomcoord.AtomListener;
import org.apache.log4j.Logger;

public class AtomPicker
extends PickMouseBehavior
implements AtomListener {
    private static Logger logger = Logger.getLogger(AtomPicker.class.getName());
    private Atom atom;
    private AtomObject atomObject;
    private WakeupCriterion[] mouseEvents;
    private WakeupOr mouseCriterion;
    private PickTool picker;
    int pickMode = 512;
    private Canvas3D canvas;
    private TransformGroup parent;
    private boolean button1Press = false;

    public AtomPicker(Canvas3D canvas, BranchGroup root, Bounds bounds, Atom atom) {
        super(canvas, root, bounds);
        this.atom = atom;
        this.atomObject = atom.getAtomObject();
        this.setSchedulingBounds(bounds);
        this.pickCanvas.setMode(512);
        this.canvas = canvas;
    }

    public AtomPicker(Canvas3D canvas, BranchGroup root, Bounds bounds) {
        super(canvas, root, bounds);
        this.setSchedulingBounds(bounds);
        this.pickCanvas.setMode(512);
        this.canvas = canvas;
    }

    public void processStimulus(Enumeration criteria) {
        AWTEvent[] evt = null;
        int xpos = 0;
        int ypos = 0;
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            evt = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
        }
        if (evt == null) {
            return;
        }
        if (evt[0] instanceof MouseEvent) {
            this.mevent = (MouseEvent)evt[0];
            this.processMouseEvent((MouseEvent)evt[0]);
            xpos = this.mevent.getPoint().x;
            ypos = this.mevent.getPoint().y;
        }
        if (this.buttonPress && !this.update(xpos, ypos)) {
            ((Selectable)this.parent).deselectAll();
        }
        if (this.button1Press) {
            this.bootAtomAtributeEditPanel(xpos, ypos);
        }
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    private void processMouseEvent(MouseEvent evt) {
        this.buttonPress = false;
        this.button1Press = false;
        if (evt.getButton() == 2) {
            if (evt.getID() == 501 || evt.getID() == 500) {
                this.buttonPress = true;
                return;
            }
            if (evt.getID() == 503) {
                this.buttonPress = true;
                return;
            }
        } else if (evt.getButton() == 1) {
            this.button1Press = true;
            return;
        }
    }

    public void updateScene(int xpos, int ypos) {
    }

    private boolean update(int xpos, int ypos) {
        this.pickCanvas.setShapeLocation(xpos, ypos);
        PickResult[] result = this.pickCanvas.pickAllSorted();
        if (result == null) {
            logger.debug("AtomPicker returned null.");
            return false;
        }
        for (int i = 0; i < result.length; ++i) {
            Primitive pri = (Primitive)result[i].getNode(4);
            if (pri == null || !(pri instanceof Atom)) continue;
            AtomObject obj = ((Atom)pri).getAtomObject();
            obj.toggleSelected();
            logger.debug(obj);
            return true;
        }
        return false;
    }

    private void bootAtomAtributeEditPanel(int xpos, int ypos) {
        this.pickCanvas.setShapeLocation(xpos, ypos);
        PickResult[] result = this.pickCanvas.pickAllSorted();
        if (result == null) {
            logger.debug("AtomPicker returned null.");
            return;
        }
        int numSelected = ((TGAtom)this.parent).getSelectedAtomCount();
        for (int i = 0; i < result.length; ++i) {
            AtomObject obj;
            Primitive pri = (Primitive)result[i].getNode(4);
            if (pri == null || !(pri instanceof Atom) || !(obj = ((Atom)pri).getAtomObject()).isSelected()) continue;
            if (numSelected == 1) {
                logger.debug("booting atom atribute edit panel ...");
                this.bootAtomEditor(Integer.parseInt(obj.getID()));
                continue;
            }
            if (numSelected <= 1) continue;
            ACVMultipleAtomEditor edi = new ACVMultipleAtomEditor(((TGAtom)this.parent).getParentFrame());
            ((TGAtom)this.parent).getParentFrame().addDisposeOnExit(edi);
            return;
        }
    }

    private void bootAtomEditor(int id) {
        TGAtom tgatom = (TGAtom)this.parent;
        MainPanel mp = tgatom.getParentFrame();
        jp.advancesoft.chase.atomcoord.Atom atom = mp.getCD().getAtomCoords().getAtomList().getAtomAt(id - 1);
        logger.debug(atom);
        ACVAtomEditor editor = new ACVAtomEditor(mp.getData().getTableColums(), atom, false, id - 1, "edit attributes for atom no. " + new Integer(id), new Dimension(400, 250), 3, mp);
        editor.addAtomListener(this);
        mp.addDisposeOnExit(editor);
    }

    public void atomStateChanged(AtomEvent e) {
        jp.advancesoft.chase.atomcoord.Atom atom = e.getAtom();
        int ind = e.getIndex();
        MainPanel mp = ((TGAtom)this.parent).getParentFrame();
        AtomCoords coords = mp.getCD().getAtomCoords();
        if (ind < 0) {
            try {
                ind = coords.getAtomList().size();
            }
            catch (Exception exc) {
                logger.error("atom coords not allocated?");
            }
        }
        logger.debug("atom now: " + coords.getAtomList().getAtomAt(ind));
        coords.replaceAtomAt(ind, atom);
        logger.debug("AtomStateChanged: " + e);
        mp.getCD().setCoords(coords);
        logger.debug(coords);
    }

    public void setParent(TransformGroup parent) {
        this.parent = parent;
    }
}

