/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.share.object;

import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.share.ShareObject;

public abstract class ShareNode
extends ShareObject {
    private transient Node mNode;
    private transient String mNodeName;
    private transient String mParentNodeName;
    private transient boolean mIsParentNodeRootNode;

    public ShareNode() {
        this.setNode(null);
        this.setParentNodeName(null);
        this.setParentNodeRootNodeFlag(false);
    }

    public ShareNode(Node node) {
        this();
        this.setNode(node);
    }

    public void setNode(Node node) {
        this.mNode = node;
        if (node != null) {
            String nodeName = node.getName();
            this.setNodeName(nodeName);
            Node parentNode = node.getParentNode();
            if (parentNode != null) {
                if (parentNode.isRootNode()) {
                    this.setParentNodeRootNodeFlag(true);
                }
                String parentNodeName = parentNode.getName();
                this.setParentNodeName(parentNodeName);
            }
        }
    }

    public Node getNode() {
        return this.mNode;
    }

    public void setNodeName(String name) {
        this.mNodeName = name;
    }

    public String getNodeName() {
        if (this.mNodeName == null) {
            return "";
        }
        return this.mNodeName;
    }

    public void setParentNodeName(String name) {
        this.mParentNodeName = name;
    }

    public String getParentNodeName() {
        if (this.mParentNodeName == null) {
            return "";
        }
        return this.mParentNodeName;
    }

    public void setParentNodeRootNodeFlag(boolean flag) {
        this.mIsParentNodeRootNode = flag;
    }

    public boolean isParentNodeRootNode() {
        return this.mIsParentNodeRootNode;
    }
}

