/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.parser.vrml97;

import java.io.IOException;
import java.io.InputStream;

public class VRML97ProtoStream
extends InputStream {
    protected StringBuffer mTokenBuffer = new StringBuffer();
    private int mPos;

    public VRML97ProtoStream() {
        this.rewind();
    }

    public void addToken(String token) {
        this.mTokenBuffer.append(token);
        if (token.compareTo("\n") != 0) {
            this.mTokenBuffer.append(' ');
        }
    }

    public void addToken(double token) {
        this.mTokenBuffer.append(token);
        this.mTokenBuffer.append(' ');
    }

    public String getTokenBuffer() {
        return this.mTokenBuffer.toString();
    }

    public int getTokenBufferLength() {
        return this.mTokenBuffer.toString().length();
    }

    public void setTokenBufferPos(int pos) {
        this.mPos = pos;
    }

    public int getTokenBufferPos() {
        return this.mPos;
    }

    public void rewind() {
        this.setTokenBufferPos(0);
    }

    public int read() throws IOException {
        int pos = this.getTokenBufferPos();
        int c2 = -1;
        if (pos < this.getTokenBufferLength()) {
            c2 = this.getTokenBuffer().charAt(pos);
            this.setTokenBufferPos(pos + 1);
        }
        return c2;
    }

    public int available() throws IOException {
        return this.getTokenBufferLength() - this.getTokenBufferPos();
    }

    public void close() throws IOException {
        this.rewind();
    }
}

