/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.BranchGroup;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.j3d.GroupNodeObject;
import org.cybergarage.x3d.j3d.SceneGraphJ3dObject;
import org.cybergarage.x3d.node.InlineNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.util.Debug;

public class InlineNodeObject
extends GroupNodeObject
implements NodeObject {
    public InlineNodeObject(InlineNode node) {
        this.initialize(node);
    }

    public boolean initialize(Node node) {
        URL baseURL;
        Debug.message("InlineNodeObject.initialize");
        this.removeAllChildren();
        SceneGraph sg = node.getSceneGraph();
        if (sg == null) {
            return false;
        }
        SceneGraphJ3dObject sgObject = (SceneGraphJ3dObject)sg.getObject();
        if (sgObject == null) {
            return false;
        }
        InlineNode inlineNode = (InlineNode)node;
        if (inlineNode.getNURLs() <= 0) {
            return false;
        }
        String urlName = inlineNode.getURL(0);
        if (urlName == null) {
            return true;
        }
        SceneGraph sgLoad = new SceneGraph();
        SceneGraphJ3dObject sgObjectLoad = new SceneGraphJ3dObject(sgLoad);
        sgLoad.setObject(sgObjectLoad);
        if (!sgLoad.load(urlName) && (baseURL = sg.getBaseURL()) != null) {
            try {
                if (!sgLoad.load(new URL(baseURL.toString() + urlName))) {
                    Debug.message("\tLoading is Bad !!");
                    return false;
                }
            }
            catch (MalformedURLException mue) {
                return false;
            }
        }
        Debug.message("\tLoading is OK !!");
        sgLoad.initialize();
        inlineNode.setBoundingBoxCenter(sgLoad.getBoundingBoxCenter());
        inlineNode.setBoundingBoxSize(sgLoad.getBoundingBoxSize());
        int nLoadNodes = sgLoad.getNNodes();
        Debug.message("\tLoadNodes = " + nLoadNodes);
        if (nLoadNodes <= 0) {
            return true;
        }
        BranchGroup branchGroup = sgObjectLoad.getBranchGroup();
        Debug.message("\taddChild = " + branchGroup);
        this.addChild((javax.media.j3d.Node)branchGroup);
        return true;
    }

    public boolean uninitialize(Node node) {
        return true;
    }

    public boolean update(Node node) {
        return true;
    }
}

