/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.settings;

import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ExternalProgramSelector
extends InternalFrameChase {
    private Logger logger = Logger.getLogger(ExternalProgramSelector.class.getName());
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
    private Vector pathSelectors = new Vector();

    public ExternalProgramSelector() {
        super("edit external program path", true, true, true, true, new Dimension(300, 180));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createPanelExternal(), "North");
        this.getContentPane().add((Component)this.buttons(), "South");
    }

    private JPanel createPanelExternal() {
        JPanel pext = new JPanel();
        pext.setLayout(new BoxLayout(pext, 1));
        String editor = this.gp.getProperty("editor");
        String gs = this.gp.getProperty("gs");
        String os = System.getProperty("os.name").toLowerCase();
        if (editor == null || editor.trim().length() == 0) {
            editor = os.startsWith("windows") ? "NOTEPAD" : "emacs";
        }
        if (gs == null || gs.trim().length() == 0) {
            gs = this.getGSPath(os);
        }
        pext.add(new PathSelector(editor, "external editor", new PathSelectorAction(){

            void doIt(String text) {
                if (text != null && text.trim().length() != 0) {
                    ExternalProgramSelector.this.gp.setProperty("editor", text);
                    ExternalProgramSelector.this.gp.storeProperty();
                }
            }
        }, false));
        pext.add(new PathSelector(gs, "ghostscript", new PathSelectorAction(){

            void doIt(String text) {
                if (text != null && text.trim().length() != 0) {
                    ExternalProgramSelector.this.gp.setProperty("gs", text);
                    ExternalProgramSelector.this.gp.storeProperty();
                }
            }
        }, false));
        return pext;
    }

    private JPanel buttons() {
        JPanel pbtn = new JPanel();
        pbtn.setLayout(new BoxLayout(pbtn, 0));
        JButton ok = new JButton("ok");
        JButton cancel = new JButton("cancel");
        pbtn.add(ok);
        pbtn.add(cancel);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                for (int i = 0; i < ExternalProgramSelector.this.pathSelectors.size(); ++i) {
                    PathSelector selector = (PathSelector)ExternalProgramSelector.this.pathSelectors.get(i);
                    selector.doAction();
                }
                ExternalProgramSelector.this.dispose();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ExternalProgramSelector.this.dispose();
            }
        });
        JPanel p = new JPanel();
        p.add(pbtn);
        return p;
    }

    private String getGSPath(String os) {
        if (!os.startsWith("windows")) {
            return "gs";
        }
        File[] root = File.listRoots();
        for (int i = 0; i < root.length; ++i) {
            File[] gssubdir;
            File[] gsdir;
            File[] foo = root[i].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("program files");
                }
            });
            if (foo == null || foo.length == 0 || (gsdir = foo[0].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("gs");
                }
            })) == null || gsdir.length == 0 || (gssubdir = gsdir[0].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("gs");
                }
            })) == null || gsdir.length == 0) continue;
            return gssubdir[gssubdir.length - 1] + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "gswin32c.exe";
        }
        return "";
    }

    abstract class PathSelectorAction {
        PathSelectorAction() {
        }

        abstract void doIt(String var1);
    }

    class PathSelector
    extends JPanel {
        private JTextField textField = new JTextField(30);
        private JButton jButton = new JButton("choose...");
        private PathSelectorAction action;
        private boolean dir = true;
        private String title;
        private String initPath;
        private JPanel panel;

        PathSelector(String initPath, String title, PathSelectorAction action, boolean dir) {
            this.dir = dir;
            this.initPath = initPath;
            this.title = title;
            this.action = action;
            this.panel = this;
            this.init();
        }

        PathSelector(String initPath, String title, PathSelectorAction action) {
            this.action = action;
            this.initPath = initPath;
            this.title = title;
            this.panel = this;
            this.init();
        }

        private void init() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(new TitledBorder(this.title));
            this.textField.setText(this.initPath);
            this.add(this.textField);
            this.add(this.jButton);
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogType(0);
                    if (PathSelector.this.dir) {
                        chooser.setFileSelectionMode(1);
                    } else {
                        chooser.setFileSelectionMode(0);
                    }
                    if (chooser.showDialog(PathSelector.this.panel, "open") != 0) {
                        return;
                    }
                    PathSelector.this.textField.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            });
            ExternalProgramSelector.this.pathSelectors.addElement(this);
        }

        void doAction() {
            this.action.doIt(this.textField.getText());
        }
    }
}

