/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.movie;

import ciss.phase_viewer.mainpanel.FrameChase;
import ciss.phase_viewer.movie.MovieUtils;
import ciss.phase_viewer.movie.MovieViewerMenuBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import org.apache.log4j.Logger;

public class MovieViewer
extends FrameChase
implements ControllerListener {
    private static Logger logger = Logger.getLogger(MovieViewer.class.getName());
    private Player player = null;
    private String fileName;
    private Container cont;
    private MediaLocator oml;

    public MovieViewer(String fileName) {
        super(fileName, new Dimension(500, 500));
        this.setVisible(true);
        this.fileName = fileName;
        this.init();
    }

    public void init() {
        this.cont = this.getContentPane();
        this.cont.setLayout(new BorderLayout());
        this.setJMenuBar(new MovieViewerMenuBar(this));
        this.setMovieFile(this.fileName);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                MovieViewer.this.exi();
            }
        });
    }

    private void exi() {
        logger.info("movie viewer closed.");
        this.player.stop();
        this.player.removeControllerListener(this);
        this.player.close();
        this.player = null;
        this.oml = null;
    }

    protected void stopAllAnimations() {
        this.player.stop();
    }

    public void setMovieFile(String movieFile) {
        try {
            this.player = null;
            this.oml = MovieUtils.createMediaLocator(movieFile);
            if (this.oml == null) {
                logger.error("failed to obtain media locator from: " + this.fileName);
                return;
            }
            this.player = Manager.createPlayer(this.oml);
            this.player.addControllerListener(this);
        }
        catch (Exception e) {
            logger.warn("failed to set player");
        }
        super.setTitle(movieFile);
        this.cont.validate();
        this.player.start();
    }

    public void controllerUpdate(ControllerEvent event) {
        logger.debug("updating controller ...");
        if (event instanceof RealizeCompleteEvent) {
            Component comp = this.player.getVisualComponent();
            if (comp != null) {
                this.cont.add("Center", comp);
            }
            if ((comp = this.player.getControlPanelComponent()) != null) {
                this.cont.add("South", comp);
            }
            this.cont.validate();
        }
    }
}

