/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph.dataset;

import ciss.phase_viewer.graph.dataset.PlotProperties;
import ciss.phase_viewer.graph.dataset.SubPlotProperties;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class PlotPropertiesEditor
extends InternalFrameChase {
    private Logger logger = Logger.getLogger(PlotPropertiesEditor.class.getName());
    private PlotProperties props;
    private JTextField gap;
    private JTextField weight;
    private JComboBox orientation;
    private String[] orientationChoice = new String[]{"share domain axis", "share range axis"};
    private int index;

    public PlotPropertiesEditor(String title, PlotProperties props, int index) {
        super("combined plot properties for " + title, true, true, true, true, new Dimension(300, 130));
        this.props = props;
        this.index = index;
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.gap = new JTextField(6);
        this.gap.setText(String.valueOf(this.props.getGap()));
        JPanel pgap = new JPanel();
        pgap.setBorder(new TitledBorder("gap"));
        pgap.add(this.gap);
        panel.add(pgap);
        this.weight = new JTextField(6);
        SubPlotProperties spp = this.props.getSubPlotPropertiesAt(this.index);
        if (spp != null) {
            this.weight.setText(String.valueOf(spp.getWeight()));
        }
        JPanel pweight = new JPanel();
        pweight.setBorder(new TitledBorder("weight"));
        pweight.add(this.weight);
        panel.add(pweight);
        this.orientation = new JComboBox<String>(this.orientationChoice);
        if (this.props.getPlotOrientation() == 0) {
            this.orientation.setSelectedIndex(0);
        } else {
            this.orientation.setSelectedIndex(1);
        }
        JPanel porien = new JPanel();
        porien.setBorder(new TitledBorder("axis"));
        porien.add(this.orientation);
        panel.add(porien);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        JButton btnok = new JButton("ok");
        JButton btncan = new JButton("cancel");
        buttons.add(btnok);
        buttons.add(btncan);
        this.getContentPane().add((Component)panel, "North");
        this.getContentPane().add((Component)buttons, "South");
        btncan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotPropertiesEditor.this.dispose();
            }
        });
        btnok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotPropertiesEditor.this.save();
                PlotPropertiesEditor.this.dispose();
            }
        });
    }

    private void save() {
        try {
            int wi = Integer.parseInt(this.weight.getText());
            double ga = Double.parseDouble(this.gap.getText());
            int scheme = this.orientation.getSelectedIndex() == 0 ? 0 : 1;
            this.props.setGap(ga);
            this.props.setPlotOrientation(scheme);
            this.props.getSubPlotPropertiesAt(this.index).setWeight(wi);
        }
        catch (Exception exc) {
            this.logger.error("invalid value found.");
        }
    }
}

