/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.pmodel;

import ciss.phase_viewer.atomcoord.pmodel.Atom;
import ciss.phase_viewer.atomcoord.pmodel.PmodelException;
import ciss.phase_viewer.atomcoord.pmodel.PmodelRuntimeException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Cif {
    private static final String DELIMITER = " \t\n\r#";
    private static final boolean DEBUG = false;
    private static final String[] tag_cell_length = new String[]{"length_a", "length_b", "length_c"};
    private static final String[] tag_cell_angle = new String[]{"angle_alpha", "angle_beta", "angle_gamma"};
    private static final String[] tag_atom_site = new String[]{"fract_x", "fract_y", "fract_z", "label", "type_symbol"};
    private static final String[] tag_ignore_loop = new String[]{"_publ_author_name", "_atom_site_aniso_label"};
    private int sgn = -1;
    private CrystalSystem crystalSystem = CrystalSystem.UNDEFINED;
    private String HM = "UNDEFINED";
    private double[] cellLength = new double[3];
    private double[] cellAngle = new double[3];
    ArrayList<Atom> atomList = new ArrayList();
    ArrayList<String> symmetryEquivPos = new ArrayList();

    Cif() {
    }

    int getIntTablesNum() {
        return this.sgn;
    }

    String getHermannMauguin() {
        return this.HM;
    }

    double[] getCellLength() {
        double[] length = new double[3];
        for (int i = 0; i < 3; ++i) {
            length[i] = this.cellLength[i];
        }
        return length;
    }

    double[] getCellAngle() {
        double[] angle = new double[3];
        for (int i = 0; i < 3; ++i) {
            angle[i] = this.cellAngle[i];
        }
        return angle;
    }

    int getNumberOfAtom() {
        return this.atomList.size();
    }

    Atom getAtom(int n) {
        return this.atomList.get(n);
    }

    public static void main(String[] args) {
        int i;
        if (args.length != 1) {
            System.out.println("Usage: java CIF CIF_file_name");
            System.exit(1);
        }
        Cif pCIF = new Cif();
        int ndb = -999;
        String fileName = args[0];
        System.out.println("CIF file name: " + fileName);
        try {
            ndb = Cif.getMultiplicity(fileName);
            if (ndb == 0) {
                System.out.println("Warning : No 'data_' tag found.");
                System.out.println("Read the CIF file forcibly.");
            } else if (ndb != 1) {
                System.out.println("Number of data block in the CIF: " + ndb);
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String str = br.readLine();
                ndb = Integer.parseInt(str);
                System.out.println("Selected: " + ndb);
            }
            pCIF.read(fileName, ndb);
            pCIF.check();
        }
        catch (PmodelException ex) {
            System.out.println("ERROR!!!");
            ex.printStackTrace();
            System.exit(1);
        }
        catch (IOException ex) {
            System.out.println("ERROR!!!");
            ex.printStackTrace();
            System.exit(1);
        }
        System.out.println("Summary:");
        System.out.println("Data Block: " + ndb);
        System.out.println("Cell System: " + (Object)((Object)pCIF.crystalSystem));
        System.out.println("Symmetry info.");
        System.out.println(pCIF.HM + "\t" + pCIF.sgn);
        System.out.println("Length:");
        for (i = 0; i < 3; ++i) {
            System.out.println(pCIF.cellLength[i]);
        }
        System.out.println("Angle:");
        for (i = 0; i < 3; ++i) {
            System.out.println(pCIF.cellAngle[i]);
        }
        System.out.println("Atom(s): " + pCIF.atomList.size());
        for (i = 0; i < pCIF.atomList.size(); ++i) {
            System.out.println(pCIF.atomList.get(i));
        }
        System.out.println("Symmetry operation(s): " + pCIF.symmetryEquivPos.size());
        for (i = 0; i < pCIF.symmetryEquivPos.size(); ++i) {
            System.out.println(pCIF.symmetryEquivPos.get(i));
        }
    }

    static int getMultiplicity(String fileName) throws PmodelException {
        return Cif.getDataBlockTitle(fileName).length;
    }

    public static String[] getDataBlockTitle(String fileName) throws PmodelException {
        ArrayList<String> titles = new ArrayList<String>(1);
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() < 5 || !line.substring(0, 5).equalsIgnoreCase("data_")) continue;
                titles.add(line);
            }
            br.close();
        }
        catch (IOException e) {
            PmodelException ex = new PmodelException();
            ex.message = "Cannot read the CIF file.";
            throw ex;
        }
        return titles.toArray(new String[0]);
    }

    void read(String fileName) throws PmodelException {
        this.read(fileName, 1);
    }

    void read(String fileName, int ndb) throws PmodelException {
        if (Cif.getMultiplicity(fileName) < ndb) {
            PmodelException ex = new PmodelException();
            throw ex;
        }
        ArrayList<String> al = new ArrayList<String>(512);
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            boolean insideText = false;
            while ((line = br.readLine()) != null) {
                StringBuffer sb;
                if ((line = line.trim()).length() >= 5 && line.substring(0, 5).equalsIgnoreCase("data_")) {
                    --ndb;
                }
                if ((sb = new StringBuffer(line)).length() == 0 || sb.charAt(0) == '#') continue;
                if (sb.charAt(0) == ';') {
                    if (insideText) {
                        // empty if block
                    }
                    insideText = !insideText;
                    continue;
                }
                if (insideText || ndb != 0) continue;
                al.add(line);
            }
            br.close();
        }
        catch (IOException e) {
            PmodelException ex = new PmodelException();
            ex.message = "Cannot read the CIF file.";
            throw ex;
        }
        int count = -1;
        block3: while (++count < al.size()) {
            int i;
            String line = (String)al.get(count);
            StringTokenizer st = new StringTokenizer(line, DELIMITER);
            String str = st.nextToken();
            if (str.equalsIgnoreCase("loop_")) {
                count = this.loopExpanderDriver(al, count);
                continue;
            }
            if (str.equalsIgnoreCase("_symmetry_int_tables_number") || str.equalsIgnoreCase("_space_group_IT_number")) {
                str = st.nextToken();
                this.sgn = Integer.parseInt(str);
                continue;
            }
            if (str.equalsIgnoreCase("_symmetry_cell_setting")) {
                str = st.nextToken();
                this.setCrystalSystem(str);
                continue;
            }
            if (str.equalsIgnoreCase("_symmetry_space_group_name_H-M")) {
                this.setHermannMauguin(line);
                continue;
            }
            for (i = 0; i < 3; ++i) {
                if (!str.equalsIgnoreCase("_cell_" + tag_cell_length[i])) continue;
                str = st.nextToken();
                this.cellLength[i] = this.toDoubleIgnoreESD(str);
                continue block3;
            }
            for (i = 0; i < 3; ++i) {
                if (!str.equalsIgnoreCase("_cell_" + tag_cell_angle[i])) continue;
                str = st.nextToken();
                this.cellAngle[i] = this.toDoubleIgnoreESD(str);
                continue block3;
            }
        }
    }

    private int loopExpanderDriver(ArrayList al, int count) throws PmodelException {
        switch (this.loopExpanderGetType(al, count)) {
            case ATOM: {
                count = this.loopExpanderAtom(al, count);
                break;
            }
            case OPERATOR: {
                count = this.loopExpanderSymOpe(al, count);
                break;
            }
            case UNDEFINED: {
                count = this.loopExpanderUnDef(al, count);
                break;
            }
            default: {
                PmodelRuntimeException ex = new PmodelRuntimeException();
                throw ex;
            }
        }
        return count;
    }

    private LoopType loopExpanderGetType(ArrayList al, int count) {
        while (++count < al.size()) {
            String line = (String)al.get(count);
            StringTokenizer st = new StringTokenizer(line, DELIMITER);
            String str = st.nextToken();
            if (str.charAt(0) != '_') {
                return LoopType.UNDEFINED;
            }
            for (int i = 3; i < 5; ++i) {
                if (!str.equalsIgnoreCase("_atom_site_" + tag_atom_site[i])) continue;
                return LoopType.ATOM;
            }
            if (str.equalsIgnoreCase("_symmetry_equiv_pos_as_xyz") || str.equalsIgnoreCase("_space_group_symop_operation_xyz")) {
                return LoopType.OPERATOR;
            }
            if (!str.equalsIgnoreCase("_publ_author_name") && !str.equalsIgnoreCase("_atom_site_aniso_label")) continue;
            return LoopType.UNDEFINED;
        }
        return LoopType.UNDEFINED;
    }

    private int loopExpanderAtom(ArrayList al, int count) throws PmodelException {
        String line;
        StringTokenizer st;
        String str;
        int[] atomSymbol = new int[]{-1, -1};
        int[] atomFract = new int[]{-1, -1, -1};
        int numDataName = 0;
        while (++count < al.size() && (str = (st = new StringTokenizer(line = (String)al.get(count), DELIMITER)).nextToken()).charAt(0) == '_') {
            int i;
            for (i = 0; i < tag_atom_site.length && !str.equalsIgnoreCase("_atom_site_" + tag_atom_site[i]); ++i) {
            }
            switch (i) {
                case 0: 
                case 1: 
                case 2: {
                    atomFract[i] = numDataName;
                    break;
                }
                case 3: 
                case 4: {
                    atomSymbol[i - 3] = numDataName;
                    break;
                }
            }
            ++numDataName;
        }
        --count;
        if (atomSymbol[0] == -1) {
            atomSymbol[0] = atomSymbol[1];
        } else if (atomSymbol[1] == -1) {
            atomSymbol[1] = atomSymbol[0];
        }
        if (atomFract[0] == -1) {
            PmodelException ex = new PmodelException();
            ex.message = "Element symbol is not specified.";
            throw ex;
        }
        String[] data = new String[numDataName];
        while (++count < al.size() && !(line = (String)al.get(count)).equalsIgnoreCase("loop_") && line.charAt(0) != '_') {
            StringTokenizer st2 = new StringTokenizer(line, DELIMITER);
            for (int i = 0; i < numDataName; ++i) {
                while (!st2.hasMoreTokens()) {
                    if (++count < al.size()) {
                        line = (String)al.get(count);
                        st2 = new StringTokenizer(line, DELIMITER);
                        continue;
                    }
                    PmodelException ex = new PmodelException();
                    ex.message = "unsupported format (atomic position).";
                    throw ex;
                }
                data[i] = st2.nextToken();
            }
            String symbol = data[atomSymbol[0]];
            String alias = data[atomSymbol[1]];
            double[] position = new double[3];
            for (int i = 0; i < 3; ++i) {
                position[i] = this.toDoubleIgnoreESD(data[atomFract[i]]);
            }
            this.atomList.add(new Atom(symbol, alias, position));
        }
        return --count;
    }

    private int loopExpanderSymOpe(ArrayList al, int count) throws PmodelException {
        String line;
        StringTokenizer st;
        String str;
        int symOpe = -1;
        int numDataName = 0;
        while (++count < al.size() && (str = (st = new StringTokenizer(line = (String)al.get(count), DELIMITER)).nextToken()).charAt(0) == '_') {
            if (str.equalsIgnoreCase("_symmetry_equiv_pos_as_xyz") || str.equalsIgnoreCase("_space_group_symop_operation_xyz")) {
                symOpe = numDataName;
            }
            ++numDataName;
        }
        --count;
        String[] data = new String[numDataName];
        while (++count < al.size() && !(line = (String)al.get(count)).equalsIgnoreCase("loop_") && line.charAt(0) != '_') {
            int start = line.indexOf("'");
            int end2 = line.lastIndexOf("'");
            if (start != -1) {
                str = line.substring(start + 1, end2);
            } else if (symOpe == 0) {
                str = line;
            } else if (numDataName > 1) {
                StringTokenizer st2 = new StringTokenizer(line, DELIMITER);
                for (int i = 0; i < numDataName; ++i) {
                    data[i] = st2.nextToken();
                }
                str = data[symOpe];
            } else {
                PmodelException ex = new PmodelException();
                ex.message = "unsupported symmetry format.";
                throw ex;
            }
            this.symmetryEquivPos.add(str);
        }
        return --count;
    }

    private int loopExpanderUnDef(ArrayList al, int count) {
        String line;
        while (++count < al.size() && (line = (String)al.get(count)).charAt(0) == '_') {
        }
        while (++count < al.size() && !(line = (String)al.get(count)).equalsIgnoreCase("loop_") && line.charAt(0) != '_') {
        }
        return --count;
    }

    private void setCrystalSystem(String str) {
        Pattern p = Pattern.compile("'(.*)'");
        Matcher m = p.matcher(str);
        if (m.find()) {
            System.out.println("Warning : _symmetry_cell_setting is surrouned by \"'\".");
            str = m.group(1);
        }
        if (str.equalsIgnoreCase("triclinic")) {
            this.crystalSystem = CrystalSystem.TRICLINIC;
        } else if (str.equalsIgnoreCase("monoclinic")) {
            this.crystalSystem = CrystalSystem.MONOCLINIC;
        } else if (str.equalsIgnoreCase("orthorhombic")) {
            this.crystalSystem = CrystalSystem.ORTHORHOMBIC;
        } else if (str.equalsIgnoreCase("tetragonal")) {
            this.crystalSystem = CrystalSystem.TETRAGONAL;
        } else if (str.equalsIgnoreCase("rhombohedral")) {
            this.crystalSystem = CrystalSystem.RHOMBOHEDRAL;
        } else if (str.equalsIgnoreCase("trigonal")) {
            this.crystalSystem = CrystalSystem.TRIGONAL;
        } else if (str.equalsIgnoreCase("hexagonal")) {
            this.crystalSystem = CrystalSystem.HEXAGONAL;
        } else if (str.equalsIgnoreCase("cubic")) {
            this.crystalSystem = CrystalSystem.CUBIC;
        } else {
            System.out.println("Unknown crystal system: " + str + "\n" + "Ignore '_system_cell_setting' tag.");
        }
    }

    private void setHermannMauguin(String line) {
        StringTokenizer st1 = new StringTokenizer(line, DELIMITER);
        st1.nextToken();
        StringTokenizer st2 = new StringTokenizer(line, "'");
        st2.nextToken();
        if (st2.hasMoreTokens()) {
            this.HM = st2.nextToken();
        } else {
            System.out.println("Warning : The element of _symmetry_space_group_name_H-M is not surrounded by \"'\".");
            this.HM = st1.nextToken();
        }
    }

    CrystalSystem getCrystalSystem() {
        return this.crystalSystem;
    }

    private void check() throws PmodelException {
        int i;
        if (this.atomList.size() == 0) {
            PmodelException ex = new PmodelException();
            ex.message = "No Atom exist.";
            throw ex;
        }
        double temp = 1.0;
        for (i = 0; i < 3; ++i) {
            temp *= this.cellLength[i];
        }
        if (temp == 0.0) {
            PmodelException ex = new PmodelException();
            ex.message = "Bad Cell Length.";
            throw ex;
        }
        temp = 1.0;
        for (i = 0; i < 3; ++i) {
            temp *= this.cellAngle[i];
        }
        if (temp == 0.0) {
            PmodelException ex = new PmodelException();
            ex.message = "Bad Cell Angle.";
            throw ex;
        }
    }

    private double toDoubleIgnoreESD(String str) throws PmodelException {
        String r = str.replaceAll("\\(\\d+\\)", "");
        return Double.parseDouble(r);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LoopType {
        ATOM,
        OPERATOR,
        UNDEFINED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CrystalSystem {
        TRICLINIC,
        MONOCLINIC,
        ORTHORHOMBIC,
        TETRAGONAL,
        TRIGONAL,
        RHOMBOHEDRAL,
        HEXAGONAL,
        CUBIC,
        UNDEFINED;

    }
}

